/*
 * Copyright (C) 2006-2007	Andre Beckedorf
 * 					 		<evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PLAYLISTOVERVIEW_H_INCLUDED
#define PLAYLISTOVERVIEW_H_INCLUDED

#include <qobject.h>

#ifdef QT4
#include <QShowEvent>
#include <QEvent>
#include <QLabel>

#include <classcompathack.h>

#else
#include <qhbox.h>
#include <qlistbox.h>
class QVBox;
#endif

#include "skinmanager.h"
#include "playlistview.h"
#include "playlistaspectoverviewfilter.h"

class QWidget;
class QLabel;

class PlayListOverview: public QHBox
{
	Q_OBJECT
public:
	PlayListOverview(QWidget *parent = 0);
	virtual ~PlayListOverview();

	void attachTo(PlayListAspectOverviewFilter *source);
	void detach();
	PlayListAspectOverviewFilter *aspectSource() { return aspectSource_; }

	void setSkinMode(const SkinModeInformation &modeInfo);

	QListBox::SelectionMode selectionMode() { return genreListBox_->selectionMode(); }
	void setSelectionMode(QListBox::SelectionMode mode);

signals:
	void focusOutLeft();
	void focusOutRight();

protected:
	void showEvent(QShowEvent *);
	void hideEvent(QHideEvent *);
	bool eventFilter(QObject *, QEvent *);

private slots:
	void validateSelection(QListBox *list);

	void genreListBoxSelectionChanged();
	void artistListBoxSelectionChanged();
	void albumListBoxSelectionChanged();

	void genreListUpdated();
	void artistListUpdated();
	void albumListUpdated();

private:
	MediaDatabase *mediaDatabase_;
	PlayListAspectOverviewFilter *aspectSource_;

	bool isDirty_;

	bool updatingGenres_;
	bool updatingArtists_;
	bool updatingAlbums_;

	QVBox *genreBox_;
	QVBox *artistBox_;
	QVBox *albumBox_;

	QLabel *genreHeading_;
	QLabel *artistHeading_;
	QLabel *albumHeading_;

	QListBox *genreListBox_;
	QListBox *artistListBox_;
	QListBox *albumListBox_;

	void createColumnBox(QString title, QVBox *&box, QLabel *&heading, QListBox *&listbox);

	void beginUpdateOn(QWidget *widget);
	void endUpdateOn(QWidget *widget);

	QString buildFilter(QListBox *list, const QString &unknown);
	int selectionCount(QListBox *list);
	void createFilteredTable(const QString &selectedFilter, const QString &srctable, const QString &dsttable, const QString &what, const QString &wherecol);

	void doUpdateOnListBox(QListBox *listbox, OverviewFilterList &list);
	void transferSelectionToList(OverviewFilterList &list, QListBox *listbox);
};

#endif // PLAYLISTOVERVIEW_H_INCLUDED
