/*
 * Copyright (C) 2006-2007	Andre Beckedorf
 * 					 		<evilJazz _AT_ katastrophos _DOT_ net>
 *
 * The few remaining parts in this almost completely rewritten file are
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PLAYLIST_H_INCLUDED
#define PLAYLIST_H_INCLUDED

#include <qlist.h>
#include <qwidget.h>
#include <qpoint.h>

#ifdef QT4
#include <QKeyEvent>
#include <QPixmap>
#include <QResizeEvent>
#include <QMouseEvent>

#include <classcompathack.h>

#else

#include <qvaluelist.h>
#include <qpopupmenu.h>
#include <qdict.h>
#include <qlistview.h>

#ifdef QTOPIA
#include "compat/sharp-qtopia/qt/qlistview.h"
#else
#include <qlistview.h>
#endif
#endif

#include "kineticlistview.h"
#include "mediadatabase.h"
#include "media.h"
#include "playlistaspectlistviewrenderer.h"

class Media;
class PlayListView;
class PlaybackController;
class SkinModeInformation;
class PlayListViewItem;

#ifdef QT4
typedef QList<PlayListViewItem *> PlayListViewItemList;
#else
typedef QList<PlayListViewItem> PlayListViewItemList;
#endif

class PlayListViewItem: public QListViewItem
{
public:
	PlayListViewItem(PlayListItem *item, int index, QListView *parent);
	PlayListViewItem(PlayListItem *item, int index, QListView *parent, QListViewItem *after);
	virtual ~PlayListViewItem() { }

	Media *media() const { return item_->media(); }

	QString key(int column, bool ascending) const;
	void paintFocus(QPainter * p, const QColorGroup & cg, const QRect & r);
	void paintCell(QPainter * p, const QColorGroup & cg, int column, int width, int align);
	int width( const QFontMetrics& fm, const QListView* lv, int c ) const;

	void setSelected(bool selected);

	inline unsigned long id() { return item_->id(); }
	inline void setID(unsigned long newID) { item_->setID(newID); }
	inline unsigned long mediaID() { return item_->mediaID(); }
	inline void setMediaID(unsigned long newID) { item_->setMediaID(newID); }

	inline int index() { return index_; }

private:
	friend class PlayListView;
	PlayListItem *item_;
	int index_;
};

class PlayListView: public KineticListView
{
	Q_OBJECT
public:
	enum Columns {
		COLUMN_NONE = 0,
		COLUMN_TRACKNO = 1,
		COLUMN_TITLE = 2,
		COLUMN_ARTIST = 3,
		COLUMN_ALBUM = 4,
		COLUMN_LENGTH = 5,
		COLUMN_MAX = 6
	};

	enum InputMode {
		Select = 0,
		MultiSelect = 1,
		Move = 2
	};

	PlayListView(QWidget *parent = 0);
	virtual ~PlayListView();

	void attachTo(PlayListAspectListViewRenderer *source, PlaybackController *controller);
	void detach();
	PlayListAspectListViewRenderer *aspectSource() { return aspectSource_; }

	void beginUpdate();
	void endUpdate();

	PlayListView::InputMode inputMode() { return inputMode_; }
	void setInputMode(PlayListView::InputMode inputmode);

	int selectedItemsCount() { return selectedItems_.count(); }
	MediaIDList getSelectedMediaIDs();
	PlayListIDList getSelectedItemIDs();
	MediaList getSelectedMedia();

	void selectAll() { QListView::selectAll(true); }
	void clearSelection() { QListView::selectAll(false); }

	PlayListItem *currentPlayListItem() { return currentItem() ? static_cast<PlayListViewItem *>(currentItem())->item_ : NULL; }

	void makeItemVisibleByID(unsigned long playListID, bool selectItem = false);

	void insertMediaIDsAtCurrentIndex(const MediaIDList &srcMediaIDs);

	void setBackgroundColors(const QColor &evenColor, const QColor &oddColor);
	void setForegroundColor(const QColor &textColor);
	void setPlayIndicatorImage(const QPixmap &image);
	void setPauseIndicatorImage(const QPixmap &image);
	void setErrorIndicatorImage(const QPixmap &image);

	void setAutoScaleColumnsEnabled(bool value);
	bool autoScaleColumnsEnabled() { return autoScaleColumnsEnabled_; }

#ifdef QT4
	void setPopupMenu(QMenu *popupMenu) { popupMenu_ = popupMenu; }
	QMenu *popupMenu() const { return popupMenu_; }
#else
	void setPopupMenu(QPopupMenu *popupMenu) { popupMenu_ = popupMenu; }
	QPopupMenu *popupMenu() const { return popupMenu_; }
#endif

	void saveColumnOrder(const QString &configName, const QString &groupName);
	void saveColumnWidth(const QString &configName, const QString &groupName);
	void loadColumnOrder(const QString &configName, const QString &groupName);
	void loadColumnWidth(const QString &configName, const QString &groupName);

	void setSkinMode(const SkinModeInformation &modeInfo);

	void triggerPlaybackIntent() { emit playbackIntent(); }

signals:
	void playbackIntent();
	void currentIndexChanged();

public slots:
	void removeSelectedItems();

protected:
	void keyPressEvent(QKeyEvent*);
	void resizeEvent(QResizeEvent *);
	void contentsMousePressEvent(QMouseEvent *e);
	void contentsMouseMoveEvent(QMouseEvent *e);
	void contentsMouseReleaseEvent(QMouseEvent *e);
	void setSorting(int column, bool ascending = TRUE);

private slots:
	void graphExecutionStarted(bool &stopIt);
	void updateView();
	void headerIndexChange(int section, int fromIndex, int toIndex);
	void headerSizeChange(int section, int oldSize, int newSize);
	void headerClicked(int section);
	void playbackControllerActiveItemChanged(int newActiveItemIndex, int oldActiveItemIndex);
	void updateSelectedPlayListItem();

private:
	PlayListAspectListViewRenderer *aspectSource_;
	PlaybackController *playbackController_;

	int updateCount_;

	friend class PlayListViewItem;

	bool autoScaleColumnsEnabled_;
	QValueList<float> headerSectionSizes_;
	bool userIsResizingSection_;
	bool autoResizingSections_;

	QColorGroup evenRowColorGroup_;
	QColorGroup oddRowColorGroup_;
	const QPixmap *playIndicatorImage_;
	const QPixmap *pauseIndicatorImage_;
	const QPixmap *errorIndicatorImage_;

	PlayListViewItem *activeItem_;

	InputMode inputMode_;

	bool itemOrderDirty_;

	bool buttonDown_;
	QPoint buttonDownPos_;
	bool moveTriggered_;

	PlayListViewItemList selectedItemsForMove_;
	PlayListViewItemList selectedItems_;

#ifdef QT4
	QMenu *popupMenu_;
#else
	QPopupMenu *popupMenu_;
#endif

	void ensurePlayListOrderIsValid();

	void itemSelectedStateChanged(PlayListViewItem *item, bool selected);
	void updateDynamicSectionSizes();
	void setAutoSectionSizes();
	void updateResizabilityOfSections();

	PlayListViewItemList &selectedItems();
	PlayListViewItem *lastItem();
	PlayListViewItem *firstItem();

	// Look up items
	PlayListViewItem *findItemByIndex(int index);
	PlayListViewItem *findItemByID(unsigned long playlistID);

	int itemIndex(QListViewItem* item);
};

#endif	// PLAYLIST_H_INCLUDED
