/*
 * configview.h
 *
 *  Created on: 01.03.2009
 *      Author: darkstar
 */

#ifndef CONFIGVIEW_H_
#define CONFIGVIEW_H_

#ifdef QT4
#include <classcompathack.h>
#else
#include <qscrollview.h>
#endif

#include "configuration.h"

class BaseConfigView
{
public:
	BaseConfigView(Configuration& configuration);
	virtual ~BaseConfigView();

	virtual Configuration& config() { return config_; }

	virtual void setStatesByConfiguration(const Configuration& config);
	virtual void saveStatesToConfiguration();

protected:
	friend class ConfigurationDialog;
	virtual void createWidgets();

private:
	Configuration& config_;
};

class ConfigWidget : public QWidget, public BaseConfigView
{
public:
	ConfigWidget(Configuration& configuration, QWidget *parent = 0, const char *name = 0);
	virtual ~ConfigWidget();
};

class ConfigView : public QScrollView, public BaseConfigView
{
public:
	ConfigView(Configuration& configuration, QWidget *parent = 0, const char *name = 0);
	virtual ~ConfigView();
};

#endif /* CONFIGVIEW_H_ */
