#include <qlineedit.h>

#ifdef QT4
#include <classcompathack.h>
#else
#include <qvgroupbox.h>
#include <qhgroupbox.h>
#include <qvbox.h>
#include <qhbuttongroup.h>
#endif

#include <qradiobutton.h>
#include <qpushbutton.h>
#include <qtextcodec.h>
#include <qfileinfo.h>
#include "simplefiledialog.h"
#include "coverartconfig.h"

void CoverArtConfig::setStatesByConfiguration(const Configuration& config)
{
	ConfigView::setStatesByConfiguration(config);

	coverArtDirectory_->setText(config.coverArtDirectory);
	coverArtFlowCacheDirectory_->setText(config.coverArtFlowCacheDirectory);
}

void CoverArtConfig::createWidgets()
{
	ConfigView::createWidgets();

	setFrameStyle(NoFrame);
	setMargin(4);
	setResizePolicy(AutoOneFit);

	vbox_ = new QVBox(viewport());
	vbox_->setSpacing(4);
	addChild(vbox_);

	QHGroupBox *pathGroup = new QHGroupBox(tr("Cover Art location"), vbox_);
	coverArtDirectory_ = new QLineEdit(pathGroup);
	connect(coverArtDirectory_, SIGNAL(textChanged(const QString&)),
			this, SLOT(setCoverArtDirectory(const QString&)));
	QPushButton *openButton = new QPushButton(tr("..."), pathGroup);
	connect(openButton, SIGNAL(clicked()), this, SLOT(execCoverArtDirectoryDialog()));

	QHGroupBox *coverArtFlowGroup = new QHGroupBox(tr("Cover Art Flow Settings"), vbox_);
	coverArtFlowCacheDirectory_ = new QLineEdit(coverArtFlowGroup);
	connect(coverArtFlowCacheDirectory_, SIGNAL(textChanged(const QString&)),
			this, SLOT(setCoverArtFlowCacheDirectory(const QString&)));
	openButton = new QPushButton(tr("..."), coverArtFlowGroup);
	connect(openButton, SIGNAL(clicked()), this, SLOT(execCoverArtFlowCacheDirectory()));
}

void CoverArtConfig::execCoverArtDirectoryDialog()
{
	QString newDirectory = SimpleFileDialog::getExistingDirectory(
		QFileInfo(coverArtDirectory_->text()).filePath(),
		this,
		"get cover art directory",
		tr("Please choose a new Cover Art directory"),
		true,
		true
	);

	if (!newDirectory.isNull())
		coverArtDirectory_->setText(newDirectory);
}

void CoverArtConfig::execCoverArtFlowCacheDirectory()
{
	QString newDirectory = SimpleFileDialog::getExistingDirectory(
		QFileInfo(coverArtFlowCacheDirectory_->text()).filePath(),
		this,
		"get cover art flow cache directory",
		tr("Please choose a new Cover Art Flow Cache directory"),
		true,
		true
	);

	if (!newDirectory.isNull())
		coverArtFlowCacheDirectory_->setText(newDirectory);
}
