 /* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <qcheckbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qmessagebox.h>

#ifdef QT4
#include <classcompathack.h>
#else
#include <qvgroupbox.h>
#include <qvbox.h>
#include <qhbox.h>
#endif

#include "generalconfig.h"
#ifdef QTOPIA
#include "batteryplus.h"
#endif

void GeneralConfig::createWidgets()
{
	ConfigView::createWidgets();

	setFrameStyle(NoFrame);
	setMargin(4);
	setResizePolicy(AutoOneFit);

	QVBox *bigbox = new QVBox(viewport());
	bigbox->setSpacing(4);
	addChild(bigbox);

	QVGroupBox *behaviorBox = new QVGroupBox(tr("Behavior"), bigbox);

	automaticallySwitchToPlayInfoEnabled_ = new QCheckBox(tr("Automatically switch to play info upon playback"), behaviorBox);
	connect(automaticallySwitchToPlayInfoEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setAutomaticallySwitchToPlayInfoEnabled(bool)));

	isAskQuitingEnabled_ = new QCheckBox(tr("Show confirmation dialog when quitting application"), behaviorBox);
	connect(isAskQuitingEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setAskQuitingEnabled(bool)));

#ifdef QTOPIA
	registerAsRemoteConMaster_ = new QCheckBox(tr("Register as remote control master (Qtopia restart required)"), behaviorBox);
	connect(registerAsRemoteConMaster_, SIGNAL(toggled(bool)),
			this, SLOT(setRegisterAsRemoteConMaster(bool)));

	broadcastingEnabled_ = new QCheckBox(tr("Broadcast playback status via QCop (for external apps)"), behaviorBox);
	connect(broadcastingEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setQCopBroadcastingEnabled(bool)));
#endif

	createTemporaryPlaybackStatusFile_ = new QCheckBox(tr("Save playback status to temporary file (for external apps)"), behaviorBox);
	connect(createTemporaryPlaybackStatusFile_, SIGNAL(toggled(bool)),
			this, SLOT(setCreateTemporaryPlaybackStatusFile(bool)));

	restorePreviousSessionOnRestartEnabled_ = new QCheckBox(tr("Restore previous session on restart"), behaviorBox);
	connect(restorePreviousSessionOnRestartEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setRestorePreviousSessionOnRestartEnabled(bool)));

#ifdef QTOPIA
	QVGroupBox *bpBox = new QVGroupBox(tr("BatteryPlus"), bigbox);
	isBatteryPlusEnabled_ = new QCheckBox(tr("Enable BatteryPlus support"), bpBox);
	isBatteryPlusEnabled_->setEnabled(g_BatteryPlus.isRunning());
	connect(isBatteryPlusEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setBatteryPlusEnabled(bool)));

	QHBox *whenVideoBox = new QHBox(bpBox);
	new QLabel(tr("When playing video:"), whenVideoBox);
	batteryPlusMode4Video_ = new QComboBox(whenVideoBox);
	insertBatteryPlusModes(batteryPlusMode4Video_);
	connect(batteryPlusMode4Video_, SIGNAL(activated(int)),
			this, SLOT(setBatteryPlusMode4Video(int)));

	QHBox *whenAudioBox = new QHBox(bpBox);
	new QLabel(tr("When playing audio:"), whenAudioBox);
	batteryPlusMode4Audio_ = new QComboBox(whenAudioBox);
	insertBatteryPlusModes(batteryPlusMode4Audio_);
	connect(batteryPlusMode4Audio_, SIGNAL(activated(int)),
			this, SLOT(setBatteryPlusMode4Audio(int)));
#endif

	QVGroupBox *logBox = new QVGroupBox(tr("Logging && Debugging"), bigbox);
	isBackendLoggingEnabled_ = new QCheckBox(tr("Enable logging of backend output to a text file:"), logBox);
	connect(isBackendLoggingEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setBackendLoggingEnabled(bool)));
	backendLogFileName_ = new QLineEdit(logBox);
	connect(backendLogFileName_, SIGNAL(textChanged(const QString&)),
			this, SLOT(setBackendLogFileName(const QString&)));

	QHBox *buttonBox = new QHBox(bigbox);
	QPushButton *compactMediaCache = new QPushButton(tr("Compact media database"), buttonBox);
	connect(compactMediaCache, SIGNAL(clicked()), this, SLOT(confirmCompactMediaDatabase()));
	QPushButton *revertDefault = new QPushButton(tr("Revert to default settings"), buttonBox);
	connect(revertDefault, SIGNAL(clicked()), this, SLOT(confirmRevertDefaultSettings()));
}

void GeneralConfig::setStatesByConfiguration(const Configuration& config)
{
	ConfigView::setStatesByConfiguration(config);

#ifdef QTOPIA
	isBatteryPlusEnabled_->setChecked(config.isBatteryPlusEnabled);
	if (!setBatteryPlusCurrentMode(batteryPlusMode4Video_, config.batteryPlusMode4Video))
		this->config().batteryPlusMode4Video = QString::null;
	batteryPlusMode4Video_->setEnabled(config.isBatteryPlusEnabled);
	if (!setBatteryPlusCurrentMode(batteryPlusMode4Audio_, config.batteryPlusMode4Audio))
		this->config().batteryPlusMode4Audio = QString::null;
	batteryPlusMode4Audio_->setEnabled(config.isBatteryPlusEnabled);

	registerAsRemoteConMaster_->setChecked(config.registerAsRemoteConMaster);
	broadcastingEnabled_->setChecked(config.qcopBroadcastingEnabled);
#endif

	createTemporaryPlaybackStatusFile_->setChecked(config.createTemporaryPlaybackStatusFile);
	restorePreviousSessionOnRestartEnabled_->setChecked(config.restorePreviousSessionOnRestartEnabled);

	isBackendLoggingEnabled_->setChecked(config.isBackendLoggingEnabled);
	backendLogFileName_->setText(config.backendLogFileName);
	backendLogFileName_->setEnabled(config.isBackendLoggingEnabled);

	automaticallySwitchToPlayInfoEnabled_->setChecked(config.automaticallySwitchToPlayInfoEnabled);
	isAskQuitingEnabled_->setChecked(config.isAskQuitingEnabled);
}

#ifdef QTOPIA
void GeneralConfig::insertBatteryPlusModes(QComboBox *combo)
{
	combo->insertItem(tr("No change"));

	if (g_BatteryPlus.isRunning()) {
		QStringList modes(g_BatteryPlus.allModes());
		for (QStringList::ConstIterator it = modes.begin(); it != modes.end(); ++it) {
			combo->insertItem((*it));
		}
	}
}

bool GeneralConfig::setBatteryPlusCurrentMode(QComboBox *combo, const QString& mode)
{
	bool isFound = false;

	if (!mode.isEmpty()) {
		for (int i = 1; i < combo->count() + 1; ++i) {
			if (mode == combo->text(i)) {
				combo->setCurrentItem(i);
				isFound = true;
				break;
			}
		}
	}

	if (!isFound) {
		combo->setCurrentItem(0);
	}

	return isFound;
}
#endif

void GeneralConfig::confirmCompactMediaDatabase()
{
	int ret;
	ret = QMessageBox::warning(this, tr("Confirmation"),
							   tr("Do you wish to compact the media database?"),
							   tr("Do it!"), tr("Cancel"), QString::null,
							   1, 1);
	if (ret == 0)
		emit nukeMediaCacheButtonClicked();
}

void GeneralConfig::confirmRevertDefaultSettings()
{
	int ret;
	ret = QMessageBox::warning(this, tr("Confirmation"),
							   tr("Revert to default settings?"),
							   tr("Revert"), tr("Cancel"), QString::null,
							   1, 1);
	if (ret == 0)
		emit defaultButtonClicked();
}
