/*
 * Copyright (C) 2008 Andre Beckedorf
 * 					  <evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <qpushbutton.h>
#include <qmessagebox.h>
#include <qcombobox.h>
#include <qlayout.h>

#ifdef QT4
#include <classcompathack.h>
#else
#include <qvbox.h>
#include <qgrid.h>
#endif

#include "hotareaconfig.h"

HotAreaConfig::HotAreaConfig(Configuration& config, QWidget *parent, const char *name)
	:	ConfigView(config, parent, name),
		allActions_(gActionManager.allActions())
{
#ifndef QT4
	actionCombos_.setAutoDelete(true);
#endif
}

HotAreaConfig::~HotAreaConfig()
{
#ifdef QT4
	qDeleteAll(actionCombos_);
#endif
}

void HotAreaConfig::createWidgets()
{
	ConfigView::createWidgets();

	QVBoxLayout *mainLayout = new QVBoxLayout(this);
	QGrid *comboGrid = new QGrid(3, this);

	for (int i = 0; i < 9; ++i)
	{
		QComboBox *actionCombo = new QComboBox(false, comboGrid);
		actionCombo->insertItem(tr("<Unassigned>"));

		for (int i = 0; i < allActions_.count(); ++i)
			actionCombo->insertItem(allActions_.at(i)->translatedName());

		connect(actionCombo, SIGNAL(activated(int)), this, SLOT(comboActivated(int)));
		actionCombos_.append(actionCombo);
		actionCombo->setSizePolicy(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Fixed));
	}
	mainLayout->addWidget(comboGrid);

	QPushButton *revertToDefaultHotAreasButton = new QPushButton(tr("Revert to default hot areas"), this);
	connect(revertToDefaultHotAreasButton, SIGNAL(clicked()), this, SLOT(revertToDefaultHotAreas()));
	mainLayout->addWidget(revertToDefaultHotAreasButton);
}

void HotAreaConfig::setStatesByConfiguration(const Configuration& config)
{
	ConfigView::setStatesByConfiguration(config);
	readFromConfiguration(config);
}

void HotAreaConfig::readFromConfiguration(const Configuration& config)
{
	for (int i = 0; i < actionCombos_.count(); ++i)
	{
		QComboBox *actionCombo = actionCombos_.at(i);

		actionCombo->blockSignals(true);
		actionCombo->setCurrentItem(0); // Reset to <Unassigned>...

		if (config.hotKeyMap[Configuration::HOTKEY_CONTEXT_HOTAREAS].contains(i))
		{
			const Action& action(gActionManager.actionByAccelID(config.hotKeyMap[Configuration::HOTKEY_CONTEXT_HOTAREAS][i]));

#ifdef QT4
			int index = actionCombo->findText(action.translatedName());
			if (index > 0)
				actionCombo->setCurrentItem(index);
#else
			QListBoxItem *item = actionCombo->listBox()->findItem(action.translatedName());
			if (item)
			{
				int index = actionCombo->listBox()->index(item);
				actionCombo->setCurrentItem(index);
			}
#endif
		}

		actionCombo->blockSignals(false);
	}
}

void HotAreaConfig::comboActivated(int index)
{
	config().hotKeyMap[Configuration::HOTKEY_CONTEXT_HOTAREAS].clear();

	for (int i = 0; i < actionCombos_.count(); ++i)
	{
		QComboBox *actionCombo = actionCombos_.at(i);
		if (actionCombo->currentItem() > 0)
		{
			const Action& action(*(allActions_.at(actionCombo->currentItem() - 1)));
			config().hotKeyMap[Configuration::HOTKEY_CONTEXT_HOTAREAS].insert(i, action.accelID());
		}
	}
}

void HotAreaConfig::revertToDefaultHotAreas()
{
	int ret;
	ret = QMessageBox::warning(this, tr("Confirmation"),
							   tr("Do you want to revert to the default hot area configuration?"),
							   tr("Revert"), tr("Cancel"), QString::null,
							   1, 1);
	if (ret == 0)
	{
		Configuration workingConfiguration_ = Configuration();
		config().hotKeyMap[Configuration::HOTKEY_CONTEXT_HOTAREAS] = workingConfiguration_.hotKeyMap[Configuration::HOTKEY_CONTEXT_HOTAREAS];
		readFromConfiguration(workingConfiguration_);
	}
}
