/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef HOTKEYCONFIG_H_INCLUDED
#define HOTKEYCONFIG_H_INCLUDED

#include <qwidget.h>
#include <qlist.h>
#include "action.h"
#include "configuration.h"
#include "configview.h"

#ifdef QT4
#include <classcompathack.h>
#else
class QListView;
#endif

class QComboBox;
class QPushButton;

class HotKeyConfig : public ConfigWidget
{
	Q_OBJECT
public:
	HotKeyConfig(Configuration& config, QWidget *parent = 0, const char *name = 0);

	virtual void setStatesByConfiguration(const Configuration& config);

protected:
	virtual void createWidgets();

private slots:
	void addHotKey();
	void removeHotKey();
	void setContext(int c) { currentContext_ = c; }
	void identifyKey();
	void revertToDefaultHotkeys();

private:
	void readFromConfiguration(const Configuration& config);

	ActionList allActions_;

	QComboBox *actionCombo_;
	QPushButton *keyButton_;
	QListView *list;

	int currentContext_;

	// Key config
	int lastKey_;				// last pressed key
};

#endif // HOTKEYCONFIG_H_INCLUDED
