#include <qcombobox.h>
#include <qspinbox.h>
#include <qstringlist.h>
#include <qlabel.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qspinbox.h>

#ifdef QT4
#include <classcompathack.h>
#else
#include <qvbox.h>
#include <qhbox.h>
#include <qvgroupbox.h>
#endif

#include "uiconfig.h"
#include "skinmanager.h"

UIConfig::UIConfig(Configuration &conf, QWidget *parent, const char *name)
	:	ConfigView(conf, parent, name)
{
}

void UIConfig::setStatesByConfiguration(const Configuration &conf)
{
	ConfigView::setStatesByConfiguration(conf);

	changePlayInfoLayoutInPortaitMode_->setChecked(conf.changePlayInfoLayoutInPortaitMode);
	playlistAutoTriggerFilterInterval_->setValue(conf.playlistAutoTriggerFilterInterval);

	touchModeEnabled_->setChecked(conf.isTouchModeEnabled);
	kineticScrollingEnabled_->setChecked(conf.isKineticScrollingEnabled);

	// Set Skin
	for (int i = 0; i != skinList1->count(); ++i)
		if (skinList1->text(i) == conf.skin1)
			skinList1->setCurrentItem(i);

	for (int i = 0; i != skinList2->count(); ++i)
		if (skinList2->text(i) == conf.skin2)
			skinList2->setCurrentItem(i);
}

void UIConfig::createWidgets()
{
	ConfigView::createWidgets();

	setFrameStyle(NoFrame);
	setMargin(4);
	setResizePolicy(AutoOneFit);

	QVBox *bigbox = new QVBox(viewport());
	bigbox->setSpacing(4);
	addChild(bigbox);

	// UI behavior
	QVGroupBox *behaviorBox = new QVGroupBox(tr("Behavior"), bigbox);

	QHBox *hbox = new QHBox(behaviorBox);
	hbox->setSpacing(4);

	new QLabel(tr("Auto-trigger search after:"), hbox);
	playlistAutoTriggerFilterInterval_ = new QSpinBox(0, 20000, 50, hbox);
	playlistAutoTriggerFilterInterval_->setSuffix(" ms");
	connect(playlistAutoTriggerFilterInterval_, SIGNAL(valueChanged(int)), this, SLOT(setPlaylistAutoTriggerFilterInterval(int)));

	changePlayInfoLayoutInPortaitMode_ = new QCheckBox(tr("Adjust the play info layout in portrait mode"), behaviorBox);
	connect(changePlayInfoLayoutInPortaitMode_, SIGNAL(toggled(bool)),
			this, SLOT(setChangePlayInfoLayoutInPortaitMode(bool)));

	touchModeEnabled_ = new QCheckBox(tr("Optimized Touch/Pen mode"), behaviorBox);
	connect(touchModeEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setTouchModeEnabled(bool)));

	kineticScrollingEnabled_ = new QCheckBox(tr("Smooth Kinetic Scrolling"), behaviorBox);
	connect(kineticScrollingEnabled_, SIGNAL(toggled(bool)),
			this, SLOT(setKineticScrollingEnabled(bool)));

	// Skin
	QVGroupBox *skinBox = new QVGroupBox(tr("Skin"), bigbox);

	// skin selector
	new QLabel(tr("Quickswitch Skin 1 (default): "), skinBox);
	skinList1 = new QComboBox(skinBox);
	connect(skinList1, SIGNAL(activated(const QString&)), this, SLOT(setSkin1(const QString&)));
	findSkin1();

	new QLabel(tr("Quickswitch Skin 2: "), skinBox);
	skinList2 = new QComboBox(skinBox);
	connect(skinList2, SIGNAL(activated(const QString&)), this, SLOT(setSkin2(const QString&)));
	findSkin2();
}

void UIConfig::findSkin1()
{
	SkinManager *skinManager = new SkinManager(qGlobalConfig.skinPath(), this);
	skinList1->insertStringList(skinManager->skinList());
	delete skinManager;
}

void UIConfig::findSkin2()
{
	SkinManager *skinManager = new SkinManager(qGlobalConfig.skinPath(), this);
	skinList2->insertStringList(skinManager->skinList());
	delete skinManager;
}
