#include <qdatetime.h>

#ifdef QT4
#include <QMouseEvent>
#include <classcompathack.h>
#else
#include <qlistview.h>
#endif

class KineticListView : public QListView
{
Q_OBJECT

public:
	KineticListView(QWidget *parent = 0);
	~KineticListView();

	void setKineticScrollingEnabled(bool value);
	bool kineticScrollingEnabled() { return enabled_; }

protected:
	virtual void viewportMouseMoveEvent(QMouseEvent * event);
	virtual void viewportMousePressEvent(QMouseEvent * event);
	virtual void viewportMouseReleaseEvent(QMouseEvent * event);

private slots:
	void doScroll();
	void doMagneticScroll();

private:
	bool enabled_;
	bool mouseDown_;
	int lastYPos_;
	int lastDiff_;
	int startPos_;
	bool mouseMoved_;
	bool continueScrolling_;
	bool isScrolling_;
	QTime startTime_;
	QTime lastUpdateTime_;
	int pixelPerSec_;
	int pixelsLeft_;
	int sign_;
};
