/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef MEDIAINFODIALOG_H_INCLUDED
#define MEDIAINFODIALOG_H_INCLUDED

#ifdef QT4
#include <q3tabdialog.h>
#include <q3textview.h>
#include <QShowEvent>
typedef Q3TabDialog QTabDialog;
typedef Q3TextView QTextView;
typedef Q3MimeSourceFactory QMimeSourceFactory;
#else
#include <qtabdialog.h>
#include <qtextview.h>
#endif

class PlayListView;
class Media;

//! MediaInfoDialogクラスはメディアの情報を表示するダイアログウィジェットです。
class MediaInfoDialog : public QTabDialog
{
	Q_OBJECT

public:
	MediaInfoDialog(PlayListView *, const QString &noCoverImageFilename, QWidget *parent = 0, const char *name = 0);

protected:
	void showEvent(QShowEvent *);

private:
	void setupWidgets();
	void setMedia(Media *media);

	PlayListView *playListView_;
	QTextView *overviewText_;
	QMimeSourceFactory *mimeSourceFactory_;

	QString noCoverImageFilename_;
};

#endif // MEDIAINFODIALOG_H_INCLUDED
