/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <qpainter.h>
#include "operationpanel.h"
#include "skinmanager.h"
#include "skin.h"
#include "skinpanel.h"
#include "skinnedbutton.h"
#include "skinnedtimelabel.h"
#include "seekbar.h"
#include "system_volume.h"

#include "compathack.h"

OperationPanel::OperationPanel(const SkinManager *skinmgr, QWidget *parent)
	: SkinPanel(Skin::Background, skinmgr, parent),
	  seekPosition_(-1),
	  prevSecsValue_(-1)
{
	playButton_ = new SkinnedButton(Skin::Play, skinmgr, this);
	connect(playButton_, SIGNAL(clicked()), this, SIGNAL(playClicked()));

	pauseButton_ = new SkinnedButton(Skin::Pause, skinmgr, this);
	connect(pauseButton_, SIGNAL(clicked()), this, SIGNAL(playClicked()));
	pauseButton_->hide();

	SkinnedButton *b = new SkinnedButton(Skin::Previous, skinmgr, this);
	connect(b, SIGNAL(clicked()), this, SIGNAL(previousClicked()));

	b = new SkinnedButton(Skin::Next, skinmgr, this);
	connect(b, SIGNAL(clicked()), this, SIGNAL(nextClicked()));

	b = new SkinnedButton(Skin::Stop, skinmgr, this);
	connect(b, SIGNAL(clicked()), this, SIGNAL(stopClicked()));

	currentPlayTime_ = new SkinnedTimeLabel(Skin::CurrentPlayTime, skinmgr, this);

	totalPlayTime_ = new SkinnedTimeLabel(Skin::TotalPlayTime, skinmgr, this);

	seekBar_ = new SeekBar(Skin::SeekKnob, skinmgr, this);
	seekBar_->setTracking(false);
	connect(seekBar_, SIGNAL(sliderMoved(int)), this, SLOT(seekBarSliderMoved(int)));
	connect(seekBar_, SIGNAL(sliderReleased()), this, SLOT(seekBarSliderReleased()));
	connect(seekBar_, SIGNAL(sliderStepped(int)), this, SLOT(seekBarSliderStepped(int)));

	volBar_ = new SeekBar(Skin::VolumeKnob, skinmgr, this);
	volBar_->setMinValue(0);
	volBar_->setMaxValue(100);
	volBar_->setPageStep(25);
	volBar_->setValue(qSystemVolume.getCurrentLevel());
	volBar_->setTracking(true);
	connect(volBar_, SIGNAL(sliderMoved(int)), this, SLOT(volBarSliderMoved(int)));
	connect(volBar_, SIGNAL(sliderReleased()), this, SLOT(volBarSliderReleased()));
	connect(volBar_, SIGNAL(sliderStepped(int)), this, SLOT(volBarSliderStepped(int)));
	
	connect(&qSystemVolume, SIGNAL(levelChanged(int)), volBar_, SLOT(setValue(int)));

	hidePlaybackWidgets();
	
#ifdef QTOPIA
	sysChannel_ = new QCopChannel("QPE/System", this);
	connect(sysChannel_, SIGNAL(received(const QCString &, const QByteArray &)),
		this, SLOT(sysMessage(const QCString &, const QByteArray &)) );
#endif
}

OperationPanel::~OperationPanel()
{
}

void OperationPanel::setPlayPause(bool isPlay)
{
	if (isPlay) {
		pauseButton_->hide();
		playButton_->show();
	} else {
		playButton_->hide();
		pauseButton_->show();
	}
}

void OperationPanel::setCurrentPlayTime(int secs)
{
	if (seekPosition_ < 0 && secs != prevSecsValue_)
	{
		currentPlayTime_->setSecond(secs);
		currentPlayTime_->show();
		seekBar_->setValue(secs);
		prevSecsValue_ = secs;
	}
}

void OperationPanel::setTotalPlayTime(int secs)
{
	totalPlayTime_->setSecond(secs);
	totalPlayTime_->show();
	seekBar_->setRange(0, secs);
	prevSecsValue_ = -1;
}

void OperationPanel::showPlaybackWidgets()
{
	currentPlayTime_->show();
	totalPlayTime_->show();
	seekBar_->show();
}

void OperationPanel::hidePlaybackWidgets()
{
	currentPlayTime_->hide();
	totalPlayTime_->hide();
	seekBar_->hide();
}

void OperationPanel::seekBarSliderMoved(int value)
{
	seekPosition_ = value;
	currentPlayTime_->setSecond(value);
	currentPlayTime_->show();
}

void OperationPanel::seekBarSliderReleased()
{
	if (seekPosition_ >= 0) {
		emit seek(seekPosition_);
	}
	seekPosition_ = -1;
}

void OperationPanel::seekBarSliderStepped(int value)
{
	emit seek(value);
	currentPlayTime_->setSecond(value);
	currentPlayTime_->show();
}

void OperationPanel::volBarSliderMoved(int value)
{
	volPosition_ = value;
	qSystemVolume.setLevel(value, false);
}
 
void OperationPanel::volBarSliderReleased()
{
	if (volPosition_ >= 0) {
		qSystemVolume.setLevel(volPosition_);
		emit volume(volPosition_);
	}
}

void OperationPanel::volBarSliderStepped(int value)
{
	volPosition_ = value;
	qSystemVolume.setLevel(value);
	emit volume(value);
}

#ifndef QT4
void OperationPanel::sysMessage(const QCString &msg, const QByteArray &data)
{
#ifdef QTOPIA
	QString message(msg);
	// omit our own signal - the current level might not be written to config file yet...
	if (message.startsWith("volumeChange") && (volPosition_ = -1))
		volBar_->setValue(qSystemVolume.getCurrentLevel());	    
	
	volPosition_ = -1;
#endif	
}
#endif
