/*
 * Copyright (C) 2008 Andre Beckedorf <evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PLAYINFO_H_INCLUDED
#define PLAYINFO_H_INCLUDED

#include <qwidget.h>
#include <qtimer.h>

#ifdef QT4
#include <QResizeEvent>
#endif

#include "paintbox.h"
#include "skinscrollbar.h"
#include "coverartimageprovider.h"
#include "media.h"

class CoverArtLayer;
class HotAreaLayer;

class PlayInfo : public LayeredPaintBox
{
	Q_OBJECT
public:
	PlayInfo(CoverArtImageProvider *imageProvider, const SkinManager *skinmgr, QWidget *parent = 0);
	virtual ~PlayInfo() {}

	void setMediaInfo(const Media&);
	void precacheCoverArt(const Media&);
	void setTrackNumbers(unsigned long trackNo, unsigned long trackCount);
	void setCurrentPlayTime(unsigned long secs);
	void clear();

protected:
	virtual void resizeEvent(QResizeEvent *e);

private slots:
	void imageWasCached(CachedImage *);
	void infoTextTimerTimeout();

private:
	friend class HotAreaLayer;

	TextLayer *title_;
	TextLayer *artist_;
	TextLayer *album_;

	TextLayer *trackNumbers_;

	TextLayer *timePlayed_;
	TextLayer *timeRemaining_;

	TextLayer *info_;
	QTimer infoTimer_;

	CoverArtLayer *coverArt_;
	HotAreaLayer *hotAreaLayer_;

	SkinScrollBar *seekBar_;

	CoverArtImageProvider *imageProvider_;

	unsigned long trackLength_;

	void realignLayers();

	void setPlaybackLayersVisible(bool);
	void setInfoText(const QString &text, bool vanish = true);
};

#endif // PLAYINFO_H_INCLUDED
