/*
 * Copyright (C) 2006-2007	Andre Beckedorf
 * 					 		<evilJazz _AT_ katastrophos _DOT_ net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef PLAYLISTTOOLPANEL_H_INCLUDED
#define PLAYLISTTOOLPANEL_H_INCLUDED

#ifdef QT4
#include <QWidget>
#include <QPushButton>
#include <QLabel>
#include <QFrame>
#include <QString>
#include <QTimer>
#else
#include <qwidget.h>
#include <qbutton.h>
#include <qlabel.h>
#include <qframe.h>
#include <qstring.h>
#include <qtimer.h>
#endif

#include "skinpanel.h"
#include "playlistview.h"
#include "playlistmanager.h"
#include "skinnedbutton.h"

// Forward declarations
class Skin;
class SkinParts;
class SkinnedLabel;
class SkinManager;
class SeekBar;

class PlayListToolPanel : public SkinPanel
{
	Q_OBJECT

public:
	PlayListToolPanel(const SkinManager *, QWidget *parent = 0);
	virtual ~PlayListToolPanel();
	
	void setMode(PlayListManager::Mode mode);	
	void setInputMode(PlayListView::InputMode inputMode);
	
	void setCutEnabled(bool enabled) { setWidgetEnabled(cutButton_, enabled); }
	void setCopyEnabled(bool enabled) { setWidgetEnabled(copyButton_, enabled); }
	void setPasteEnabled(bool enabled) { setWidgetEnabled(pasteButton_, enabled); }
	void setDeleteEnabled(bool enabled) { setWidgetEnabled(deleteButton_, enabled); }
	void setCopyToOTGEnabled(bool enabled) { setWidgetEnabled(copyToOTGButton_, enabled); }
	void setResetFilterAndSortingEnabled(bool enabled) { setWidgetEnabled(resetFilterAndSortingButton_, enabled); }
	void setMoveItemEnabled(bool enabled);
	
signals:
	void modeChanged(PlayListManager::Mode mode);
	void inputModeChanged(PlayListView::InputMode inputMode);
	void copyClicked();
	void cutClicked();
	void pasteClicked();
	void deleteClicked();
	void openPlaylistClicked();
	void savePlaylistClicked();
	void copyToOTGClicked();
	void resetFilterAndSortingClicked();
	
private slots:
	// playlist view:
	void playlistViewOffClicked() { emit modeChanged(PlayListManager::ModeOpenedPlaylist); }
	void dynPlaylistEditorViewOffClicked() { emit modeChanged(PlayListManager::ModeDynPlaylistEditor); }
	void otgPlaylistViewOffClicked() { emit modeChanged(PlayListManager::ModeOnTheGoPlaylist); }
	void modeSingleSelectClicked() { emit inputModeChanged(PlayListView::Select); }
	void modeMultiSelectClicked() { emit inputModeChanged(PlayListView::MultiSelect); }
	void modeMoveItemClicked() { emit inputModeChanged(PlayListView::Move); }
	void copyButtonClicked() { emit copyClicked(); }
	void cutButtonClicked() { emit cutClicked(); }
	void pasteButtonClicked() { emit pasteClicked(); }
	void deleteButtonClicked() { emit deleteClicked(); }
	void openPlaylistButtonClicked() { emit openPlaylistClicked(); }	
	void savePlaylistButtonClicked() { emit savePlaylistClicked(); }
	void copyToOTGButtonClicked() { emit copyToOTGClicked(); }	
	void resetFilterAndSortingButtonClicked() { emit resetFilterAndSortingClicked(); };
	
private:
	SkinnedButton *playlistViewOffButton_;
	SkinnedButton *playlistViewOnButton_;
	
	SkinnedButton *dynPlaylistEditorViewOffButton_;
	SkinnedButton *dynPlaylistEditorViewOnButton_;

	SkinnedButton *otgPlaylistViewOffButton_;
	SkinnedButton *otgPlaylistViewOnButton_;
	
	SkinnedButton *modeSingleSelect_;
	SkinnedButton *modeMultiSelect_;
	SkinnedButton *modeMoveItem_;
	
	SkinnedButton *copyButton_;
	SkinnedButton *cutButton_;
	SkinnedButton *pasteButton_;
	SkinnedButton *deleteButton_;
	
	SkinnedButton *openPlaylistButton_;	
	SkinnedButton *savePlaylistButton_;
	SkinnedButton *copyToOTGButton_;
	SkinnedButton *resetFilterAndSortingButton_;
	
	void setWidgetEnabled(QWidget *widget, bool enabled)
	{
		if (widget->isEnabled() != enabled) 
			widget->setEnabled(enabled);
	}
};

#endif // PLAYLISTTOOLPANEL_H_INCLUDED
