#ifdef USE_NATIVE_FILEDIALOGS
	#include <qfiledialog.h>
#else
	#ifdef QTOPIA
		#include "compat/sharp-qtopia/qt/qregexp.h"
	#else
		#include <qregexp.h>
	#endif
	#include <qfileinfo.h>
	#include "qtkfiledialog.h"
#endif

#include <qapplication.h>

#include "simplefiledialog.h"
#include "configuration.h"
#include "helpers.h"


#ifndef USE_NATIVE_FILEDIALOGS
// Returns the wildcard part of a filter.
static QString extractFilter(const QString& rawFilter)
{
    QString result = rawFilter;

    QRegExp r("([a-zA-Z0-9 ]*)\\(([a-zA-Z0-9_.*? +;#\\[\\]]*)\\)$");

    int index = r.search(result);

    if (index >= 0)
        result = r.cap(2);

    uint i = 0;
    while (i < result.length())
    {
    	if (result[i] == QChar(' '))
    		result[i] = QChar(';');

    	i++;
    }

    return result;
    //return result.replace(QChar(' '), QChar(';'));
}

// Makes a list of filters from ;;-separated text.
static QStringList makeFiltersList(const QString &filter)
{
    QString f(filter);

    if (f.isEmpty())
        f = "All Files (*.*)";

    if (f.isEmpty())
        return QStringList();

    int i = f.find(";;", 0);
    QString sep(";;");

    if (i == -1)
    {
        if (f.find("\n", 0) != -1)
        {
            sep = "\n";
            i = f.find(sep, 0);
        }
    }

    return QStringList::split(sep, f );
}

static QString qtkFileDialogFilter(const QString& filter)
{
    QStringList filterLst = makeFiltersList(filter);
    QStringList::Iterator it = filterLst.begin();
    QString winfilters;

    for (; it != filterLst.end(); ++it)
    {
        winfilters += *it;
        winfilters += "|";
        winfilters += extractFilter(*it);
        winfilters += "|";
    }

    return winfilters;
}
#endif

QString SimpleFileDialog::getOpenFileName(
	const QString & startWith,
	const QString & filter,
	QWidget * parent,
	const char * name,
	const QString & caption,
	QString * selectedFilter,
	bool resolveSymlinks
)
{
#ifdef USE_NATIVE_FILEDIALOGS
#ifdef QT4
	return QFileDialog::getOpenFileName(parent, caption, startWith, filter, selectedFilter, resolveSymlinks ? QFlags<QFileDialog::Option>(0) : QFileDialog::DontResolveSymlinks);
#else
	return QFileDialog::getOpenFileName(startWith, filter, parent, name, caption, selectedFilter, resolveSymlinks);
#endif
#else
	QString result = QString::null;

	QTKFileDialog dialog(parent, name);

	dialog.setCaption(caption); // TODO: Currently ignored...
	dialog.setFilter(qtkFileDialogFilter(filter));
	dialog.setDirectory(startWith);
	dialog.setHomeDirectoryCdUpEnable(true);

	loadWidgetPosition(&dialog, qGlobalConfig.configFilename(), "FileDialog");

	if (dialog.exec() == QDialog::Accepted)
		result = dialog.getFileName();

	saveWidgetPosition(&dialog, qGlobalConfig.configFilename(), "FileDialog");

	return result;
#endif
}

QString SimpleFileDialog::getSaveFileName(
	const QString & startWith,
	const QString & filter,
	QWidget * parent,
	const char * name,
	const QString & caption,
	QString * selectedFilter,
	bool resolveSymlinks
)
{
#ifdef USE_NATIVE_FILEDIALOGS
#ifdef QT4
	return QFileDialog::getSaveFileName(parent, caption, startWith, filter, selectedFilter, resolveSymlinks ? QFlags<QFileDialog::Option>(0) : QFileDialog::DontResolveSymlinks);
#else
	return QFileDialog::getSaveFileName(startWith, filter, parent, name, caption, selectedFilter, resolveSymlinks);
#endif
#else
	QString result = QString::null;

	QTKFileDialog dialog(parent, name);

	dialog.setCaption(caption); // TODO: Currently ignored...
	dialog.setFilter(qtkFileDialogFilter(filter));
	dialog.setDirectory(startWith);
	dialog.setHomeDirectoryCdUpEnable(true);
	dialog.setMkDirButtonDisabled(false);
	dialog.setSaveMode(true);
	dialog.setSaveMode_ReWriteMessageDisabled(false);

	loadWidgetPosition(&dialog, qGlobalConfig.configFilename(), "FileDialog");

	if (dialog.exec() == QDialog::Accepted)
		result = dialog.getFileName();

	saveWidgetPosition(&dialog, qGlobalConfig.configFilename(), "FileDialog");

	return result;
#endif
}

QString SimpleFileDialog::getExistingDirectory(
	const QString & dir,
	QWidget * parent,
	const char * name,
	const QString & caption,
	bool dirOnly,
	bool resolveSymlinks
)
{
#ifdef USE_NATIVE_FILEDIALOGS
#ifdef QT4
	return QFileDialog::getExistingDirectory(parent, caption, dir,
			(resolveSymlinks ? QFlags<QFileDialog::Option>(0) : QFileDialog::DontResolveSymlinks) |
			(dirOnly ? QFileDialog::ShowDirsOnly : QFlags<QFileDialog::Option>(0))
	);
#else
	return QFileDialog::getExistingDirectory(dir, parent, name, caption, dirOnly, resolveSymlinks);
#endif
#else
	QString result = QString::null;

	QTKFileDialog dialog(parent, name);

	dialog.setCaption(caption); // TODO: Currently ignored...
	dialog.setHomeDirectoryCdUpEnable(true);
	dialog.setSystemFile(true);
	dialog.setHiddenFile(true);
	dialog.setDirectorySelectMode(true);

	if (!dir.isEmpty())
		dialog.setDirectory(QFileInfo(dir).filePath());

	loadWidgetPosition(&dialog, qGlobalConfig.configFilename(), "FileDialog");

	if (dialog.exec() == QDialog::Accepted)
		result = dialog.getCurrentDir();

	saveWidgetPosition(&dialog, qGlobalConfig.configFilename(), "FileDialog");

	return result;
#endif
}
