/*
 * skinscrollbar.cpp
 *
 *  Created on: 11.06.2010
 *      Author: darkstar
 */

#ifdef QT4
#include <classcompathack.h>
#endif

#include "skinscrollbar.h"

/* ScrollBarSkinSupport */

ScrollBarSkinSupport::ScrollBarSkinSupport(Skin::PartsType scrollBarType, Skin::PartsType scrollBarSliderType, const SkinManager *skinmgr, PositionedLayer *owner)
	:	QObject(),
		scrollBarType_(scrollBarType),
		scrollBarSliderType_(scrollBarSliderType),
		owner_(owner)
{
	setSkin(skinmgr->skin());
	connect(skinmgr, SIGNAL(skinChanged(const Skin *)), this, SLOT(setSkin(const Skin *)));
}

void ScrollBarSkinSupport::setSkin(const Skin *skin)
{
	skin_ = skin;
	scrollBarParts_ = skin->lookup(scrollBarType_);
	scrollBarSliderParts_ = skin->lookup(scrollBarSliderType_);
}

int ScrollBarSkinSupport::buttonSize()
{
	SkinSections *partsSections = static_cast<SkinSections *>(scrollBarParts_->data());
	return partsSections->at(0)->hitWidth();
}

int ScrollBarSkinSupport::minSliderWidth()
{
	SkinSections *partsSections = static_cast<SkinSections *>(scrollBarParts_->data());
	return partsSections->at(0)->width() + partsSections->at(2)->width();
}

void ScrollBarSkinSupport::paintThreeSectionedParts(QPainter &p, const QRect &dstRect, const SkinParts *parts)
{
	// TODO: Optimize the crap below...

	SkinSections *partsSections = static_cast<SkinSections *>(parts->data());

	SkinSection *leftSection = partsSections->at(0);
	SkinSection *midSection = partsSections->at(1);
	SkinSection *rightSection = partsSections->at(2);

	// Left part
	p.drawPixmap(
		dstRect.left(), dstRect.top(),
		parts->image(),
		leftSection->x(), 0, leftSection->width(), parts->image().height()
	);

	// Mid part
	if (midSection->width() > 0)
	{
		uint drawnWidth = 0;
		uint xToDrawTo = dstRect.left() + midSection->x();

		int drawWidth = dstRect.width() - leftSection->width() - rightSection->width() - 1;

		if (drawWidth > 0)
			while (drawnWidth < drawWidth /* && xToDrawTo < owner_->width() */)
			{
				drawnWidth += midSection->width();

				uint widthToDraw = midSection->width();
				if (drawnWidth > drawWidth)
					widthToDraw -= drawnWidth - drawWidth;

				p.drawPixmap(
					xToDrawTo, dstRect.top(),
					parts->image(),
					midSection->x(), 0, widthToDraw, parts->image().height()
				);

				xToDrawTo += widthToDraw;
			}
	}

	// Right part
	p.drawPixmap(
		QMAX(dstRect.left() + leftSection->width(), dstRect.right() - rightSection->width()), dstRect.top(),
		parts->image(),
		rightSection->x(), 0, rightSection->width(), parts->image().height()
	);
}

void ScrollBarSkinSupport::paintOverlay(QPainter &p, const QRect &geometry, const QRect &slider)
{
	paintThreeSectionedParts(p, geometry, scrollBarParts_);
	paintThreeSectionedParts(p, slider, scrollBarSliderParts_);
}

/* SkinScrollBar */

SkinScrollBar::SkinScrollBar(Skin::PartsType scrollBarType, Skin::PartsType scrollBarSliderType, const SkinManager *skinmgr, LayeredPaintBox *parent)
	:	ScrollBar(parent),
		skinSupport_(scrollBarType, scrollBarSliderType, skinmgr, this)
{
	connect(skinmgr, SIGNAL(skinChanged(const Skin *)), this, SLOT(setSkin(const Skin *)));
}

void SkinScrollBar::paintOverlay(QPainter &p, const QPixmap &pixmap)
{
	skinSupport_.paintOverlay(p, geometry(), rectSlider());
}

/* SkinFlowScrollBar */

SkinFlowScrollBar::SkinFlowScrollBar(Skin::PartsType scrollBarType, Skin::PartsType scrollBarSliderType, const SkinManager *skinmgr, CustomFlow *flow, LayeredPaintBox *parent)
	:	FlowScrollBar(flow, parent),
		skinSupport_(scrollBarType, scrollBarSliderType, skinmgr, this)
{
	connect(skinmgr, SIGNAL(skinChanged(const Skin *)), this, SLOT(setSkin(const Skin *)));
}

void SkinFlowScrollBar::paintOverlay(QPainter &p, const QPixmap &pixmap)
{
	if (itemCount() <= 1)
		return;

	skinSupport_.paintOverlay(p, geometry(), rectSlider());
}
