/*
 * skinscrollbar.h
 *
 *  Created on: 11.06.2010
 *      Author: darkstar
 */

#ifndef SKINSCROLLBAR_H_
#define SKINSCROLLBAR_H_

#include "skin.h"
#include "skinmanager.h"
#include "scrollbar.h"

class ScrollBarSkinSupport : public QObject
{
	Q_OBJECT
public:
	ScrollBarSkinSupport(Skin::PartsType scrollBarType, Skin::PartsType scrollBarSliderType, const SkinManager *skinmgr, PositionedLayer *owner);
	int buttonSize();
	int minSliderWidth();
	void paintOverlay(QPainter &p, const QRect &geometry, const QRect &slider);

protected slots:
	void setSkin(const Skin *skin);

protected:
	Skin::PartsType scrollBarType_;
	Skin::PartsType scrollBarSliderType_;
	const SkinParts *scrollBarParts_;
	const SkinParts *scrollBarSliderParts_;
	const Skin *skin_;
	PositionedLayer *owner_;
	void paintThreeSectionedParts(QPainter &p, const QRect &dstRect, const SkinParts *parts);
};

class SkinScrollBar : public ScrollBar
{
	Q_OBJECT
public:
	SkinScrollBar(Skin::PartsType scrollBarType, Skin::PartsType scrollBarSliderType, const SkinManager *skinmgr, LayeredPaintBox *parent);

protected:
	virtual void paintOverlay(QPainter &p, const QPixmap &pixmap);
	virtual int buttonSize() { return skinSupport_.buttonSize(); }
	virtual int minSliderWidth() { return skinSupport_.minSliderWidth(); }

private slots:
	void setSkin(const Skin *skin) { invalidate(); }

private:
	ScrollBarSkinSupport skinSupport_;
};

class SkinFlowScrollBar : public FlowScrollBar
{
	Q_OBJECT
public:
	SkinFlowScrollBar(Skin::PartsType scrollBarType, Skin::PartsType scrollBarSliderType, const SkinManager *skinmgr, CustomFlow *flow, LayeredPaintBox *parent);

protected:
	virtual void paintOverlay(QPainter &p, const QPixmap &pixmap);
	virtual int buttonSize() { return skinSupport_.buttonSize(); }
	virtual int minSliderWidth() { return skinSupport_.minSliderWidth(); }

private slots:
	void setSkin(const Skin *skin) { invalidate(); }

private:
	ScrollBarSkinSupport skinSupport_;
};

#endif /* SKINSCROLLBAR_H_ */
