/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef SKINMANAGER_H_INCLUDED
#define SKINMANAGER_H_INCLUDED

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qvector.h>
#include <qimage.h>
#include <qfont.h>
#include <qcolor.h>

#ifdef QT4
#include <QPixmap>
#include <config.h>
#else
#ifdef QTOPIA
#include <qpe/config.h>
#else
#include <config.h>
#endif
#endif

class Skin;
class SkinManager;

class SkinColor: public QColor
{
public:
	const bool isUsed() const { return isUsed_; }
	void setUsed(bool value) { isUsed_ = value; }
private:
	bool isUsed_;
};

class SkinFont: public QFont
{
public:
	const bool isUsed() const { return isUsed_; }
	void setUsed(bool value) { isUsed_ = value; }
private:
	bool isUsed_;
};

class SkinModeInformation
{
public:
	struct FontInformation {
		SkinFont font;
		SkinColor fontColor;
	};

	// Toolbar

	const FontInformation toolBarFont() const { return toolBarFont_; }
	const SkinColor& toolBarColor() const { return toolBarColor_; }

	// Playlist

	const FontInformation playListFont() const { return playListFont_; }
	const QPixmap& playListPlayIndicatorImage() const { return playListPlayIndicatorImage_; }
	const QPixmap& playListPauseIndicatorImage() const { return playListPauseIndicatorImage_; }
	const QPixmap& playListErrorIndicatorImage() const { return playListErrorIndicatorImage_; }

	const SkinColor& playListBackgroundColorOdd() const { return playListBackgroundColorOdd_; }
	const SkinColor& playListBackgroundColorEven() const { return playListBackgroundColorEven_; }
	const SkinColor& playListBackgroundColorSelected() const { return playListBackgroundColorSelected_; }
	const SkinColor& playListFontColorSelected() const { return playListFontColorSelected_; }

	const FontInformation playListHeaderFont() const { return playListHeaderFont_; }
	const SkinColor& playListHeaderColor() const { return playListHeaderColor_; }
	const SkinColor& playListScrollBarColor() const { return playListScrollBarColor_; }

	const SkinColor& playListOverviewSeparatorColor() const { return playListOverviewSeparatorColor_; }

	// Playlist overview

	const FontInformation playListOverviewFont() const { return playListOverviewFont_; }
	const SkinColor& playListOverviewBackgroundColor() const { return playListOverviewBackgroundColor_; }
	const SkinColor& playListOverviewBackgroundColorSelected() const { return playListOverviewBackgroundColorSelected_; }
	const SkinColor& playListOverviewFontColorSelected() const { return playListOverviewFontColorSelected_; }

	const FontInformation playListOverviewHeaderFont() const { return playListOverviewHeaderFont_; }
	const SkinColor& playListOverviewHeaderColor() const { return playListOverviewHeaderColor_; }
	const SkinColor& playListOverviewScrollBarColor() const { return playListOverviewScrollBarColor_; }

	// Play info

	const FontInformation playInfoFont() const { return playInfoFont_; }
	const SkinColor& playInfoBackgroundColor() const { return playInfoBackgroundColor_; }

	// Filter edit box

	const FontInformation filterBoxFont() const { return filterBoxFont_; }
	const SkinColor& filterBoxBackgroundColor() const { return filterBoxBackgroundColor_; }
	const SkinColor& filterBoxFontColorFocused() const { return filterBoxFontColorFocused_; }
	const SkinColor& filterBoxBackgroundColorFocused() const { return filterBoxBackgroundColorFocused_; }
private:
	friend class SkinManager;

	FontInformation toolBarFont_;
	SkinColor toolBarColor_;

	FontInformation playListFont_;
	QPixmap playListPlayIndicatorImage_;
	QPixmap playListPauseIndicatorImage_;
	QPixmap playListErrorIndicatorImage_;
	SkinColor playListBackgroundColorOdd_;
	SkinColor playListBackgroundColorEven_;
	SkinColor playListBackgroundColorSelected_;
	SkinColor playListFontColorSelected_;

	FontInformation playListHeaderFont_;
	SkinColor playListHeaderColor_;
	SkinColor playListScrollBarColor_;

	SkinColor playListOverviewSeparatorColor_;

	FontInformation playListOverviewFont_;
	SkinColor playListOverviewBackgroundColor_;
	SkinColor playListOverviewBackgroundColorSelected_;
	SkinColor playListOverviewFontColorSelected_;

	FontInformation playListOverviewHeaderFont_;
	SkinColor playListOverviewHeaderColor_;
	SkinColor playListOverviewScrollBarColor_;

	FontInformation playInfoFont_;
	SkinColor playInfoBackgroundColor_;

	FontInformation filterBoxFont_;
	SkinColor filterBoxBackgroundColor_;
	SkinColor filterBoxFontColorFocused_;
	SkinColor filterBoxBackgroundColorFocused_;
};

class SkinManager : public QObject
{
	Q_OBJECT

public:
	//! SL-Cシリーズが持つ2Wayスタイルの定義
	enum Style {
		Portrait = 0,			//!< ビュースタイル
		Landscape = 1,			//!< インプットスタイル
	};

	enum InfoMode {
		BigMode = 0,
		NormalMode = 1,
		SmallMode = 2
	};

public:
	SkinManager(const QString &skinDir, QObject *parent = 0);
	~SkinManager();

	bool load(const QString &name);

	const QString &activeSkin() const { return activeSkinName_; }
	const QString &activeSkinDirectory() const { return activeSkinDirectory_; }

	QStringList skinList() const;
	const Skin *skin() const { return skins_[style_]; }

	const SkinModeInformation *getInfo(InfoMode mode) const { return info_[mode]; }

	Style style() { return style_; }

public slots:
	void setStyle(Style);
	void refreshSkinList();

signals:
	/*!
	  このシグナルはスキンが変更されたときに発生します。
	  \a skin は新しいスキンへのポインタです。
	 */
	void skinChanged(const Skin *skin);

private:
	bool loadSkinModeInformation(Config &config, const QString &group, const QString &skinDir, InfoMode mode);
	bool readColor(Config &config, const QString &group, const QString &key, SkinColor &color);
	bool readFontInfo(Config &config, const QString &group, const QString &key, SkinModeInformation::FontInformation &fontInfo);
	bool readImage(Config &config, const QString &group, const QString &key, const QString &skinDir, QImage &image);
	bool readPixmap(Config &config, const QString &group, const QString &key, const QString &skinDir, QPixmap &pixmap);

	QString skinDir_;			//!< スキンディレクトリ
	QStringList skinNameList_;	//!< スキンディレクトリに存在するスキンの名前のリスト

	QString activeSkinDirectory_;
	QString activeSkinName_;

	Style style_;				//!< 現在のスタイル
#ifdef QT4
	QVector<Skin *> skins_;
	QVector<SkinModeInformation *> info_;
#else
	QVector<Skin> skins_;
	QVector<SkinModeInformation> info_;
#endif
};

#endif // SKINMANAGER_H_INCLUDED
