/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef QT4
#include <QPainter>
#else
#include <qpainter.h>
#endif

#include "skinnedbutton.h"
#include "skinpanel.h"

/*!
  \class SkinnedButton skinnedbutton.h
  \brief SkinnedButtonクラスはウィジェットの描画にスキンを使うQButtonです。

  \sa Skin
*/

/*!
  スキンパーツの種類を \a type 、初期スキンを \a skin および
  親ウィジェット \a parent と名前 \name を設定してボタンを作成します。
*/
SkinnedButton::SkinnedButton(Skin::PartsType type, const SkinManager *skinmgr, QWidget *parent)
	: QButton(parent),
	  type_(type)
{
#ifdef QT4
	setFocusPolicy(Qt::NoFocus);
	setAutoFillBackground(false);
	setAttribute(Qt::WA_StaticContents, true);
	setAttribute(Qt::WA_OpaquePaintEvent, true);
#else
	setFocusPolicy(NoFocus);
#ifdef QTOPIA
    setBackgroundMode(NoBackground);
	setWFlags(Qt::WRepaintNoErase | Qt::WResizeNoErase);
#else
	setBackgroundMode(Qt::NoBackground);
	setWFlags(Qt::WStaticContents | Qt::WNoAutoErase | Qt::WResizeNoErase);
#endif
#endif
	
	setSkin(skinmgr->skin());
	connect(skinmgr, SIGNAL(skinChanged(const Skin *)), this, SLOT(setSkin(const Skin *)));
	
	if (parent && parent->inherits("SkinPanel"))
		connect(((SkinPanel *)parent), SIGNAL(resized()), this, SLOT(skinPanelResized()));
}

void SkinnedButton::setToggleButton(bool value)
{
#ifdef QT4
	QButton::setCheckable(value);
#else
	QButton::setToggleButton(value);
#endif
}

void SkinnedButton::setOn(bool enable)
{
#ifdef QT4
	QButton::setChecked(enable);
#else
	QButton::setOn(enable);
#endif
}

bool SkinnedButton::isOn()
{
#ifdef QT4
	return QButton::isChecked();
#else
	return QButton::isOn();
#endif
}

/*!
  スキンを \a skin に変更します。

  ボタンの位置とサイズ、および画像は新しいスキンの情報をもとに再設定されます。

  \sa OperationPanel::setSkin()

  \todo 正常に再描画されるかテストする。
*/
void SkinnedButton::setSkin(const Skin *skin)
{
	parts_ = skin->lookup(type_);
	
	if (parentWidget() && parentWidget()->inherits("SkinPanel"))
		skinPanelResized();
	else
		setGeometry(parts_->geometry());
	
	repaint();
}

void SkinnedButton::skinPanelResized()
{
	SkinPanel *parent = (SkinPanel *)parentWidget();
	setGeometry(parent->calculateGeometry(parts_));
}

/*!
  スキンを描画するために再実装されたメソッドです。
*/
#ifdef QT4
void SkinnedButton::paintEvent(QPaintEvent *e)
{
	QPainter painter(this);
	QPainter *p = &painter;
#else
void SkinnedButton::drawButton(QPainter *p)
{
#endif
	const QWidget *parent = parentWidget();

	if (parent && parent->inherits("SkinPanel") && ((SkinPanel *)parent)->backgroundImage())
	{
		const QRect &rect = parts_->geometry();
		p->drawPixmap(0, 0, *((SkinPanel *)parent)->backgroundImage(), rect.x(), rect.y(), rect.width(), rect.height());
	}

	if (parts_->imageCount() > 2 && !isEnabled())
		p->drawPixmap(0, 0, parts_->image(), 2 * width(), 0, width(), -1);
	else if (!isDown() && !isOn())
		p->drawPixmap(0, 0, parts_->image(), 0, 0, width(), -1);
	else
		p->drawPixmap(0, 0, parts_->image(), width(), 0, width(), -1);
}

void SkinnedButton::show()
{
	QButton::show();
	repaint();	
}
