/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <qpainter.h>
#include <qlabel.h>
#include "skinpanel.h"
#include "skinnedlabel.h"

SkinnedLabel::SkinnedLabel(Skin::PartsType type, const SkinManager *skinmgr, QWidget *parent)
	: QLabel(parent),
	  type_(type)
{
#ifdef QT4
	setFocusPolicy(Qt::NoFocus);
	setAutoFillBackground(false);
	setAttribute(Qt::WA_StaticContents, true);
	setAttribute(Qt::WA_OpaquePaintEvent, true);
#else
	setFocusPolicy(NoFocus);
#ifdef QTOPIA
    setBackgroundMode(NoBackground);
	setWFlags(Qt::WRepaintNoErase | Qt::WResizeNoErase);
#else
	setBackgroundMode(Qt::NoBackground);
	setWFlags(Qt::WNoAutoErase | Qt::WResizeNoErase);
#endif
#endif
	
	setSkin(skinmgr->skin());
	connect(skinmgr, SIGNAL(skinChanged(const Skin *)), this, SLOT(setSkin(const Skin *)));
	
	if (parent && parent->inherits("SkinPanel"))
		connect(((SkinPanel *)parent), SIGNAL(resized()), this, SLOT(skinPanelResized()));
}

void SkinnedLabel::setSkin(const Skin *skin)
{
	parts_ = skin->lookup(type_);
	
	if (parentWidget() && parentWidget()->inherits("SkinPanel"))
		skinPanelResized();
	else
		setGeometry(parts_->geometry());
}

void SkinnedLabel::skinPanelResized()
{
	SkinPanel *parent = (SkinPanel *)parentWidget();
	setGeometry(parent->calculateGeometry(parts_));
}

#ifdef QT4
void SkinnedLabel::paintEvent(QPaintEvent *e)
{
	QPainter painter(this);
	QPainter *p = &painter;
#else
void SkinnedLabel::drawContents(QPainter *p)
{
#endif
	const QWidget *parent = parentWidget();

	if (parent->inherits("SkinPanel"))
	{
		p->translate(-x(), -y());
		((SkinPanel *)parent)->paintSkin(*p);
		p->translate(x(), y());
	}
	
#ifdef QT4
	painter.end();
	QLabel::paintEvent(e);
#else
	QLabel::drawContents(p);
#endif
}
