/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <qpainter.h>
#include "skinpanel.h"
#include "skinnedtimelabel.h"

#include "compathack.h"

SkinnedTimeLabel::SkinnedTimeLabel(Skin::PartsType type, const SkinManager *skinmgr, QWidget *parent)
	: QWidget(parent),
	  type_(type),
	  fontWidth_(0),
	  second_(0)
{
#ifdef QT4
	setFocusPolicy(Qt::NoFocus);
	setAutoFillBackground(false);
	setAttribute(Qt::WA_StaticContents, true);
	setAttribute(Qt::WA_OpaquePaintEvent, true);
#else
	setFocusPolicy(NoFocus);
#ifdef QTOPIA
    setBackgroundMode(NoBackground);
	setWFlags(Qt::WRepaintNoErase | Qt::WResizeNoErase);
#else
	setBackgroundMode(Qt::NoBackground);
	setWFlags(Qt::WNoAutoErase | Qt::WResizeNoErase);
#endif
#endif
	
	setSkin(skinmgr->skin());
	connect(skinmgr, SIGNAL(skinChanged(const Skin *)), this, SLOT(setSkin(const Skin *)));
	
	if (parent && parent->inherits("SkinPanel"))
		connect(((SkinPanel *)parent), SIGNAL(resized()), this, SLOT(skinPanelResized()));
}

QSize SkinnedTimeLabel::sizeHint() const
{
	return QSize(fontWidth_ * 8, parts_->geometry().height());
}

QSizePolicy SkinnedTimeLabel::sizePolicy() const
{
	return QSizePolicy(QSizePolicy::Fixed, QSizePolicy::Fixed);
}

void SkinnedTimeLabel::setSecond(int second)
{
	second_ = second;

	int hh = second / (60 * 60);
	int mm = (second / 60) % 60;
	int ss = second % 60;
	if (second < 0)
		format_.sprintf("-%1d:%02d:%02d", hh, mm, ss);
	else
		format_.sprintf("%02d:%02d:%02d", hh, mm, ss);

	repaint();
}

void SkinnedTimeLabel::setSkin(const Skin *skin)
{
	parts_ = skin->lookup(type_);
	fontWidth_ = parts_->geometry().width();
	
	if (parentWidget() && parentWidget()->inherits("SkinPanel"))
		skinPanelResized();
	else
		move(parts_->geometry().x(), parts_->geometry().y());

	setFixedSize(sizeHint());
}

void SkinnedTimeLabel::skinPanelResized()
{
	SkinPanel *parent = (SkinPanel *)parentWidget();
	QRect geometry = parent->calculateGeometry(parts_);
	move(geometry.x(), geometry.y());
}

void SkinnedTimeLabel::paintEvent(QPaintEvent *e)
{
	QPainter painter(this);
	QPainter *p = &painter;

	int len = format_.length();
	int x = 0;
	for (int i = 0; i < len; ++i) {
		char index = format_[i].toLatin1();
		switch (index) {
		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':
			index -= '0';
			break;
		case '-':
			index = 10;
			break;
		case ':':
			index = 11;
			break;
		default:
			index = 0;
		}
		p->drawPixmap(x, 0, parts_->image(), index * fontWidth_, 0, fontWidth_, -1);
		x += fontWidth_;
	}
}
