#ifndef SKINPANEL_H_
#define SKINPANEL_H_

#ifdef QT4
#include <QWidget>
#include <QPushButton>
#include <QLabel>
#include <QFrame>
#include <QString>
#include <QPaintEvent>
#include <QResizeEvent>
#include <QPixmap>
#else
#include <qwidget.h>
#include <qbutton.h>
#include <qlabel.h>
#include <qframe.h>
#include <qstring.h>
#endif

#include "skinmanager.h"
#include "skin.h"

class SkinPanel : public QWidget
{
	Q_OBJECT
	
public:
	SkinPanel(Skin::PartsType type, const SkinManager *, QWidget *parent = 0);
	virtual ~SkinPanel();

	QSize sizeHint() const;
	QSize minimumSizeHint() const { return sizeHint(); }
	QSizePolicy sizePolicy() const;
	
	const QPixmap *backgroundImage() { return backgroundImage_; }
	
	void paintSkin(QPainter &painter);
	const QRect calculateGeometry(const SkinParts *parts) const;
	
signals:
	void resized();
	
public slots:
	virtual void setSkin(const Skin *);

protected:
	Skin::PartsType type_;
	const Skin *skin_;
	const SkinSections *sections_;
	const QPixmap *backgroundImage_;
	
	SkinSections internalSections_;

	void updateSections();
	
	virtual void paintEvent(QPaintEvent *);
	virtual void resizeEvent(QResizeEvent *);	
};

#endif /*SKINPANEL_H_*/
