#include <qwidget.h>
#include <qlayout.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qpushbutton.h>

#ifdef QT4
#include <classcompathack.h>
#else
#include <qtextview.h>
#endif

#include "textviewdialog.h"

TextViewDialog::TextViewDialog(const QString &caption, const QString &msg, const QString &text, const QString &msgBelowText, QString acceptButtonText, QString rejectButtonText, QWidget *parent, const char *name)
	:	QDialog(parent, name, true, 0)
{
	setCaption(caption);
#ifndef QT4
	setWFlags(getWFlags() | Qt::WStyle_SysMenu | Qt::WStyle_Maximize);
#endif
	setSizeGripEnabled(true);

	QVBoxLayout *mainLayout = new QVBoxLayout(this);
	QVBoxLayout *contentLayout = new QVBoxLayout(this, 8);

	QLabel *messageLabel = new QLabel(msg, this);
	QTextView *errorMessageView = new QTextView(text, QString::null, this);
#ifndef WINDOWS
	QFont font = errorMessageView->font();
	font.setPixelSize(10);
	errorMessageView->setFont(font);
#endif
	errorMessageView->setMinimumWidth(300);
	errorMessageView->setMinimumHeight(200);

	contentLayout->addWidget(messageLabel);
	contentLayout->addWidget(errorMessageView);

	if (!msgBelowText.isEmpty())
	{
		messageLabel = new QLabel(msgBelowText, this);
		contentLayout->addWidget(messageLabel);
	}

	if (acceptButtonText.isEmpty())
		acceptButtonText = tr("OK");

	QPushButton *okButton = new QPushButton(acceptButtonText, this);
	connect(okButton, SIGNAL(clicked()), this, SLOT(accept()));

	if (rejectButtonText.isEmpty())
		rejectButtonText = tr("Cancel");

	QPushButton *cancelButton = new QPushButton(rejectButtonText, this);
	connect(cancelButton, SIGNAL(clicked()), this, SLOT(reject()));

	QHBoxLayout *buttonsLayout = new QHBoxLayout(this, 8);
	buttonsLayout->setDirection(QBoxLayout::RightToLeft);
	buttonsLayout->addWidget(okButton, 0);
	buttonsLayout->addWidget(cancelButton, 0);

	mainLayout->addLayout(contentLayout);
	mainLayout->addLayout(buttonsLayout);
}

bool TextViewDialog::exec()
{
	return QDialog::exec() == QDialog::Accepted;
}
