/* -*- mode: c++; tab-width: 4; c-basic-offset: 4 -*- */
/*
 * Copyright (C) 2005 Atmark <atmarkat _AT_ msn _DOT_ com>
 *                    AGAWA Koji <i _AT_ atty _DOT_ jp>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <qfont.h>
#include <qpalette.h>
#include <qcolor.h>
#include <qpoint.h>

#ifdef QT4
#include <QMouseEvent>
#include <QFocusEvent>
#endif

#include <unistd.h>
#include <stdlib.h>

#ifdef WINDOWS
#include "wincompat.h"
#endif

#include "videoplaybackwindow.h"

VideoPlaybackWindow::VideoPlaybackWindow(QWidget *parent)
	: QWidget(parent),
	  step_(-1)
{
#ifdef QT4
	timer_.setSingleShot(true);
#else
	setWFlags(Qt::WStyle_Customize | Qt::WStyle_NoBorder | Qt::WStyle_StaysOnTop);
	setBackgroundColor(QColor(0, 0, 0));
#endif
}

void VideoPlaybackWindow::focusInEvent(QFocusEvent *)
{}

void VideoPlaybackWindow::focusOutEvent(QFocusEvent *)
{
	showNormal();
	
	usleep(100000);
	lower();
	raise();
	
	usleep(100000);
	showFullScreen();
}

void VideoPlaybackWindow::mousePressEvent(QMouseEvent *e)
{
	lastMousePosition_ = e->pos();
	emit seekStart();
}

void VideoPlaybackWindow::mouseReleaseEvent(QMouseEvent *e)
{
	emit seekEnd();
	if (abs(lastMousePosition_.x() - e->pos().x()) > 16) {
		emit seekAbsolutePercentage(step_);
	}
}

void VideoPlaybackWindow::mouseMoveEvent(QMouseEvent *e)
{
	step_ = e->pos().x() * 100 / width() - 1;
	if (!timer_.isActive()) {
		emit seekSliderMoved(step_);
#ifdef QT4
		timer_.start(300);
#else
		timer_.start(300, true);
#endif
	}
}
