/*
 $Revision: 1.31.4.3 $
 $Date: 2004/09/22 13:04:26 $
*/
#include "bookreader.h"

#include <qwidget.h>
#include <qpainter.h>
#include <qpe/qpeapplication.h>
#include <qfile.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#define XMD_H
#include <jpeglib.h>
#include <setjmp.h>


/* 
 *  Constructs a Example which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
BookReader::BookReader( const BR_Option opt)
  : QWidget( 0, "BookReader", WStyle_Customize | WStyle_NoBorderEx),
    option(opt)
{

  brControl = 0;
  my_has_fullscreen = false;
  setBackgroundMode(NoBackground);

  fileListIt = option.filelist->find(option.filename); // first image

  //
  // save standard option
  //
  org_ratio = option.ratio;
  org_centX = option.cent_X;
  org_centY = option.cent_Y;
  org_autoscale = option.autoscale;

  //
  // set initial rotation mode
  //
  if(option.rot){
    setMinimumSize(640,480);
    imageRotation = true;
    option.cent_X = org_centX; option.cent_Y = org_centY;
  }else{
    setMinimumSize(480,640);
    imageRotation = false;
    option.cent_X = org_centY; option.cent_Y = org_centX;
  }

  //
  // initialize nibble mode
  //
  switch (option.nibble_mode) {
  case NIB_AutoHoriz:
    option.autoscale = AS_Height;
    option.nibble_V = 1;           // Delete Vertical divider 
  case NIB_Horiz:
    horizPrimary = true;
    break;

  case NIB_AutoVert:
    option.autoscale = AS_Width;
    option.nibble_H = 1;           // Delete Horizonal divider 
  case NIB_Vert:
    horizPrimary = false;
    break;

  case NIB_None:
  default:
    horizPrimary = false;          // Standerd Vertical nibble mode
    option.nibble_H = 1;           // Delete Horizonal divider 
    option.nibble_V = 1;           // Delete Vertical divider 
    break;
  }

  nibMax[true] = option.nibble_H;  // Horizonal divider
  nibMax[false] = option.nibble_V; // Vertical divider

  my_nib[true] = 1;                // Current Horizonal posision for nibble mode
  my_nib[false] = 1;               // Current Vertical posision for nibble mode



  //
  // keyboard grab
  //
  QPEApplication::grabKeyboard();
  qApp->processEvents();

  option.ratio = loadJpeg( org_ratio  );

}

/*  
 *  Destroys the object and frees any allocated resources
 */

BookReader::~BookReader()
{

}

void BookReader::closeEvent(QCloseEvent *)
{
  if(option.auto_bookmark)
    makeBookmark();
  emit closed();
}

void BookReader::makeBookmark()
{
  //
  //make bookmark file and save filename
  //
  QFile f(option.dir_name+"/.bookmark");
  if ( f.open(IO_ReadWrite) ){
    f.writeBlock(( *fileListIt).latin1(), (*fileListIt).length() );
    f.writeBlock("\n", 1);
    f.close();
  }
}


void BookReader::focusInEvent(QFocusEvent *)
{
  // Always do it here, no matter the size.
    enableFullscreen();
}

void BookReader::paintEvent( QPaintEvent * )
{
    
  my_painter = new QDirectPainter(this);
  short *fb = (short*)my_painter->frameBuffer();
  short *src = (short*)paintImage.bits();
  

  if( brControl !=0){

    int brLeft;
    int brRight;
    int brTop;
    int brBottom;

    int bottom;
    int right;
    
    //
    //calculate control widget size with border line
    //Not paint taskbar.
    //
    if(option.rot){
      brLeft = brControl->geometry().left()-5;
      brRight = brControl->geometry().right()+5;
      brTop = brControl->geometry().top()-34;
      brBottom = brControl->geometry().bottom()+6;
      bottom = 38; right = 640;
    }else{
      brBottom = 480-brControl->geometry().left()+5;
      brTop = 480-brControl->geometry().right()-5;
      brLeft = brControl->geometry().top()-34;
      brRight = brControl->geometry().bottom()+6;
      bottom = 0; right = 602;
    }

    //
    // repaint using direct painter for showing controler
    // and taskbar
    //
    for(int y=0;y <640; y++){
      for(int x=0;x <480; x++){
	if ( (y > brLeft) && (y < brRight) && 
	     (x > 480-brBottom) &&(x < 480-brTop) ||
	     (x < bottom ) || (y > right)){
	  fb++;
	  src++;
	}else{
	  *fb++=*src++;
	}
      }
    }
  }else{

    //
    // repaint full screen
    //
    for(int i=0;i <640*480; i++){
      *fb++=*src++;
    }
  }

  delete my_painter;
  my_painter=0;
  
}

void BookReader::mousePressEvent( QMouseEvent *e)
{
  //
  // memory press point
  //
  if( (option.rot ^ imageRotation) ){
    prev_x = e->globalY();
    prev_y = e->globalX();
  }else{
    prev_x = e->globalX();
    prev_y = e->globalY();
  }
  
}

void BookReader::mouseReleaseEvent( QMouseEvent *e)
{

  //
  // select file area check
  //
  if (option.rot && (e->globalY() >450)){
    if(e->globalX() >320){
      prevImage();
    }else{
      nextImage();
    }
  }else if( (!option.rot) && (e->globalY() >610)){
    if(e->globalX() >240){
      prevImage();
    }else{
      nextImage();
    }
  }else{

    //
    // calculate mouse move posision 
    //
    int tmp_x;
    int tmp_y;
    if( (option.rot ^ imageRotation) ){
      if (option.rot){
      tmp_x = prev_x - e->globalY();
      tmp_y = e->globalX() - prev_y;
      }else{
      tmp_x = e->globalY() - prev_x;
      tmp_y = prev_y - e->globalX();
      }
    }else{
      tmp_x = e->globalX() - prev_x;
      tmp_y = e->globalY() - prev_y;
    }
    if( (((tmp_x * tmp_x) + (tmp_y * tmp_y)) > 20) && (brControl == 0) ){
      option.cent_X += tmp_x;
      option.cent_Y += tmp_y;
      if(imageRotation)
	makePaintImageR();
      else
	makePaintImage();
      repaint();
    }
  }

}

void BookReader::mouseDoubleClickEvent( QMouseEvent *)
{
  brControlCreate();
}

void BookReader::brControlCreate()
{

  //
  // show controler
  //
  if (brControl == 0){
    brControl = new BRControl(option, this);
    connect(brControl, SIGNAL(apply()), this, SLOT(testView()) ); 
    connect(brControl, SIGNAL(bookmark()), this, SLOT(makeBookmark()) );
    brControl->show();

    int ok = brControl->exec();
    if (ok == 999){
      delete brControl;
      brControl = 0;
      close();
      return;
    }
    option.cent_X = brControl->getCenter_X(ok);
    option.cent_Y = brControl->getCenter_Y(ok);
    option.bgcolor = brControl->getBGColor(ok);
    option.ratio = brControl->getScale(ok);
    option.autoscale = brControl->getAutoScale(ok);

    delete brControl;
    brControl = 0;
    my_has_fullscreen = false;
    enableFullscreen();
    option.ratio = loadJpeg(option.ratio);
    makePaintImage();
    
  }
}

void BookReader::testView()
{
  //
  // contorler test view mode
  //
  if (brControl != 0){
    option.cent_X = brControl->getCenter_X(true);
    option.cent_Y = brControl->getCenter_Y(true);
    option.bgcolor = brControl->getBGColor(true);
    option.ratio = brControl->getScale(true);
    option.autoscale = brControl->getAutoScale(true);

    option.ratio = loadJpeg(option.ratio);
    makePaintImage();
    brControl->setScale(option.ratio);

  }
}


void BookReader::QueueKey(QKeyEvent *e, int pressed)
{

  //
  // cover close event
  //
  if(e->key() == 0x2009){
    close();
    return;
  }

  //
  //normal key event
  //
  if (pressed){
    switch(e->key()){
    case Key_Escape:
      close();
      return;
      break;
    case Key_R:
      rotationImage();
      break;
    case Key_Q:
      option.ratio+=5;
      if(option.ratio >100)
	option.ratio = 100;
      option.autoscale = AS_None;
      option.ratio = loadJpeg(option.ratio);
      makePaintImage();
      break;
    case Key_W:
      option.ratio-=5;
      if(option.ratio < 10)
	option.ratio = 10;
      option.autoscale = AS_None;
      option.ratio = loadJpeg(option.ratio);
      makePaintImage();
      break;
    case Key_A:
      option.autoscale = AS_Both;
      option.ratio = loadJpeg(100);
      
      makePaintImage();
      break;
    case Key_Up:
      prevImage();
      break;
    case Key_Down:
      nextImage();
      break;
      
    }
  }
  
}

void BookReader::rotationImage()
{
  
  //
  //rotation image and convert center XY
  //
  int tmp_swap;
  if (imageRotation){
    imageRotation = FALSE;
    tmp_swap = option.cent_X; 
    option.cent_X = 480- option.cent_Y;
    option.cent_Y = tmp_swap;
  }else{
    imageRotation = TRUE;
    tmp_swap = option.cent_X; 
    option.cent_X = option.cent_Y; 
    option.cent_Y = 480 - tmp_swap;
  }
  
  makePaintImage();
  
}

//
// select next file and view image
//
void BookReader::nextImage()
{
  //
  // move nibble posision
  //
  my_nib[horizPrimary]++;
  if(my_nib[horizPrimary] > nibMax[horizPrimary]){
    my_nib[horizPrimary] = 1;
    my_nib[!horizPrimary]++;
    if(my_nib[!horizPrimary] > nibMax[!horizPrimary]){
      my_nib[!horizPrimary] = 1;

      //
      // move to next file 
      //
      fileListIt++;
      if ( fileListIt == option.filelist->end()){
	fileListIt--;
      }else{
	if(option.rot == true){
	  imageRotation = true;
	  option.cent_X = org_centX; option.cent_Y = org_centY;
	}else{
	  imageRotation = false;
	  option.cent_X = org_centY; option.cent_Y= org_centX;
	}
	option.ratio = loadJpeg( org_ratio );
      }
      return;
    }
  }
  makePaintImage();
}

//
// select previous file and view image
//
void BookReader::prevImage()
{
  // move nibble posision
  my_nib[horizPrimary]--;
  if(my_nib[horizPrimary] <= 0){
    my_nib[horizPrimary] = nibMax[horizPrimary];
    my_nib[!horizPrimary]--;
    if(my_nib[!horizPrimary] <= 0){
      my_nib[!horizPrimary] = nibMax[!horizPrimary];

      //
      // move to previous file
      //
      if ( fileListIt != option.filelist->begin()){
	fileListIt--;
	if(option.rot == true){
	  imageRotation = true;
	  option.cent_X = org_centX; option.cent_Y = org_centY;
	}else{
	  imageRotation = false;
	  option.cent_X = org_centY; option.cent_Y = org_centX;
	}
	option.ratio = loadJpeg( org_ratio );
      }
      return;
    }
  }
  makePaintImage();
}


int BookReader::loadJpeg(int my_ratio)
{
  //
  //  load selected jpeg file and view
  //
  my_ratio = loadJpegFile( (option.dir_name +"/"+ *fileListIt).utf8(),
			       my_ratio );

  int tmpWidth = (option.rot ? 640 : 480);
  int tmpHeight = (option.rot ? 480 : 640);

  //
  // auto nibble mode setting
  //
  switch ( option.nibble_mode){
  case NIB_AutoVert:
    if ((scaledImage.height() - tmpHeight) <= 0){
      nibMax[false] = 1;
    }else{
      nibMax[false] = ((scaledImage.height() - tmpHeight) / (tmpHeight / 2)) + 2;
    }
    
    break;
  case NIB_AutoHoriz:
    if ((scaledImage.width() - tmpWidth) <= 0){
      nibMax[true] = 1;
    }else{
      nibMax[true] = ((scaledImage.width() - tmpWidth) / (tmpWidth / 2)) + 2;
    }

    break;
  default:
    break;
  }

  makePaintImage();
  return my_ratio;
}

//
// make image for paint event
//
void BookReader::makePaintImage()
{
  int h = scaledImage.height();
  int w = scaledImage.width();
  int nibH;

  //
  // nibble mode paint image center setting 
  //
  switch ( option.nibble_mode){
  case NIB_Vert:
  case NIB_AutoVert:
  case NIB_Horiz:
  case NIB_AutoHoriz:
    if(option.nibLeft)
      nibH = nibMax[true] - my_nib[true] + 1;
    else
      nibH = my_nib[true];

    if(option.rot){
      if ( (nibMax[false] != 1) && (h > 480) ){
	option.cent_Y = 240 + (h - 480) / 2 -
	  (h - 480) * (my_nib[false] - 1)/(nibMax[false] - 1);
	
      }
      if ( (nibMax[true] != 1) && (w > 640) ){
	option.cent_X = 320 - (w - 640) /2 +
	  (w - 640) * (nibH - 1)/(nibMax[true] - 1);
    }
    }else{
      if ( (nibMax[false] != 1) && (h > 640) ){
	option.cent_Y = 320 + (h - 640) / 2 -
	  (h - 640) * (my_nib[false] - 1)/(nibMax[false] - 1);
	
      }
      if ( (nibMax[true] != 1) && (w > 480) ){
	option.cent_X = 240 - (w - 480) /2 +
	  (w - 480) * (nibH - 1)/(nibMax[true] - 1);
      }
    }
    break;
  default:
    break;
  }


  if (imageRotation)
    makePaintImageR();
  else
    makePaintImageN();
  repaint();
}


// make paint image for view style(480x640)
// convert scaled image to paint image
// scaled image's width & height -> 480x640
// triming only
void BookReader::makePaintImageN()
{

  short *fb;

  if( !paintImage.create(480,640,16) ){
    fprintf(stderr,"Not enough memory");
    close();
    return;
  }

  fb = (short*)paintImage.bits();

  int src_width = scaledImage.width();
  int src_height = scaledImage.height();
  
  int src_x1 = option.cent_X - (src_width/2); 
  int src_x2 = option.cent_X + (src_width/2);
  int src_y1 = option.cent_Y - (src_height/2);
  int src_y2 = option.cent_Y + (src_height/2);

  int my_bgColor = (( ((option.bgcolor>>16) & 0xff) >> 3) << 11) |
                   (( ((option.bgcolor>> 8) & 0xff) >> 2) << 5)  |
                   (( ((option.bgcolor>> 0) & 0xff) >> 3) << 0);

  if(src_x1 < 0)
    src_x1 = 0;
  if(src_x2 >= 480)
    src_x2 = 479;
  if(src_y1 < 0)
    src_y1 = 0;
  if(src_y2 >= 640)
    src_y2 = 640;
  
  int x=0,y=0;

  //
  // Paint frame buffer from scaledImage data 
  //
  while (y <src_y1){
    for(x=0;x<480;x++)
      *fb++=my_bgColor;
    y++; 
  }
  for( y = src_y1 ; y < src_y2 ; y++){
    x=0;
    while(x<src_x1){
      *fb++=my_bgColor;
      x++;
    }
    short *tmp= (short*)scaledImage.scanLine(src_height/2 - option.cent_Y + y);    
    if ( (src_width/2 - option.cent_X) >0 )
      tmp += src_width/2 - option.cent_X;
    for( x = src_x1 ; x <=src_x2 ; x++){
      *fb++=*tmp++;
    }
    while(x<480){
      *fb++=my_bgColor;
      x++;
    }
  }
  while (y <640){
    for(x=0;x<480;x++)
      *fb++=my_bgColor;
    y++; 
  }

}


// make paint image for input style(640x480)
// convert scaled image to paint image
// scaled image's width & height -> 640x480
// rotation and triming 
void BookReader::makePaintImageR()
{

  short *fb;

  if( !paintImage.create(480,640,16) ){
    fprintf(stderr,"Not enough memory");
    close();
    return;
  }

  fb = (short*)paintImage.bits();

  int src_width = scaledImage.width();
  int src_height = scaledImage.height();

  int src_x1 = option.cent_X - (src_width/2); 
  int src_x2 = option.cent_X + (src_width/2);
  int src_y1 = option.cent_Y - (src_height/2);
  int src_y2 = option.cent_Y + (src_height/2);

  int my_bgColor = (( ((option.bgcolor>>16) & 0xff) >> 3) << 11) |
                   (( ((option.bgcolor>> 8) & 0xff) >> 2) << 5)  |
                   (( ((option.bgcolor>> 0) & 0xff) >> 3) << 0);

  if(src_x1 < 0)
    src_x1 = 0;
  if(src_x2 >= 640)
    src_x2 = 639;
  if(src_y1 < 0)
    src_y1 = 0;
  if(src_y2 >= 480)
    src_y2 = 480;

  int x=0,y=0;
  short *org_fb;
  org_fb=fb;

  fb+=479;

  //
  // Rotate and paint frame buffer from scaledImage data 
  //
  while (y <src_y1){
    for(x=0;x<640;x++){
      *fb=my_bgColor;
      fb+=480;
    }
    y++; 
    fb=org_fb+479-y;
  }
  
  for( y = src_y1 ; y < src_y2 ; y++){
    fb=org_fb+479-y;
    x=0;
    while(x<src_x1){
      *fb=my_bgColor;
      fb+=480;
      x++;
    }
    short *tmp= (short*)scaledImage.scanLine(src_height/2 - option.cent_Y + y);    
    if ((src_width/2 - option.cent_X) > 0)
      tmp += src_width/2 - option.cent_X;
    for( x = src_x1 ; x <= src_x2 ; x++){
      *fb=*tmp++;
      fb+=480;
    }
    while(x<640){
      *fb=my_bgColor;
      fb+=480;
      x++;
    }

  }

  fb=org_fb+479-y;
  while (y <480){
    for(x=0;x<640;x++){
      *fb=my_bgColor;
      fb+=480;
    }
    y++; 
    fb=org_fb+479-y;
  }
    
}



/***************************************************
      load jpeg routine

    Loading and scaling to scaledImage 16bit QImage

***************************************************/   

struct my_error_mgr {
  struct jpeg_error_mgr pub;	/* "public" fields */

  jmp_buf setjmp_buffer;	/* for return to caller */
};

typedef struct my_error_mgr * my_error_ptr;

METHODDEF(void)
my_error_exit (j_common_ptr cinfo)
{
  my_error_ptr myerr = (my_error_ptr) cinfo->err;
  (*cinfo->err->output_message) (cinfo);
  longjmp(myerr->setjmp_buffer, 1);
}

int BookReader::loadJpegFile( const char *filename, const int percent )
{
  struct jpeg_decompress_struct cinfo;
  struct my_error_mgr jerr;

  FILE * infile;		/* source file */
  JSAMPARRAY buffer;		/* Output row buffer */
  int row_stride;		/* physical row width in output buffer */
  
  int   image_width;
  int   image_height;

  static int my_scale;
  my_scale = percent;

  if ((infile = fopen(filename, "rb")) == NULL) {
    fprintf(stderr, "can't open %s\n", filename);
    close();
    return 0;
  }

  cinfo.err = jpeg_std_error(&jerr.pub);
  jerr.pub.error_exit = my_error_exit;

  if (setjmp(jerr.setjmp_buffer)) {
    jpeg_destroy_decompress(&cinfo);
    fclose(infile);
    close();
    return 0;
  }

  jpeg_create_decompress(&cinfo);
  jpeg_stdio_src(&cinfo, infile);
  jpeg_read_header(&cinfo, TRUE);
  jpeg_start_decompress(&cinfo);

  if(cinfo.output_components == 1 || cinfo.output_components == 3){

    row_stride = cinfo.output_width * cinfo.output_components;
    buffer = (*cinfo.mem->alloc_sarray)
      ((j_common_ptr) &cinfo, JPOOL_IMAGE, row_stride, 1);
    
    image_width  = cinfo.image_width;
    image_height = cinfo.image_height;
    
    
    int src_width,src_height;
    int dst_width,dst_height;
    
    src_width = image_width;
    src_height = image_height;
    
    //
    // auto scale setting
    //
    if (option.autoscale != AS_None){
      int x_ratio, y_ratio;
      if(imageRotation){
	x_ratio = (640 * 100)/src_width;
	y_ratio = (480 * 100)/src_height;
      }else{
	x_ratio = (480 * 100)/src_width ;
	y_ratio = (640 * 100)/src_height;
      } 
      switch (option.autoscale) {
      case AS_Width:
	my_scale =  x_ratio;
	break;
      case AS_Height:
	my_scale =  y_ratio;
	break;
      case AS_Both:
      default:
	my_scale = x_ratio < y_ratio ? x_ratio : y_ratio;
	break;
      }
    }

    if (my_scale >=100){
      my_scale = 100;
    }

    //
    // scaled image size
    //
    dst_width = (src_width * my_scale) / 100;
    dst_height = (src_height * my_scale) / 100;
    
    //
    // make scaled image
    //
    if( !scaledImage.create(dst_width,dst_height,16) ){
      fprintf(stderr,"Not enough memory");
      close();
      return 0;
    }

    short *dst=(short*)scaledImage.bits();
    
    uint prev_line = 0;
    
    while (cinfo.output_scanline < cinfo.output_height) {
      
      int i;
      char r,g,b;
      uchar *src;
      
      jpeg_read_scanlines(&cinfo, buffer, 1);
      
      //
      // skip line
      //
      if ( prev_line == ( (cinfo.output_scanline-1) * my_scale)/100 )
	continue;
      
      //
      // draw line number
      //
      prev_line = ( (cinfo.output_scanline-1) * my_scale)/100;
      
      switch ( cinfo.out_color_space ){
	
      case JCS_RGB:                 // RGB 24bit
	for( i = 0; i < dst_width; i++ ) {
	  
	  src = buffer[0] + ( (i*100)/my_scale )*3;
	  r = *src++;
	  g = *src++;
	  b = *src;
	  *dst++ = ((r >> 3) << 11)| ((g >> 2) << 5)| ((b >> 3) << 0);
	}
	break;
      case JCS_GRAYSCALE:                 //gray scale 8bit
	for( i = 0; i < dst_width; i++ ) {
	  
	  src = buffer[0] + ( (i*100)/my_scale );
	  g = *src;
	  *dst++ = ((g >> 3) << 11)| ((g >> 2) << 5)| ((g >> 3) << 0);
	}
	break;
      default:
	break;
      }
    }
  }

  (void) jpeg_finish_decompress(&cinfo);

  jpeg_destroy_decompress(&cinfo);

  fclose(infile);

  return my_scale;
}


void BookReader::enableFullscreen() {
  // Make sure size is correct
  if(!my_has_fullscreen) {
    //    setFixedSize(qApp->desktop()->size());
    // This call is needed because showFullScreen won't work
    // correctly if the widget already considers itself to be fullscreen.
    showNormal();
    // This is needed because showNormal() forcefully changes the window
    // style to WSTyle_TopLevel.
    setWFlags(WStyle_Customize | WStyle_NoBorder);
    // Enable fullscreen.
    showFullScreen();
    my_has_fullscreen = true;
  }
}
