/*
 $Revision: 1.27.4.3 $
 $Date: 2004/09/22 13:04:26 $
*/
#ifndef BOOKREADER_H
#define BOOKREADER_H
#include "brcontrol.h"

#include <qwidget.h>
#include <qlistview.h>
#include <qlineedit.h>
#include <qimage.h>
#include <qdirectpainter_qws.h>
#include <qvaluelist.h>

typedef unsigned short  Uint16;

class BookReader : public QWidget
{ 
  void QueueKey(QKeyEvent *e, int pressed);

  Q_OBJECT

    
    public:
       BookReader( const BR_Option );

      ~BookReader();
      int loadJpegFile( const char *filename, const int percent );
      int loadJpeg( int );
      void setWFlags(WFlags flags) {
	QWidget::setWFlags(flags);
      }

      void brControlCreate();

      void nextImage();
      void prevImage();
      void rotationImage();

    public slots:
      void testView();
      void makeBookmark();
    signals:
      void closed();

    protected:
      void paintEvent( QPaintEvent * );
      void keyPressEvent( QKeyEvent *e )  { QueueKey(e, 1); }
      void keyReleaseEvent( QKeyEvent *e) { QueueKey(e, 0); } 
      void closeEvent( QCloseEvent * );
      void mousePressEvent( QMouseEvent *);
      void mouseReleaseEvent( QMouseEvent *);
      void mouseDoubleClickEvent( QMouseEvent *);
      void focusInEvent(QFocusEvent *);

    private:
      void makePaintImage();
      void makePaintImageN();
      void makePaintImageR();
      void enableFullscreen();

      BR_Option option;

      QString loadedFilename;
      QString currentDir;
      QStringList::ConstIterator fileListIt;

      QImage scaledImage;
      QImage paintImage;

      QDirectPainter *my_painter;
      
      BRControl *brControl;

      int org_ratio;
      ASFlags org_autoscale;

      bool imageRotation;

      int prev_x;
      int prev_y;

      int org_centX;
      int org_centY;

      // nibble mode 
      // true  -> Horizonal nibble
      // false -> Vertical nibble  

      int my_nib[2];    // current nibble mode posision
      int nibMax[2];    // nibble mode divider  
      bool horizPrimary;

      WFlags my_has_fullscreen;

 };
 
#endif // BOOKREADER_H

