#include "brcontrol.h"

#include <qstring.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <stdio.h>

BRControl::BRControl(BR_Option option, QWidget *parent)
  :QDialog (parent, "BRControl", true )
{
  setMinimumSize( 320, 250 );

  orgColor = option.bgcolor;

  rBox = new QSpinBox( 0, 255, 1, this);
  gBox = new QSpinBox( 0, 255, 1, this);
  bBox = new QSpinBox( 0, 255, 1, this);

  rBox->setValue( (option.bgcolor >>16) & 0xff );
  gBox->setValue( (option.bgcolor >>8 ) & 0xff );
  bBox->setValue( (option.bgcolor     ) & 0xff );

  rBox->setGeometry( QRect(5, 40, 60, 30) );
  gBox->setGeometry( QRect(65, 40, 60, 30) );
  bBox->setGeometry( QRect(125, 40, 60, 30) );

  rBox->show();
  gBox->show();
  bBox->show();

  QLabel * title = new QLabel( "Background Color", this);
  QLabel * rLabel = new QLabel( "R", this);
  QLabel * gLabel = new QLabel( "G", this);
  QLabel * bLabel = new QLabel( "B", this);

  title->setGeometry( QRect(0, 0, 200, 20) );
  rLabel->setGeometry( QRect(30, 20, 10, 20));
  gLabel->setGeometry( QRect(100, 20, 10, 20));
  bLabel->setGeometry( QRect(170, 20, 10, 20));

  rLabel->show();
  gLabel->show();
  bLabel->show();



  org_ratio = option.ratio;
  org_autoscale = option.autoscale;
 
  scaleBox = new QSpinBox( 0, 100, 1, this);
  scaleBox->setValue( option.ratio == 999 ? 100 : option.ratio );
  scaleBox->setGeometry( QRect(20, 90, 80, 30) );
  scaleBox->show();
  connect(scaleBox, SIGNAL(valueChanged(int)), this, SLOT(scaleChange()) );
 
  QLabel * scaleLabel = new QLabel( "Scale (%)", this);
  scaleLabel->setGeometry( QRect(20, 70, 130, 20));
  scaleLabel->show();


  autoButtons = new QButtonGroup(this);
  autoButtons->setGeometry( QRect(200, 30, 120, 150) );

  asNone = new QRadioButton("None", autoButtons);
  asNone->setGeometry( QRect(5, 5, 100, 30) );
  asNone->show();

  asWidth = new QRadioButton("Width", autoButtons);
  asWidth->setGeometry( QRect(5, 35, 100, 30) );
  asWidth->show();

  asHeight = new QRadioButton("Height", autoButtons);
  asHeight->setGeometry( QRect(5, 65, 100, 30) );
  asHeight->show();

  asBoth = new QRadioButton("Both", autoButtons);
  asBoth->setGeometry( QRect(5, 95, 100, 30) );
  asBoth->show();

  QLabel * autoScaleLabel = new QLabel( "AutoScale", this);
  autoScaleLabel->setGeometry( QRect(200, 0, 90, 20));
  autoScaleLabel->show();

  switch (option.autoscale) {
  case AS_Width:
    asWidth->setChecked(true);
    break;
  case AS_Height:
    asHeight->setChecked(true);
    break;
  case AS_Both:
    asBoth->setChecked(true);
    break;
  case AS_None:
  default:
    asNone->setChecked(true);
    break;
  }


  org_centX = option.cent_X;
  org_centY = option.cent_Y;
  
  cent_X = new QSpinBox( 0, 480, 1, this);
  cent_Y = new QSpinBox( 0, 640, 1, this);
  
  cent_X->setValue( option.cent_X );
  cent_Y->setValue( option.cent_Y );

  cent_X->setGeometry( QRect(10, 160, 70, 30) );
  cent_Y->setGeometry( QRect(80, 160, 70, 30) );

  cent_X->show();
  cent_Y->show();
  
  
  QLabel * cent_Title = new QLabel( "Center Posision", this);
  QLabel * cent_XLabel = new QLabel( "X", this);
  QLabel * cent_YLabel = new QLabel( "Y", this);

  cent_Title->setGeometry( QRect(0, 120, 180, 20) );
  cent_XLabel->setGeometry( QRect(30, 140, 10, 20));
  cent_YLabel->setGeometry( QRect(100, 140, 10, 20));

  cent_Title->show();
  cent_XLabel->show();
  cent_YLabel->show();
  
  QPushButton * apply = new QPushButton("Apply",this);
  apply->setGeometry( QRect(10, 200, 80, 30));
  connect(apply, SIGNAL(pressed()), this, SLOT(pressApply()) );

  QPushButton * bookmark = new QPushButton("Bookmark",this);
  bookmark->setGeometry( QRect(100, 200, 100, 30));
  connect(bookmark, SIGNAL(pressed()), this, SLOT(pressBookmark()) );

  QPushButton * close = new QPushButton("Close",this);
  close->setGeometry( QRect(210, 200, 80, 30));
  connect(close, SIGNAL(pressed()), this, SLOT(pressClose()) );
 
}

BRControl::~BRControl()
{
  // no need to delete child widgets, Qt does it all for us
}

void BRControl::pressApply()
{
  emit apply();
}

void BRControl::pressBookmark()
{
  emit bookmark();
}

void BRControl::pressClose()
{
  done(999);
}

int BRControl::getScale(bool ok)
{
  if(ok){
    return ( scaleBox->value() );
  }else{
    return org_ratio;
  }
}

ASFlags BRControl::getAutoScale(bool ok)
{
  if(ok){
    if(asWidth->isChecked() == true)
      return AS_Width;
    
    if(asHeight->isChecked() == true)
      return AS_Height;
    
    if(asBoth->isChecked() == true)  
      return AS_Both;
    
    return AS_None;
    
  }else{
    return org_autoscale;
  }
}

int BRControl::getBGColor(bool ok)
{
  if(ok)
    return ( (rBox->value()<<16) + (gBox->value()<<8) + (bBox->value()) );
  else
    return orgColor;
}

int BRControl::getCenter_X(bool ok)
{
  if(ok)
    return cent_X->value();
  else
    return org_centX;
}

int BRControl::getCenter_Y(bool ok)
{
  if(ok)
    return cent_Y->value();
  else
    return org_centY;
}
