#ifndef BRCONTROL_H
#define BRCONTROL_H

#include "broptions.h"

#include <qdialog.h>
#include <qstring.h>
#include <qspinbox.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>

class BRControl : public QDialog
{

  Q_OBJECT
public:
    BRControl(BR_Option option, QWidget *parent=0 );
    ~BRControl();
    int getScale(bool);
    ASFlags getAutoScale(bool);
    int getBGColor(bool);
    int getCenter_X(bool);
    int getCenter_Y(bool);
    void setScale(int scale){ scaleBox->setValue(scale); };

signals:
    void apply();
    void bookmark();

private slots:
    void pressApply();
    void pressBookmark(); 
    void pressClose(); 
    void scaleChange(){ asNone->setChecked(true); };

private:
    QSpinBox *scaleBox;
    
    QButtonGroup *autoButtons;
    QRadioButton *asNone;
    QRadioButton *asWidth;
    QRadioButton *asHeight;
    QRadioButton *asBoth;

    int org_ratio;

    ASFlags org_autoscale;

    QSpinBox *rBox;
    QSpinBox *gBox;
    QSpinBox *bBox;
    int orgColor;

    QSpinBox *cent_X;
    QSpinBox *cent_Y;
    int org_centX;
    int org_centY;

};


#endif // BRCONTROL_H
