#ifndef DIRECTORY_H
#define DIRECTORY_H

#include "bookreader.h"

#include <qwidget.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qlistview.h>
#include <qmenubar.h>
#include <qpopupmenu.h>

#include <stdio.h>

class Directory : public QWidget
{ 
  Q_OBJECT

public:
  Directory( const QString & dir_name = "/", QWidget* parent = 0,
	     const char* name = 0, WFlags fl = 0);
  ~Directory();

protected:
  void resizeEvent(QResizeEvent*);
  void changeDir(const QString & );
  void configSetting();

  QLineEdit* dirName;
  QListView* showDir;
  QStringList fileList;
  QMenuBar* menuBar;
  int bookmarkOn;
  int auto_Bookmark;
  QPopupMenu* optionMenu;

  int cur_dir_num;

  BookReader* br;
  BR_Option option;

signals:
  void closeDir(void);

private slots:
  void fileView(QListViewItem *);

public slots:
  void showDirectory();
  void open();
  void setBGColor();
  void setScale();
  void setCenter();
  void setNibble();
  void saveSetting();
  void bookmarkCheck(){ 
    if (optionMenu->isItemChecked(bookmarkOn))
      optionMenu->setItemChecked(bookmarkOn,false);
    else
      optionMenu->setItemChecked(bookmarkOn,true);
  }
  void autoBookmarkCheck(){
    if (optionMenu->isItemChecked(auto_Bookmark))
      optionMenu->setItemChecked(auto_Bookmark,false);
    else
      optionMenu->setItemChecked(auto_Bookmark,true);
  }

  void fileViewClosed();
};



#endif // DIRECTORY_H

