#include "setbg.h"

#include <qstring.h>
#include <qlabel.h>

#include <stdio.h>

SetBG::SetBG(BR_Option option, QWidget *parent)
  :QDialog (parent, "BackgroundColor", true )
{
  setCaption("Background Setting");
  org_bgcolor = option.bgcolor;

  setMinimumSize( 250, 100 );

  rBox = new QSpinBox( 0, 255, 1, this);
  gBox = new QSpinBox( 0, 255, 1, this);
  bBox = new QSpinBox( 0, 255, 1, this);
  
  rBox->setValue( (org_bgcolor >>16) & 0xff );
  gBox->setValue( (org_bgcolor >>8 ) & 0xff );
  bBox->setValue( (org_bgcolor     ) & 0xff );

  rBox->setGeometry( QRect(10, 60, 70, 30) );
  gBox->setGeometry( QRect(80, 60, 70, 30) );
  bBox->setGeometry( QRect(150, 60, 70, 30) );

  rBox->show();
  gBox->show();
  bBox->show();

  QLabel * title = new QLabel( "Background Color", this);
  QLabel * rLabel = new QLabel( "R", this);
  QLabel * gLabel = new QLabel( "G", this);
  QLabel * bLabel = new QLabel( "B", this);

  title->setGeometry( QRect(0, 0, 200, 30) );
  rLabel->setGeometry( QRect(30, 30, 10, 30));
  gLabel->setGeometry( QRect(100, 30, 10, 30));
  bLabel->setGeometry( QRect(170, 30, 10, 30));
 
  rLabel->show();
  gLabel->show();
  bLabel->show();

}

SetBG::~SetBG()
{
  // no need to delete child widgets, Qt does it all for us
}

int SetBG::rgbColor()
{
  
  return ( (rBox->value()<<16) + (gBox->value()<<8) + (bBox->value()) );

}
