#include "setcenter.h"

#include <qstring.h>
#include <qlabel.h>

#include <stdio.h>

SetCenter::SetCenter(BR_Option option, QWidget *parent)
  :QDialog (parent, "CenterSetting", true )
{
  setCaption("Center Setting");

  org_centX = option.cent_X;
  org_centY = option.cent_Y;

  setMinimumSize( 250, 100 );

  cent_XBox = new QSpinBox( 0, 640, 1, this);
  cent_YBox = new QSpinBox( 0, 480, 1, this);
  
  cent_XBox->setValue( org_centX );
  cent_YBox->setValue( org_centY );

  cent_XBox->setGeometry( QRect(10, 70, 70, 30) );
  cent_YBox->setGeometry( QRect(110, 70, 70, 30) );

  cent_XBox->show();
  cent_YBox->show();

  QLabel * title = new QLabel( "Center Posision", this);
  QLabel * XLabel = new QLabel( "Center X", this);
  QLabel * YLabel = new QLabel( "Center Y", this);

  title->setGeometry( QRect(0, 0, 200, 30) );
  XLabel->setGeometry( QRect(10, 30, 80, 30));
  YLabel->setGeometry( QRect(110, 30, 80, 30));
 
  title->show();
  XLabel->show();
  YLabel->show();

}

SetCenter::~SetCenter()
{
  // no need to delete child widgets, Qt does it all for us
}

