#include "setnibble.h"

#include <qstring.h>
#include <qlabel.h>

#include <stdio.h>

SetNibble::SetNibble(BR_Option option, QWidget *parent)
  :QDialog (parent, "BackgroundColor", true )
{
  setCaption("Nibble Setting");

  org_nibbleH = option.nibble_H;
  org_nibbleV = option.nibble_V;

  setMinimumSize( 300, 100 );

  nibble_HBox = new QSpinBox( 1, 50, 1, this);
  nibble_VBox = new QSpinBox( 1, 50, 1, this);
  
  nibble_HBox->setValue( org_nibbleH );
  nibble_VBox->setValue( org_nibbleV );

  nibble_HBox->setGeometry( QRect(10, 30, 120, 30) );
  nibble_VBox->setGeometry( QRect(10, 90, 120, 30) );

  nibble_HBox->show();
  nibble_VBox->show();

  QLabel * HLabel = new QLabel( "Horiz Divider", this);
  QLabel * VLabel = new QLabel( "Vert Divider", this);

  HLabel->setGeometry( QRect(10, 0, 130, 20));
  VLabel->setGeometry( QRect(10, 70, 130, 20));
 
  HLabel->show();
  VLabel->show();

  nibLRCheck = new QRadioButton("Left mode",this);
  nibLRCheck->setGeometry( QRect(10, 120, 120, 30) );
  nibLRCheck->show();

  nibLRCheck->setChecked(option.nibLeft);


  nibButtons = new QButtonGroup(this);
  nibButtons->setGeometry( QRect(160, 20, 160, 160) );

  nibNone = new QRadioButton("None", nibButtons);
  nibNone->setGeometry( QRect(5, 5, 100, 30) );
  nibNone->show();

  nibHoriz = new QRadioButton("Horiz", nibButtons);
  nibHoriz->setGeometry( QRect(5, 35, 100, 30) );
  nibHoriz->show();

  nibVert = new QRadioButton("Vert", nibButtons);
  nibVert->setGeometry( QRect(5, 65, 100, 30) );
  nibVert->show();

  nibAutoHoriz = new QRadioButton("Auto Horiz", nibButtons);
  nibAutoHoriz->setGeometry( QRect(5, 95, 140, 30) );
  nibAutoHoriz->show();

  nibAutoVert = new QRadioButton("Auto Vert", nibButtons);
  nibAutoVert->setGeometry( QRect(5, 125, 140, 30) );
  nibAutoVert->show();


  QLabel * nibLabel = new QLabel( "Nibble Mode", this);
  nibLabel->setGeometry( QRect(170, 0, 120, 20));
  nibLabel->show();


  switch (option.nibble_mode) {
  case NIB_Horiz:
    nibHoriz->setChecked(true);
    break;
  case NIB_Vert:
    nibVert->setChecked(true);
    break;
  case NIB_AutoHoriz:
    nibAutoHoriz->setChecked(true);
    break;
  case NIB_AutoVert:
    nibAutoVert->setChecked(true);
    break;
  case NIB_None:
  default:
    nibNone->setChecked(true);
    break;
  }


}

SetNibble::~SetNibble()
{
  // no need to delete child widgets, Qt does it all for us
}


NIBFlags SetNibble::getNIBFlag()
{
  if(nibHoriz->isChecked() == true)
    return NIB_Horiz;

  if(nibVert->isChecked() == true)
    return NIB_Vert;

  if(nibAutoHoriz->isChecked() == true)
    return NIB_AutoHoriz;

  if(nibAutoVert->isChecked() == true)
    return NIB_AutoVert;

  return NIB_None;
}
