#include "setscale.h"

#include <qstring.h>
#include <qlabel.h>

#include <stdio.h>

SetScale::SetScale(BR_Option option, QWidget *parent)
  :QDialog (parent, "Scale", true )
{
  setCaption("Scale Setting");

  org_ratio = option.ratio;
  org_autoscale = option.autoscale;

  setMinimumSize( 200, 200 );

  scaleBox = new QSpinBox( 0, 100, 1, this);
  scaleBox->setValue( org_ratio == 999 ? 100 : org_ratio );
  scaleBox->setGeometry( QRect(20, 30, 80, 30) );
  scaleBox->show();
  connect(scaleBox, SIGNAL(valueChanged(int)), this, SLOT(scaleChange()) );

  QLabel * scaleLabel = new QLabel( "Scale (%)", this);
  scaleLabel->setGeometry( QRect(20, 0, 100, 30));
  scaleLabel->show();

  autoButtons = new QButtonGroup(this);
  autoButtons->setGeometry( QRect(110, 30, 120, 150) );

  asNone = new QRadioButton("None", autoButtons);
  asNone->setGeometry( QRect(5, 5, 100, 30) );
  asNone->show();

  asWidth = new QRadioButton("Width", autoButtons);
  asWidth->setGeometry( QRect(5, 35, 100, 30) );
  asWidth->show();

  asHeight = new QRadioButton("Height", autoButtons);
  asHeight->setGeometry( QRect(5, 65, 100, 30) );
  asHeight->show();

  asBoth = new QRadioButton("Both", autoButtons);
  asBoth->setGeometry( QRect(5, 95, 100, 30) );
  asBoth->show();

  QLabel * autoScaleLabel = new QLabel( "AutoScale", this);
  autoScaleLabel->setGeometry( QRect(120, 0, 100, 30));
  autoScaleLabel->show();

  switch (option.autoscale) {
  case AS_Width:
    asWidth->setChecked(true);
    break;
  case AS_Height:
    asHeight->setChecked(true);
    break;
  case AS_Both:
    asBoth->setChecked(true);
    break;
  case AS_None:
  default:
    asNone->setChecked(true);
    break;
  }


}

SetScale::~SetScale()
{
  // no need to delete child widgets, Qt does it all for us
}

int SetScale::getScale()
{
    return ( scaleBox->value() );

}

ASFlags SetScale::getASFlag()
{
  if(asWidth->isChecked() == true)
    return AS_Width;

  if(asHeight->isChecked() == true)
    return AS_Height;

  if(asBoth->isChecked() == true)  
    return AS_Both;

  return AS_None;
}
