#include <qtextcodec.h> 
#include <qstringlist.h> 

#include "EncodingsCombo.h"

EncodingsCombo::EncodingsCombo(QWidget * parent=0, const char * name=0)
	: QComboBox(parent, name)
{
	QStringList codecs;
	for (int i = 0; i < 3000; i++)
	{
		QTextCodec* codec = QTextCodec::codecForMib(i);
		if (codec == 0)
			continue;
			
		codecs << codec->name();	
	}
	
	insertStringList(codecs);
}

void EncodingsCombo::setCurrentCodec(const QString& encoding)
{
	for (int i = 0; i < count(); ++i) 
	{
		if (text(i) == encoding)
		{
			setCurrentItem(i);
			break;
		}
	}
}

QString EncodingsCombo::currentCodec()
{
	return currentText();
}

