/***************************************************************************
 *                       ExtraKeyButton.cpp  -  description
 *                               -------------------
 *  begin                : Tue May 22 10:40:21 BST 2003
 *  copyright            : (C) 2002 by Dmitri Skachkov
 *  email                : d_skachkov@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "ExtraKeyButton.h"

ExtraKeyButton::ExtraKeyButton(QWidget *parent, const char *name)
    : QComboBox(parent, name)
{
    //setMaximumWidth(64);
    w = parent;
    maxKeys = sizeof(special_keys)/sizeof(special_keys[0]);
    special_keys[0].code = 0x1038; // Key_F9;
    special_keys[0].name = tr("<Calendar>"); 
    special_keys[1].code = 0x1039; // Key_F10;
    special_keys[1].name = tr("<Address>"); 
    special_keys[2].code = 0x103c; // Key_F13;
    special_keys[2].name = tr("<Mail>"); 
    special_keys[3].code = 0x103b; // Key_F11;
    special_keys[3].name = tr("<Home>"); 
    special_keys[4].code = 0x1021; // Key_F12;
    special_keys[4].name = tr("<Control>"); 
    special_keys[5].code = 0x1023;
    special_keys[5].name = tr("<Alt>"); 
    special_keys[6].code = Key_Space;
    special_keys[6].name = tr("<Space>"); 
    special_keys[7].code = Key_Tab;
    special_keys[7].name = tr("<Tab>"); 
    special_keys[8].code = Key_Backspace;
    special_keys[8].name = tr("<Backspace>"); 
    special_keys[9].code = Key_Return;
    special_keys[9].name = tr("<OK/Enter>"); 
    special_keys[10].code = Key_Shift;
    special_keys[10].name = tr("<Shift>"); 
    special_keys[11].code = 0x103a;
    special_keys[11].name = tr("<Menu>"); 
    special_keys[12].code = 0x1045 ; // Key_F22;
    special_keys[12].name = tr("<Fn>"); 
    special_keys[13].code = Key_Up;
    special_keys[13].name = tr("<Up>"); 
    special_keys[14].code = Key_Down;
    special_keys[14].name = tr("<Down>"); 
    special_keys[15].code = Key_Left;
    special_keys[15].name = tr("<Left>"); 
    special_keys[16].code = Key_Right;
    special_keys[16].name = tr("<Right>"); 
    special_keys[17].code = 0;
    special_keys[17].name = tr("<None>"); 
    special_keys[18].code = Key_0;
    special_keys[18].name = tr("User defined"); 

    for (int i = 0; i < maxKeys; i++)
		insertItem(special_keys[i].name, i);

    connect(this, SIGNAL(activated(int)), this, SLOT(setKey(int)));
}

void ExtraKeyButton::keyPressEvent(QKeyEvent * e)
{
    if (e->key() == Key_Escape)
    {
		setCurrentKey(key);
		return;
    }
    if (e->key() == Key_Return)
    {
		setCurrentKey(Key_Return);
    } 
    else 
    {
    	setCurrentKey(e->key());
    }
    w->setFocus();
}

void ExtraKeyButton::setKey(int i)
{
    if (i < (maxKeys-1))
    {
		key = special_keys[i].code;
		return;
    }
    setFocus();
    changeItem(tr("Press new key"), maxKeys-1);
}

void ExtraKeyButton::setCurrentKey(int i)
{
    for (int j = 0; j < (maxKeys - 1); j++)
    {
		if (special_keys[j].code == i)
		{
		    setCurrentItem(j);
		    key = special_keys[j].code;
		    return;
		}
    }
    
    setCurrentItem(maxKeys - 1);
    special_keys[maxKeys - 1].code = i;
    key = i;
    QChar c = QChar(key);
    
    QString s = tr("Key") + " <" + (c.latin1() > 32 ? QString(c) : QString().sprintf("0x%x", key)) + ">";
    
    changeItem(s, maxKeys - 1);
}

int ExtraKeyButton::getCurrentKey()
{
	return key;
}

