#include <qlayout.h> 
#include "FileDialog.h"

FileDialog::FileDialog(MODE mode = MODE_OPEN, const QString& f = "", QWidget * parent=0, const char * name=0, bool modal=TRUE, WFlags flags = 0)
	: QDialog( parent, name, modal, flags), m_mode(mode)
{
    filter = new FileSelectionFilter(f, this);

    slf = new SlFileSelector("", "", this, "");
    slf->setFilter(filter);
    connect(slf, SIGNAL(fileSelected(const QFileInfo &)), this, SLOT(fileSelected(const QFileInfo &)));
    connect(slf, SIGNAL(dirOpened(const QDir &)), this, SLOT(dirOpened(const QDir &)));
    slf->setListView();
    
	QBoxLayout* l = new QVBoxLayout(this);
	l->addWidget(slf);
	
	text = new QLineEdit(this);
	if (m_mode == MODE_SAVE)
	{
		l->addWidget(text);
		setCaption(tr("Save..."));
	}
	else
	{
		setCaption(tr("Open..."));
	}
}

void FileDialog::setDefaultName(QString name)
{
	text->setText(name);
}

void FileDialog::fileSelected(const QFileInfo &fs)
{
	selectedFile = fs;
	currentDir = fs.dir();
	text->setText(selectedFile.baseName());
	
	if (m_mode == MODE_OPEN)
		accept();
}

void FileDialog::dirOpened(const QDir &dir)
{
	currentDir = dir;
	
	// recet selected file
	selectedFile.setFile(currentDir, text->text() + "." + complementExt);
	qDebug("FileDialog::dirOpened(): " + selectedFile.absFilePath());
}

int FileDialog::exec()
{
	return QDialog::exec();
}

void FileDialog::accept()
{
	selectedFile.setFile(currentDir, text->text() + "." + complementExt);
	qDebug("FileDialog::accept(): " + selectedFile.absFilePath());
	
	return QDialog::accept();
}
