#ifndef FILEDIALOG_H
#define FILEDIALOG_H

#include <qdialog.h>
#include <qlineedit.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <sl/slfileselector.h>

#include "FileSelectionFilter.h"

class FileDialog : public QDialog
{
	Q_OBJECT
	
public:
	enum MODE
	{
		MODE_OPEN,
		MODE_SAVE
	};

private:
	MODE m_mode;
    SlFileSelector	*slf;
    FileSelectionFilter* filter;
    QLineEdit* text;

    QFileInfo selectedFile;
    QDir currentDir;
    
    QString complementExt;
	
public:
	
	FileDialog(MODE mode = MODE_OPEN, const QString& f = "", QWidget * parent=0, const char * name=0, bool modal=TRUE, WFlags flags = 0);
	
	void setDefaultName( QString name );
	void setComplementExt( QString ext ) { complementExt = ext; };
	
	QString getFilePath() { return selectedFile.absFilePath(); };
	QString getFileName() { return selectedFile.fileName(); };
	
	int	exec();
	virtual void accept();
	
protected slots:
    void fileSelected(const QFileInfo &fs);
	void dirOpened(const QDir &dir);
};

#endif // FILEDIALOG_H
