#ifndef _FILESELECTIONFILTER_H_
#define _FILESELECTIONFILTER_H_

#include <qstring.h>
#include <qfileinfo.h>
#include <sl/slfileselector.h>

class FileSelectionFilter : public SlFileSelectorFilter
{
    Q_OBJECT
    
    QString filter;
    
public:
    FileSelectionFilter(const QString& f, QWidget* parent, const char* name = 0)
        : SlFileSelectorFilter(parent, name), filter(f)
    {
    }
    
    virtual bool isAddToList(QFileInfo& fileInfo) const
    {
        return filter.contains(fileInfo.extension());
    }
};

#endif