#include "FrequenciesCombo.h"

#include <qfile.h>
#include <qtextstream.h>
#include <qpe/qpeapplication.h> 

FrequenciesCombo::FrequenciesCombo(QWidget * parent=0, const char * name=0)
	: QComboBox(parent, name)
{

}

void FrequenciesCombo::setCurrentFrequency(QString freq)
{
  	for (int i = 0; i < count(); ++i) 
	{
		if (text(i) == freq)
		{
			setCurrentItem(i);
			break;
		}
	}
}

QString FrequenciesCombo::currentFrequency()
{
	return currentText();
}


void FrequenciesCombo::addFreqList(QStringList list)
{
  for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it ) {
    insertItem(*it);
  }

}
