#include "RemoteControlButton.h"

RemoteControlButton::RemoteControlButton(QWidget * parent=0, const char * name=0)
	: QComboBox(parent, name)
{
	keys[tr("<None>")] = KEY_NONE;
	keys[tr("<Stop>")] = KEY_STOP;
	keys[tr("<Play/Pause>")] = KEY_PLAY_PAUSE;
	keys[tr("<Forward>")] = KEY_FORWARD;
	keys[tr("<Backward>")] = KEY_BACKWARD;
	keys[tr("<Volume Up>")] = KEY_VOLUME_UP;
	keys[tr("<Volume Down>")] = KEY_VOLUME_DOWN;
	
	KeysMap::Iterator it = keys.begin();
	for (int i = 0; it != keys.end(); ++it, i++)
		insertItem(it.key(), i);
}

void RemoteControlButton::setCurrentKey(int key)
{
	setCurrentItem(KEY_NONE);
	for (int i = 0; i < count(); i++)
	{
		if (keys.contains(text(i)) && keys[text(i)] == key)
			setCurrentItem(i);
	}
}

int RemoteControlButton::getCurrentKey()
{
	KeysMap::Iterator it;
	for (it = keys.begin(); it != keys.end(); ++it)
	{
		if (it.key() == currentText())
			return it.data();
	}
	
	return KEY_NONE;
}
