#ifndef REMOTECONTROLBUTTON_H
#define REMOTECONTROLBUTTON_H

#include <qcombobox.h>
#include <qmap.h>

class RemoteControlButton : public QComboBox
{
public:
	RemoteControlButton(QWidget * parent=0, const char * name=0);
	
	// Sharp remote control buttons:
	// 
	// Stop:			0x201d
	// Play/Pause:		0x201c 
	// Forward:			0x201e
	// Backward:		0x201f
	// Volume Up:		0x2020
	// Volume Down:		0x2021
	enum
	{
		KEY_NONE 		= 0,			// 
		KEY_STOP 		= 0x201d,		// 0x201d
		KEY_PLAY_PAUSE 	= 0x201c,		// 
		KEY_FORWARD		= 0x201f,		//
		KEY_BACKWARD	= 0x201e,		// 0x201e
		KEY_VOLUME_UP	= 0x2020,		//
		KEY_VOLUME_DOWN = 0x2021		//
	} KEYS;

	typedef QMap<QString, int> KeysMap;
	
	void setCurrentKey(int key);
	int getCurrentKey();
	
private:
	KeysMap keys;
};

#endif // REMOTECONTROLBUTTON_H
