/**********************************************************************
**********************************************************************/


#include "freqchangeapplet.h"

#include <qpe/resource.h>

#include <qpainter.h>
#include <qpopupmenu.h>
#include <qapplication.h>
#include <qstring.h>
#include <qpe/qpeapplication.h>
#include <qcopchannel_qws.h>
#include <qdir.h>
#include <qdict.h>
#include <qfile.h>
#include <qtextstream.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

//===========================================================================

FreqChangeApplet::FreqChangeApplet( QWidget *parent, const char *name )
    : QWidget( parent, name )
{
    freqchangePixmap = Resource::loadPixmap( "freqchange" );
    setFixedWidth( freqchangePixmap.width() );
    menu = 0;
    printf("FreqChangeApplet()\n");

}

FreqChangeApplet::~FreqChangeApplet()
{
    printf("~FreqChangeApplet()\n");
}

void FreqChangeApplet::mousePressEvent( QMouseEvent *)
{

    if (!menu)
    {
        menu = new QPopupMenu(this);
        menu->setCheckable(TRUE);
    }
    else
    {
        menu->clear();
    }


	FILE *fp;
	int cpuregister;

	fp=fopen("/proc/cccr_change", "r");
	if (fp != NULL)
	  fscanf(fp, "%x", &cpuregister);
	fclose(fp);

	int menuitem_num=0;
    QFile f("/home/zaurus/Settings/freqchange.conf");
    if ( f.open(IO_ReadOnly) ) {
        QTextStream t( &f );
        QString s;
        while ( !t.eof() ) {
            s = t.readLine();
			
			bool ok;
			int sep = s.find(',');
			QString title = s.left(sep);
			int clock = s.right(s.length()-s.find(',')-1).toInt(&ok,16);

			if ((sep !=-1) &&  (title !="") && (ok == TRUE) && clock ) {
				int id = menu->insertItem(title);
				if (clock == cpuregister) {
					menu->setItemChecked(id, TRUE);
				} else {
					menu->setItemChecked(id, FALSE);
				}
				menuitem_num++;
			}

        }
        f.close();
    }

	if(menuitem_num ==0){
	    QString direntName = "242";
		int clock=0x242;

		int id = menu->insertItem(direntName);
		if (clock == cpuregister) {
			menu->setItemChecked(id, TRUE);
		} else {
			menu->setItemChecked(id, FALSE);
		}

		direntName = "241";
		clock=0x241;
		id = menu->insertItem(direntName);
		if (clock == cpuregister) {
			menu->setItemChecked(id, TRUE);
		} else {
			menu->setItemChecked(id, FALSE);
		}

		direntName = "161";
		clock=0x161;
		id = menu->insertItem(direntName);
		if (clock == cpuregister) {
			menu->setItemChecked(id, TRUE);
		} else {
			menu->setItemChecked(id, FALSE);
		}
	}

    connect(menu, SIGNAL(activated(int)), this, SLOT(action(int)));


    QPoint curPos = mapToGlobal( QPoint(0,0) );
    QSize sh = menu->sizeHint();
    menu->popup( curPos-QPoint((sh.width()-width())/2,sh.height()) );
}

void FreqChangeApplet::action(int id)
{

    QString value_CCCR = menu->text(id);
	FILE *fp;
	int cpuregister;

	fp=fopen("/proc/cccr_change", "r");
	fscanf(fp, "%x", &cpuregister);
	fclose(fp);

    QFile f("/home/zaurus/Settings/freqchange.conf");
    if ( f.open(IO_ReadOnly) ) {
        QTextStream t( &f );
        QString s;
        while ( !t.eof() ) {
            s = t.readLine();
			
			bool ok;
			int sep = s.find(',');
			QString title = s.left(sep);
			int clock = s.right(s.length()-s.find(',')-1).toInt(&ok,16);

			if ((sep !=-1) &&  (title !="") && (ok == TRUE) && clock ) {
				if ((title == value_CCCR) && (clock != cpuregister)) {
					sync();
					fp=fopen("/proc/cccr_change", "w");
					fprintf(fp, "%08X\n",clock);
					fclose(fp);
				}
			}

        }
        f.close();
    }

	if ((value_CCCR == "242") && (0x242 != cpuregister)){
		sync();
		fp=fopen("/proc/cccr_change", "w");
		fprintf(fp, "00000242\n");
		fclose(fp);
	}

	if ((value_CCCR == "241") && (0x241 != cpuregister)){
		sync();
		fp=fopen("/proc/cccr_change", "w");
		fprintf(fp, "00000241\n");
		fclose(fp);
	}

	if ((value_CCCR == "161") && (0x161 != cpuregister)){
		sync();
		fp=fopen("/proc/cccr_change", "w");
		fprintf(fp, "00000161\n");
		fclose(fp);
	}

}

void FreqChangeApplet::paintEvent( QPaintEvent* )
{
    printf("FreqChangeApplet():paintEvent()\n");

    QPainter p(this);
    p.drawPixmap( 0, (height()-freqchangePixmap.height())/2,
                  freqchangePixmap );
}


