#include <qmessagebox.h>
#include <qstringlist.h>
#include <qfile.h>
#include <qcstring.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qscrollview.h> 
#include <qgroupbox.h> 

#include "kinosettings.h"
#include "player.h"

#include "SelectKeyButton.h"
#include "RemoteControlButton.h"
#include "ExtraKeyButton.h"
#include "FrequenciesCombo.h"
#include "EncodingsCombo.h"

KinoSettings::KinoSettings( QWidget* parent,  const QString &name, bool modal, WFlags fl )
    : KinoSettingsBase( parent, name, modal, fl )
{
	// move controls into the scroll view
	QScrollView *sv = new QScrollView(groupMappings);
	groupMappingsLayout->addWidget(sv, 0, 0);
	
	sv->setResizePolicy(QScrollView::AutoOneFit);
	sv->setFrameStyle(QFrame::NoFrame);
	sv->setVScrollBarMode(QScrollView::Auto);
	sv->setHScrollBarMode(QScrollView::Auto);
	sv->addChild(frameMappings);

	QScrollView *sv2 = new QScrollView(groupVideo);
	groupVideoLayout->addWidget(sv2, 0, 0);
	
	sv2->setResizePolicy(QScrollView::AutoOneFit);
	sv2->setFrameStyle(QFrame::NoFrame);
	sv2->setVScrollBarMode(QScrollView::Auto);
	sv2->setHScrollBarMode(QScrollView::Auto);
	sv2->addChild(frameVideoSetting);
	
	f_fade->hide();
	
    setCaption(name);
    showMaximized();
}

KinoSettings::~KinoSettings() 
{
}

void KinoSettings::setSettings(KinoPrefs p)
{
	// General
	f_normal->setChecked(p.f_normal);
	f_repeat->setChecked(p.f_repeat);
	f_random->setChecked(p.f_random);
	
	f_cpu->setChecked(p.f_cpu);

	s_a_cpu->addFreqList(p.l_freq);
	s_v_cpu->addFreqList(p.l_freq);

	s_a_cpu->setEnabled(p.f_cpu);
	s_v_cpu->setEnabled(p.f_cpu);
	
	s_a_cpu->setCurrentFrequency(p.s_a_cpu);
	s_v_cpu->setCurrentFrequency(p.s_v_cpu);
	
	s_priority->setText(QString::number(p.s_priority));

	// Media Stream
	f_cache->setChecked(p.f_cache);
	s_cache->setEnabled(p.f_cache);
    s_cache->setText(QString::number(p.s_cache));
    s_bandwidth->setText(QString::number(p.s_bandwidth));

	s_mplayeroptions->setText(p.s_mplayeroptions);
	f_debug->setChecked(p.f_debug);
    s_types->setText(p.s_types);
	
    // Video
    f_dropframes->setChecked(p.f_dropframes);
    f_directrendering->setChecked(p.f_directrendering);
    f_doublebuffer->setChecked(p.f_doublebuffer);
    f_smart_crop->setChecked(p.f_smart_crop);
    f_rotate->setChecked(p.f_rotate);
    f_index->setChecked(p.f_index);
    f_external_mem->setChecked(p.f_external_mem);
    f_noaspect->setChecked(p.f_noaspect);
    f_w100overlay->setChecked(p.f_w100overlay);
    f_bvddoverlay->setChecked(p.f_bvddoverlay);
    
    // Audio
    f_resample->setChecked(p.f_resample);
	f_lcd_off->setChecked(p.f_lcd_off);
	f_fade->setChecked(p.f_fade);
	
	// Playlist
	f_playonclick->setChecked(p.f_playonclick);
	f_saveplaylist->setChecked(p.f_saveplaylist);
	s_enc_mp3->setCurrentCodec(p.s_enc_mp3);
	s_enc_playlist->setCurrentCodec(p.s_enc_playlist);
	
	// Controls
	f_remote->setChecked(p.f_remote);
	f_extrakey->setChecked(p.f_extrakey);
	
    cbPlayStop_K->setCurrentKey(p.keyboardActions[Player::ACTION_PLAY_STOP]);
    cbPauseResume_K->setCurrentKey(p.keyboardActions[Player::ACTION_PAUSE_RESUME]);
    cbVolumeUp_K->setCurrentKey(p.keyboardActions[Player::ACTION_VOLUME_UP]);
    cbVolumeDown_K->setCurrentKey(p.keyboardActions[Player::ACTION_VOLUME_DOWN]);
    cbMute_K->setCurrentKey(p.keyboardActions[Player::ACTION_MUTE]);
    cbForward10_K->setCurrentKey(p.keyboardActions[Player::ACTION_SEEK_F10]);
    cbBackward10_K->setCurrentKey(p.keyboardActions[Player::ACTION_SEEK_B10]);
    cbForward60_K->setCurrentKey(p.keyboardActions[Player::ACTION_SEEK_F60]);
    cbBackward60_K->setCurrentKey(p.keyboardActions[Player::ACTION_SEEK_B60]);
    cbForward600_K->setCurrentKey(p.keyboardActions[Player::ACTION_SEEK_F600]);
    cbBackward600_K->setCurrentKey(p.keyboardActions[Player::ACTION_SEEK_B600]);
    cbNext_K->setCurrentKey(p.keyboardActions[Player::ACTION_NEXT]);
    cbPrev_K->setCurrentKey(p.keyboardActions[Player::ACTION_PREV]);
    cbOSD_K->setCurrentKey(p.keyboardActions[Player::ACTION_OSD]);
    cbSubtitles_K->setCurrentKey(p.keyboardActions[Player::ACTION_SUBTITLES]);
    
    cbAddToPlaylist_K->setCurrentKey(p.keyboardActions[Player::ACTION_ADD_TO_PLAYLIST]);
    cbRemoveFromPlaylist_K->setCurrentKey(p.keyboardActions[Player::ACTION_REMOVE_FROM_PLAYLIST]);
    cbPlaylistUp_K->setCurrentKey(p.keyboardActions[Player::ACTION_PLAYLIST_UP]);
    cbPlaylistDown_K->setCurrentKey(p.keyboardActions[Player::ACTION_PLAYLIST_DOWN]);
    cbFileInfo_K->setCurrentKey(p.keyboardActions[Player::ACTION_FILE_INFO]);
    
    cbPlayStop_R->setCurrentKey(p.remoteActions[Player::ACTION_PLAY_STOP]);
    cbPauseResume_R->setCurrentKey(p.remoteActions[Player::ACTION_PAUSE_RESUME]);
    cbVolumeUp_R->setCurrentKey(p.remoteActions[Player::ACTION_VOLUME_UP]);
    cbVolumeDown_R->setCurrentKey(p.remoteActions[Player::ACTION_VOLUME_DOWN]);
    cbMute_R->setCurrentKey(p.remoteActions[Player::ACTION_MUTE]);
    cbForward10_R->setCurrentKey(p.remoteActions[Player::ACTION_SEEK_F10]);
    cbBackward10_R->setCurrentKey(p.remoteActions[Player::ACTION_SEEK_B10]);
    cbForward60_R->setCurrentKey(p.remoteActions[Player::ACTION_SEEK_F60]);
    cbBackward60_R->setCurrentKey(p.remoteActions[Player::ACTION_SEEK_B60]);
    cbForward600_R->setCurrentKey(p.remoteActions[Player::ACTION_SEEK_F600]);
    cbBackward600_R->setCurrentKey(p.remoteActions[Player::ACTION_SEEK_B600]);
    cbNext_R->setCurrentKey(p.remoteActions[Player::ACTION_NEXT]);
    cbPrev_R->setCurrentKey(p.remoteActions[Player::ACTION_PREV]);
    cbOSD_R->setCurrentKey(p.remoteActions[Player::ACTION_OSD]);
    cbSubtitles_R->setCurrentKey(p.remoteActions[Player::ACTION_SUBTITLES]);

    cbAddToPlaylist_R->setCurrentKey(p.remoteActions[Player::ACTION_ADD_TO_PLAYLIST]);
    cbRemoveFromPlaylist_R->setCurrentKey(p.remoteActions[Player::ACTION_REMOVE_FROM_PLAYLIST]);
    cbPlaylistUp_R->setCurrentKey(p.remoteActions[Player::ACTION_PLAYLIST_UP]);
    cbPlaylistDown_R->setCurrentKey(p.remoteActions[Player::ACTION_PLAYLIST_DOWN]);
    cbFileInfo_R->setCurrentKey(p.remoteActions[Player::ACTION_FILE_INFO]);


    cbPlayStop_E->setCurrentKey(p.extrakeyActions[Player::ACTION_PLAY_STOP]);
    cbPauseResume_E->setCurrentKey(p.extrakeyActions[Player::ACTION_PAUSE_RESUME]);
    cbVolumeUp_E->setCurrentKey(p.extrakeyActions[Player::ACTION_VOLUME_UP]);
    cbVolumeDown_E->setCurrentKey(p.extrakeyActions[Player::ACTION_VOLUME_DOWN]);
    cbMute_E->setCurrentKey(p.extrakeyActions[Player::ACTION_MUTE]);
    cbForward10_E->setCurrentKey(p.extrakeyActions[Player::ACTION_SEEK_F10]);
    cbBackward10_E->setCurrentKey(p.extrakeyActions[Player::ACTION_SEEK_B10]);
    cbForward60_E->setCurrentKey(p.extrakeyActions[Player::ACTION_SEEK_F60]);
    cbBackward60_E->setCurrentKey(p.extrakeyActions[Player::ACTION_SEEK_B60]);
    cbForward600_E->setCurrentKey(p.extrakeyActions[Player::ACTION_SEEK_F600]);
    cbBackward600_E->setCurrentKey(p.extrakeyActions[Player::ACTION_SEEK_B600]);
    cbNext_E->setCurrentKey(p.extrakeyActions[Player::ACTION_NEXT]);
    cbPrev_E->setCurrentKey(p.extrakeyActions[Player::ACTION_PREV]);
    cbOSD_E->setCurrentKey(p.extrakeyActions[Player::ACTION_OSD]);
    cbSubtitles_E->setCurrentKey(p.extrakeyActions[Player::ACTION_SUBTITLES]);
    
    cbAddToPlaylist_E->setCurrentKey(p.extrakeyActions[Player::ACTION_ADD_TO_PLAYLIST]);
    cbRemoveFromPlaylist_E->setCurrentKey(p.extrakeyActions[Player::ACTION_REMOVE_FROM_PLAYLIST]);
    cbPlaylistUp_E->setCurrentKey(p.extrakeyActions[Player::ACTION_PLAYLIST_UP]);
    cbPlaylistDown_E->setCurrentKey(p.extrakeyActions[Player::ACTION_PLAYLIST_DOWN]);
    cbFileInfo_E->setCurrentKey(p.extrakeyActions[Player::ACTION_FILE_INFO]);

}

KinoPrefs KinoSettings::getSettings(KinoPrefs s)
{
    KinoPrefs p;
    
    p = s;

    // General
    p.f_normal = f_normal->isChecked();
    p.f_repeat = f_repeat->isChecked();
    p.f_random = f_random->isChecked();
    
    p.f_cpu = f_cpu->isChecked();
    p.s_v_cpu = s_v_cpu->currentFrequency();
    p.s_a_cpu = s_a_cpu->currentFrequency();
    p.s_priority = s_priority->text().toInt(0, 10);
    
    // Media Stream
    p.f_cache = f_cache->isChecked();
    p.s_cache = s_cache->text().toInt(0, 10);
    p.s_bandwidth = s_bandwidth->text().toInt(0, 10);
    
    p.s_mplayeroptions = s_mplayeroptions->text();
    p.f_debug = f_debug->isChecked();

    p.s_types = s_types->text();
    
    // Video
    p.f_dropframes = f_dropframes->isChecked();
    p.f_directrendering = f_directrendering->isChecked();
    p.f_doublebuffer = f_doublebuffer->isChecked();
    p.f_smart_crop = f_smart_crop->isChecked();
    p.f_rotate = f_rotate->isChecked();
    p.f_index = f_index->isChecked();
    p.f_external_mem = f_external_mem->isChecked();
    p.f_w100overlay = f_w100overlay->isChecked();
    p.f_bvddoverlay = f_bvddoverlay->isChecked();
    
	// Audio
    p.f_resample = f_resample->isChecked();
    p.f_lcd_off = f_lcd_off->isChecked();
    p.f_fade = f_fade->isChecked();
    
    // Playlist
    p.f_playonclick = f_playonclick->isChecked();
    p.f_saveplaylist = f_saveplaylist->isChecked();
    
    p.s_enc_mp3 = s_enc_mp3->currentCodec();
    p.s_enc_playlist = s_enc_playlist->currentCodec();
    
    // Controls
    p.f_remote = f_remote->isChecked();
    p.f_extrakey = f_extrakey->isChecked();
    
    p.keyboardActions[Player::ACTION_PLAY_STOP] = cbPlayStop_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_PAUSE_RESUME] = cbPauseResume_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_VOLUME_UP] = cbVolumeUp_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_VOLUME_DOWN] = cbVolumeDown_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_MUTE] = cbMute_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_SEEK_F10] = cbForward10_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_SEEK_B10] = cbBackward10_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_SEEK_F60] = cbForward60_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_SEEK_B60] = cbBackward60_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_SEEK_F600] = cbForward600_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_SEEK_B600] = cbBackward600_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_NEXT] = cbNext_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_PREV] = cbPrev_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_OSD] = cbOSD_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_SUBTITLES] = cbSubtitles_K->getCurrentKey();
    
    p.keyboardActions[Player::ACTION_ADD_TO_PLAYLIST] = cbAddToPlaylist_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_REMOVE_FROM_PLAYLIST] = cbRemoveFromPlaylist_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_PLAYLIST_UP] = cbPlaylistUp_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_PLAYLIST_DOWN] = cbPlaylistDown_K->getCurrentKey();
    p.keyboardActions[Player::ACTION_FILE_INFO] = cbFileInfo_K->getCurrentKey();
    
    p.remoteActions[Player::ACTION_PLAY_STOP] = cbPlayStop_R->getCurrentKey();
    p.remoteActions[Player::ACTION_PAUSE_RESUME] = cbPauseResume_R->getCurrentKey();
    p.remoteActions[Player::ACTION_VOLUME_UP] = cbVolumeUp_R->getCurrentKey();
    p.remoteActions[Player::ACTION_VOLUME_DOWN] = cbVolumeDown_R->getCurrentKey();
    p.remoteActions[Player::ACTION_MUTE] = cbMute_R->getCurrentKey();
    p.remoteActions[Player::ACTION_SEEK_F10] = cbForward10_R->getCurrentKey();
    p.remoteActions[Player::ACTION_SEEK_B10] = cbBackward10_R->getCurrentKey();
    p.remoteActions[Player::ACTION_SEEK_F60] = cbForward60_R->getCurrentKey();
    p.remoteActions[Player::ACTION_SEEK_B60] = cbBackward60_R->getCurrentKey();
    p.remoteActions[Player::ACTION_SEEK_F600] = cbForward600_R->getCurrentKey();
    p.remoteActions[Player::ACTION_SEEK_B600] = cbBackward600_R->getCurrentKey();
    p.remoteActions[Player::ACTION_NEXT] = cbNext_R->getCurrentKey();
    p.remoteActions[Player::ACTION_PREV] = cbPrev_R->getCurrentKey();
    p.remoteActions[Player::ACTION_OSD] = cbOSD_R->getCurrentKey();
    p.remoteActions[Player::ACTION_SUBTITLES] = cbSubtitles_R->getCurrentKey();
    
    p.remoteActions[Player::ACTION_ADD_TO_PLAYLIST] = cbAddToPlaylist_R->getCurrentKey();
    p.remoteActions[Player::ACTION_REMOVE_FROM_PLAYLIST] = cbRemoveFromPlaylist_R->getCurrentKey();
    p.remoteActions[Player::ACTION_PLAYLIST_UP] = cbPlaylistUp_R->getCurrentKey();
    p.remoteActions[Player::ACTION_PLAYLIST_DOWN] = cbPlaylistDown_R->getCurrentKey();
    p.remoteActions[Player::ACTION_FILE_INFO] = cbFileInfo_R->getCurrentKey();

    p.extrakeyActions[Player::ACTION_PLAY_STOP] = cbPlayStop_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_PAUSE_RESUME] = cbPauseResume_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_VOLUME_UP] = cbVolumeUp_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_VOLUME_DOWN] = cbVolumeDown_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_MUTE] = cbMute_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_SEEK_F10] = cbForward10_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_SEEK_B10] = cbBackward10_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_SEEK_F60] = cbForward60_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_SEEK_B60] = cbBackward60_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_SEEK_F600] = cbForward600_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_SEEK_B600] = cbBackward600_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_NEXT] = cbNext_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_PREV] = cbPrev_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_OSD] = cbOSD_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_SUBTITLES] = cbSubtitles_E->getCurrentKey();
    
    p.extrakeyActions[Player::ACTION_ADD_TO_PLAYLIST] = cbAddToPlaylist_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_REMOVE_FROM_PLAYLIST] = cbRemoveFromPlaylist_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_PLAYLIST_UP] = cbPlaylistUp_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_PLAYLIST_DOWN] = cbPlaylistDown_E->getCurrentKey();
    p.extrakeyActions[Player::ACTION_FILE_INFO] = cbFileInfo_E->getCurrentKey();

    return p;
}

void KinoSettings::cacheToggled(bool enable)
{
	s_cache->setEnabled(enable);
}

void KinoSettings::cpuToggled(bool enable)
{
	s_v_cpu->setEnabled(enable);
	s_a_cpu->setEnabled(enable);
}

