#ifndef _KINOSETTINGS_H_
#define _KINOSETTINGS_H_

#include <qvariant.h>
#include <qdialog.h>
#include <qcstring.h>
#include <qstringlist.h>
#include <qlineedit.h>
#include <qwhatsthis.h>
#include <qmap.h>

#include "kinosettingsbase.h"

class KinoPrefs {
public:
	//Playback
	bool		f_normal;
	bool		f_repeat;
	bool		f_random;
	
	bool		f_cpu;
	QString		s_v_cpu;
	QString	 	s_a_cpu;
	int		s_priority;
	QString         s_cpu;

	QString 	s_mplayeroptions;
	bool		f_debug;
	QString 	s_types;
	
	QString 	s_url_history;
	QString 	s_history;
	
    // Media Stream
    bool		f_cache;
    int			s_cache;
    int			s_bandwidth;
    
    // Video
    bool		f_dropframes;
    bool		f_directrendering;
    bool		f_doublebuffer;
    bool		f_smart_crop;
    bool		f_rotate;
    bool		f_index;
    bool		f_external_mem;
    bool		f_noaspect;
    bool                f_w100overlay;
    bool                f_bvddoverlay;
    // Audio 
    bool		f_resample;
    bool		f_lcd_off;
    bool		f_fade;
	
	// Playlist
    bool		f_playonclick;
    bool		f_saveplaylist;
    QString		s_enc_mp3;
    QString		s_enc_playlist;

	// Controls
    bool		f_remote;
    bool                f_extrakey;
    QStringList         l_freq;

    typedef QMap<int, int> ActionsMap;
	ActionsMap keyboardActions, remoteActions, extrakeyActions;
};

class KinoSettings : public KinoSettingsBase
{ 
    Q_OBJECT

public:
    KinoSettings( QWidget* parent = 0, const QString &name = "", bool modal = FALSE, WFlags fl = 0 );
    ~KinoSettings();

    void setSettings(KinoPrefs p);
    KinoPrefs getSettings(KinoPrefs s);
    
protected slots:
    void cacheToggled(bool);
    void cpuToggled(bool);
};

#endif
