#include <qmessagebox.h>
#include <qstringlist.h>
#include <qfile.h>
#include <qcstring.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qstringlist.h>

#include "misc.h"

InputDialog::InputDialog( QWidget* parent,  const QString &name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    resize( 400, 50 ); 
    setMaximumSize( QSize( 400, 50 ) );
    setCaption( name );

	input = new QComboBox(true, this);

    //LineEdit1 = new QLineEdit( this, "LineEdit1" );
    input->setGeometry(QRect( 10, 10, 380, 30 ) );
    input->setFocus();
	input->setAutoCompletion(true);
	input->setDuplicatesEnabled(false);
    connect(input->lineEdit(), SIGNAL(returnPressed()), this, SLOT(returned() ));
}

InputDialog::~InputDialog() {
}

QString InputDialog::getInputText() {
	return input->currentText();
}

void InputDialog::returned() {
    this->accept();
}

void InputDialog::setHistory(const QString &string) {
	input->clear();
	input->insertStringList(QStringList::split(",", string));
}

QString InputDialog::getHistory() {
	QString s;
	for (int i = 0; i < input->count(); i++) {
		s += input->text(i);
		if (i < (input->count() - 1) )
			s += ",";
	}
	
	return s;
}
