/****************************************************************************************
 * (c) Cacko Team,2002,2003								*
 * Kino2 video player									*
 * http://www.cacko.biz									*
 ****************************************************************************************/

#include <qmenubar.h>
#include <qtoolbar.h>
#include <qapplication.h>
#include <qmainwindow.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>
#include <qtoolbutton.h>
#include <qtimer.h>
#include <qdir.h>
#include <qlcdnumber.h>
#include <qslider.h>
#include <qgfx_qws.h>
#include <qstringlist.h>
#include <qtextcodec.h>
#include <qtextstream.h>
#include <qregexp.h>
#include <qvbox.h>
#include <qslider.h> 
#include <qheader.h> 

#include <qpe/global.h>
#include <qpe/qpemenubar.h>
#include <qpe/qpetoolbar.h>
#include <qpe/config.h>
#include <qpe/resource.h>
#include <qpe/applnk.h>
#include <qpe/power.h>
#include <qpe/qpeapplication.h> 
#include <qpe/menubutton.h> 

#include <sl/slfileselector.h>
#include <sl/slmisc.h>
#include <sl/sldlgwait.h>

#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <errno.h>
#include <linux/soundcard.h>

#include "player.h"
//#include "ptyprocess.h"
//#include "control.h"
#include "misc.h"
#include "kinosettings.h"
#include "mediainfobase.h"
#include "playlist.h"
#include "RemoteControlButton.h"
#include "FileDialog.h"

#define KINO_VERSION		"0.4"
#define MPLAYER				"mplayer"
#define DEFAULT_FILE_TYPES  "*.mp3;*.ogg;*.wma;*.wav;*.asf;*.au;*.avi;*.mpeg;*.mpg;*.mv1;*.mov;*.wmv;*.pls;*.m3u"
#define DEFAULT_PLAYLIST    "/.playlist/Playlist.m3u"

int set_volume(int value);
int get_volume(void);

Player::Player( QWidget* parent, const char* name, WFlags fl )
    : QMainWindow( parent, name, fl ), isPlaying(false), isPausing(false), isIdentify(false), 
      isAddToPlaylist(false), isLCDBlank(false), isAutoplay(false), isVideoFile(false), isIgnoreOutput(false)
{
    setSelectedFile("");
    setToolBarsMovable(false);

    freq = "";

    m_fileMenu = new QPopupMenu(this);
    connect(m_fileMenu, SIGNAL(activated(int)), this, SLOT(fileMenu(int)));
    m_fileMenu->insertItem(tr("Open..."), FILE_OPEN);
    m_fileMenu->insertItem(tr("Open URL..."), FILE_OPEN_URL);
    m_fileMenu->insertItem(tr("Save playlist..."), FILE_SAVE_PLAYLIST);
    m_fileMenu->insertSeparator(FILE_SEPARATOR1);
    m_fileMenu->insertItem(tr("File info..."), FILE_INFO);
    m_fileMenu->insertSeparator(FILE_SEPARATOR2);
    m_fileMenu->insertItem(tr("Preferences..."), FILE_PREFS);

    m_viewMenu = new QPopupMenu(this);
    m_viewMenu->setCheckable(true);
    connect(m_viewMenu, SIGNAL(activated(int)), this, SLOT(viewMenu(int)));
    m_viewMenu->insertItem(tr("Scale"), VIEW_SCALE);
    m_viewMenu->insertItem(tr("Turn LCD Off"), VIEW_LCD_OFF);
    m_viewMenu->insertSeparator(VIEW_SEPARATOR1);
    m_viewMenu->insertItem(tr("Playlist"), VIEW_PLAYLIST);
    m_viewMenu->insertItem(tr("Slider"), VIEW_SLIDER);

    m_helpMenu = new QPopupMenu(this);
    connect(m_helpMenu, SIGNAL(activated(int)), this, SLOT(helpMenu(int)));
    m_helpMenu->insertItem(tr("About"), 0);

    bar = new QToolBar(this);
    bar->setHorizontalStretchable( TRUE );

    menu = new QPEMenuBar(bar);
    menu->insertItem(tr("File"), m_fileMenu);
    menu->insertItem(tr("View"), m_viewMenu);
    menu->insertItem(tr("Help"), m_helpMenu);

    bar = new QPEToolBar(this);
    info = new QToolButton(Resource::loadPixmap("kino2/info"), tr("File Info"), tr("File Info"), this, SLOT(displayFileInfo()), bar);
    addToPls = new QToolButton(Resource::loadPixmap("kino2/add_to_playlist"),tr("Add to playlist"),tr("Add track to playlist"), this,SLOT(addToPlaylist()),bar);
    delFromPls = new QToolButton(Resource::loadPixmap("kino2/remove_from_playlist"),tr("Remove from playlist"),tr("Remove track from playlist"), this,SLOT(removeFromPlaylist()),bar);

    stack = new QWidgetStack( this );
    stack->setSizePolicy( QSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding ) );
    setCentralWidget( stack );

    contents = new PlayerBase( stack );
    stack->addWidget( contents, 0 );
    stack->raiseWidget( contents );
    isSlf = false;

    contents->screen->setBackgroundColor(Qt::black);
    splash = contents->screen->pixmap();
    
    contents->screen->show();
    contents->playlist->resize(contents->screen->size());
    
    contents->play_button->setPixmap(Resource::loadPixmap("kino2/player_play"));
    contents->stop_button->setEnabled(false);

    up = new QToolButton(Resource::loadPixmap("kino2/up"), tr("Move up"), tr("Move track up in playlist"), contents->playlist, SLOT(up()), bar);
    down = new QToolButton(Resource::loadPixmap("kino2/down"), tr("Move down"), tr("Move track down in playlist"), contents->playlist, SLOT(down()), bar);
    
    m_columnsMenu = new QPopupMenu(this);
    QStringList list = contents->playlist->columns();
    QStringList::Iterator it = list.begin();
    
    // skip first two
    it++;
    it++;
	for (; it != list.end(); ++it)
	    m_columnsMenu->insertItem(*it);
	    
	connect(m_columnsMenu, SIGNAL(activated(int)), this, SLOT(columnsMenu(int)));    
	
    columns = new QToolButton(Resource::loadPixmap("kino2/playlist"), tr("Columns"), tr("Columns"), 0, "", bar);
    columns->setPopup(m_columnsMenu);
	columns->setPopupDelay(0);

    connect(contents->playlist, SIGNAL(currentChanged(QListViewItem*)), this, SLOT( currentChanged(QListViewItem*)));
    connect(contents->playlist, SIGNAL(clicked(QListViewItem*)), this, SLOT( clicked(QListViewItem*)));
    connect(contents->playlist, SIGNAL(keyPressed(QKeyEvent *, bool&)), this, SLOT(keyPressed(QKeyEvent *, bool&)));

	contents->start_button->setPixmap(Resource::loadPixmap("kino2/player_start"));
	contents->end_button->setPixmap(Resource::loadPixmap("kino2/player_end"));

    connect( contents->start_button, SIGNAL(clicked()), this, SLOT(startClicked()));
    connect( contents->end_button, SIGNAL(clicked()), this, SLOT(endClicked()));
    
    connect( contents->play_button, SIGNAL(clicked()), this, SLOT(playClicked()));
    connect( contents->stop_button, SIGNAL(clicked()), this, SLOT(stopClicked()));
    connect( contents->eject_button, SIGNAL(clicked()), this, SLOT(ejectClicked()));
    connect( contents->rev_button, SIGNAL(clicked()), this, SLOT(revClicked()));
    connect( contents->fwd_button, SIGNAL(clicked()), this, SLOT(fwdClicked()));

    process = new OProcess(this);
    connect(process, SIGNAL(processExited(OProcess *)), this, SLOT(processExited(OProcess *)));
    connect(process, SIGNAL(receivedStdout(OProcess *, char *, int)), 
    	this, SLOT(receivedStdout(OProcess *, char *, int)));
    connect(process, SIGNAL(receivedStderr(OProcess *, char *, int)), 
    	this, SLOT(receivedStderr(OProcess *, char *, int)));
    connect(process, SIGNAL(wroteStdin(OProcess *)), this, SLOT(wroteStdin(OProcess *)));
    
    channel = new QCopChannel("QPE/Application/kino2", this);
    connect(channel, SIGNAL(received(const QCString&, const QByteArray&)), 
	    this, SLOT(setDocument(const QCString&, const QByteArray&)));
		
    sysChannel = new QCopChannel("QPE/System", this);
    connect(sysChannel, SIGNAL(received(const QCString&, const QByteArray&)),
	  this, SLOT(setBlankLCD(const QCString&, const QByteArray&)));

    if ( QCopChannel::isRegistered("QPE/BatteryPlus") ){
      freqChannel = new QCopChannel("QPE/BatteryRecv", this);
      connect(freqChannel, SIGNAL(received(const QCString&, const QByteArray&)),
	  this, SLOT(batteryReceived(const QCString&, const QByteArray&)));
    }else {
      freqChannel = 0;
    }
    
    loadSettings();

    if ( QCopChannel::isRegistered("QPE/BatteryPlus") ){
      QCopEnvelope e("QPE/BatteryPlus", "readConf()" );
    }
    
    filter = new FileSelectionFilter(kinoPrefs.s_types, this);

    slf = new SlFileSelector("", "", stack, "");
    slf->setFilter(filter);
    connect(slf, SIGNAL(fileSelected(const QFileInfo &)), this, SLOT(slFileSelected(const QFileInfo &)));
    connect(slf, SIGNAL(keyPressed(QKeyEvent*, bool&)), this, SLOT(slKeyPressed(QKeyEvent *, bool&)));
    slf->setListView();

    connect(qApp, SIGNAL(volumeChanged(bool)), this, SLOT(volumeChanged(bool)));
    readSystemVolume();
    
	wait = new SlDlgWait(this, tr("Loading file(s)..."), true, false);
	wait->hide();
	
	connect(contents->progress, SIGNAL(sliderMoved(int)), this, SLOT(sliderMoved(int)));
	
	if (kinoPrefs.f_saveplaylist)
	{
		QTimer* t = new QTimer(this);
		connect(t, SIGNAL(timeout()), this, SLOT(loadPlaylist()));
		t->start(1000, true);
	}
}

Player::~Player()
{
    saveSettings();
    
	if (kinoPrefs.f_saveplaylist)
		savePlaylist(QPEApplication::documentDir() + DEFAULT_PLAYLIST);
    
    delete process;
}

void Player::setupButtons()
{
	info->setEnabled(stack->visibleWidget() != slf && contents->playlist->currentItem() != 0);
	
    addToPls->setEnabled(stack->visibleWidget() == slf && !isAddToPlaylist);
    delFromPls->setEnabled(contents->playlist->isVisible() && contents->playlist->currentItem() != 0);

    up->setEnabled(contents->playlist->isVisible() && contents->playlist->currentItem() != 0);
    down->setEnabled(contents->playlist->isVisible() && contents->playlist->currentItem() != 0);
    
    columns->setEnabled(contents->playlist->isVisible());
}

void Player::sendCommand(const QString& command)
{
	if (command == "quit\n")
		isManualStop = true;
		
	process->writeStdin(command, command.length());
	
	if (kinoPrefs.f_debug)
		qDebug("=>" + command);
}

void Player::setDocument(const QCString& msg, const QByteArray& data) 
{
  QDataStream stream(data, IO_ReadOnly);
  if(msg == "setDocument(QString)"){
    QString file;
    stream >> file;

    QFileInfo fi(file);
    
    if (fi.exists())
      {
	isAutoplay = true;
	addFile(fi);
//		playClicked();
      }
  }
}

bool Player::addUrl(const QString& url)
{
    isAddToPlaylist = true;
    qDebug(url+"addurl\n");
   	identifyFile(url);
   	return true;
}
			  
bool Player::addFile(const QFileInfo& fileInfo)
{
    isAddToPlaylist = true;
   	identifyFile(fileInfo.absFilePath());
   	return true;
}

bool Player::addFolder(const QFileInfo& fileInfo)
{
	QDir dir(fileInfo.absFilePath());
	QStringList files  = dir.entryList(kinoPrefs.s_types);
	QStringList list;
	
	if (files.isEmpty())
		return false;
	
	for (QStringList::Iterator it = files.begin(); it != files.end(); ++it)
	{
		if (!(*it).contains(".m3u") && !(*it).contains(".pls"))
			list << fileInfo.filePath() + "/" + (*it);
	}
	
	if (list.count() > 0)
	{
	    isAddToPlaylist = true;
	   	identifyFile(list);
		return true;
	}
	
	return false;
}

bool Player::addPlaylist(const QFileInfo& fileInfo)
{
	QFile file(fileInfo.absFilePath());
	if (!file.open(IO_ReadOnly))
		return false;
	
	QTextCodec* codec = QTextCodec::codecForName(kinoPrefs.s_enc_mp3);
	QStringList files;
	char buffer[256];
	int buflen = 0;
	
	while((buflen = file.readLine(buffer, 255)) != -1)
	{
		QString str = QString::fromLocal8Bit(buffer, buflen);
		if (codec != 0)
			str = codec->toUnicode(buffer, buflen);
		
		if (str[str.length() - 1] == '\n')
			str.truncate(str.length() - 1);
	
		QFileInfo fi;
		if (fileInfo.extension() == "m3u")
		{
			if (str.startsWith("#"))
				continue;
				
			fi.setFile(str);
		}
		else if (fileInfo.extension() == "pls")
		{
			if (!str.startsWith("File"))
				continue;
				
			str = str.mid(str.find("=") + 1);	
			fi.setFile(str);
		}
		
		if (!fi.exists())
			fi.setFile(fileInfo.dirPath() + "/" + str);
			
		if (!fi.exists())	
			continue;
			
		files << fi.absFilePath();
		
	}
	
	if (files.count() > 0)
	{
	    isAddToPlaylist = true;
	   	identifyFile(files);
		return true;
	}
	
	return false;
}

void Player::savePlaylist(const QString& file)
{
    QString list;
	QTextCodec* codec = QTextCodec::codecForName(kinoPrefs.s_enc_mp3);

    QFile f(file);
    f.open(IO_WriteOnly | IO_Truncate);
    if (f.isOpen()) 
    {
	    QListViewItemIterator it(contents->playlist);
	    for(; it.current(); it++)
	    {
	    	QString name = it.current()->text(0) + "\n";
	    	if (codec != 0)
	    		name = codec->fromUnicode(name);
	    	else
	    		name = name.local8Bit();
	    		
		    f.writeBlock(name, name.length());
	    }
	    f.close();
    }
}
			  
void Player::addToPlaylist()
{
	if (!addToPls->isEnabled())
		return;
	
	QFileInfo fileInfo(slf->currentFile());	
	
	if (fileInfo.extension() == "m3u" || fileInfo.extension() == "pls")
	{
		if (addPlaylist(fileInfo))
		{
			setupButtons();
			slf->setSelectedNext(true);
			return;
		}
	}
	
	if (fileInfo.isFile())
	{
		if (addFile(fileInfo))
		{
			setupButtons();
			slf->setSelectedNext(true);
			return;
		}
	}
		
	if (fileInfo.isDir())	
	{
		if (addFolder(fileInfo))
		{
			setupButtons();
			slf->setSelectedNext(true);
			return;
		}
	}
}

void Player::removeFromPlaylist(void)
{
	if (!delFromPls->isEnabled())
		return;
		
    QListViewItem *currentItem = contents->playlist->currentItem();
    if (currentItem)
    {
    	QString currentFile = currentItem->text(0);
    	contents->playlist->removeFromPlaylist();
    
    	// only remove file info if there are no same items in the list
		QListViewItem* item = contents->playlist->firstChild();
		while (item)
		{
			// there is another item with the same name, so don't remove media info
			if (item->text(0) == currentFile)
				return;
				
			item = item->itemBelow();
		}
	    	
    	minfo.remove(currentFile);
    }	
}

void Player::loadPlaylist()
{
	QFileInfo playlist(QPEApplication::documentDir() + DEFAULT_PLAYLIST);
	if (playlist.exists() && !isAutoplay)
		addPlaylist(playlist);
}

void Player::currentChanged(QListViewItem* item)
{
	if (item != 0)
	{
		QString fullName = item->text(0);
	    setSelectedFile(fullName);
	    contents->playlist->ensureItemVisible(item);
	}
	else
	{
	    setSelectedFile("");
	}
	
	setupButtons();
}

void Player::clicked(QListViewItem* item)
{
	if (item != 0 && kinoPrefs.f_playonclick && !isPlaying)
		playClicked();
}

void Player::closeEvent(QCloseEvent *e)
{
    if (isLCDBlank)
    {
    	isLCDBlank = false;
    	return;
    }

    if (isPlaying) 
    {
    	stop();
    	
//		if (isPausing) 
//		{
//			resume();
//		    isPausing = false;
//		    sendCommand("pause\n");
//		    contents->play_button->setPixmap(Resource::loadPixmap("kino2/player_pause"));
//		}
//		sendCommand("quit\n");
    } 
    else if (stack->visibleWidget() == contents) 
    {
    	if (process->isRunning())
    		process->kill();
    		
		e->accept();
    } 
    else 
    {
		stack->raiseWidget(contents);
		setupButtons();
		isSlf = false;
    }
}

void Player::loadSettings()
{
    Config cfg("kino2");
    cfg.setGroup("View");
    useScale = cfg.readBoolEntry("Scale");
    m_viewMenu->setItemChecked(VIEW_SCALE, useScale);
//    useFullscreen = cfg.readBoolEntry("Fullscreen");
//    m_viewMenu->setItemChecked(1, useFullscreen);
    
    bool playlistVisible = cfg.readBoolEntry("playlist", false);
    showPlaylist(playlistVisible);

    bool sliderVisible = cfg.readBoolEntry("slider", true);
	showSlider(sliderVisible);

    cfg.setGroup("Player");
    kinoPrefs.f_random = cfg.readBoolEntry("random", false);
    kinoPrefs.f_repeat = cfg.readBoolEntry("repeat", false);
    kinoPrefs.f_normal = cfg.readBoolEntry("normal", true);

    kinoPrefs.f_cpu = cfg.readBoolEntry("cpu", false);

    kinoPrefs.s_v_cpu = cfg.readEntry("v_cpu");
    kinoPrefs.s_a_cpu = cfg.readEntry("a_cpu");

    kinoPrefs.s_priority = cfg.readNumEntry("priority", 0);
    kinoPrefs.f_debug = cfg.readBoolEntry("debug", false);
    
    kinoPrefs.s_mplayeroptions = cfg.readEntry("mplayeroptions");
    kinoPrefs.s_types = cfg.readEntry("types", DEFAULT_FILE_TYPES);
    kinoPrefs.s_history = cfg.readEntry("history");
    kinoPrefs.s_url_history = cfg.readEntry("url_history");

    cfg.setGroup("Media Stream");
    kinoPrefs.f_cache = cfg.readBoolEntry("cache", false);
    kinoPrefs.s_cache = cfg.readNumEntry("cache_size", 0);
    kinoPrefs.s_bandwidth = cfg.readNumEntry("bandwidth", 0);

    cfg.setGroup("Video");
    kinoPrefs.f_doublebuffer = cfg.readBoolEntry("doublebuffer", true);
    kinoPrefs.f_dropframes = cfg.readBoolEntry("framedrop", true);
    kinoPrefs.f_directrendering = cfg.readBoolEntry("directrendering", true);
    kinoPrefs.f_smart_crop = cfg.readBoolEntry("crop", false);
    kinoPrefs.f_rotate = cfg.readBoolEntry("rotate", true);
    kinoPrefs.f_index = cfg.readBoolEntry("index", false);
    kinoPrefs.f_external_mem = cfg.readBoolEntry("external_mem", true);
    kinoPrefs.f_noaspect = cfg.readBoolEntry("noaspect", false);
    

    {
      QFile f("/proc/deviceinfo/product");
      if(f.open(IO_ReadOnly) ){
	QString s;
	f.readLine(s, 9);
	if (s == QString("SL-C3000") ){
	  kinoPrefs.f_w100overlay = cfg.readBoolEntry("w100overlay", false);
	  kinoPrefs.f_bvddoverlay = cfg.readBoolEntry("bvddoverlay", true);
	}else{
	  kinoPrefs.f_w100overlay = cfg.readBoolEntry("w100overlay", true);
	  kinoPrefs.f_bvddoverlay = cfg.readBoolEntry("bvddoverlay", false);
	}
	f.close();
      }else{
	kinoPrefs.f_w100overlay = cfg.readBoolEntry("w100overlay", true);
	kinoPrefs.f_bvddoverlay = cfg.readBoolEntry("bvddoverlay", false);
      }
    }
    
    cfg.setGroup("Audio");
    kinoPrefs.f_resample = cfg.readBoolEntry("resample", true);
    kinoPrefs.f_lcd_off = cfg.readBoolEntry("lcd_off", false);
    kinoPrefs.f_fade = cfg.readBoolEntry("fade", false);
    
    cfg.setGroup("Playlist");
    kinoPrefs.f_playonclick = cfg.readBoolEntry("playonclick", false);
    kinoPrefs.f_saveplaylist = cfg.readBoolEntry("saveplaylist", false); 
   
	// load playlist columns
	QHeader* header = contents->playlist->header();
	for (int i = PlaylistView::COLUMN_TRACK; i >= PlaylistView::COLUMN_NAME; i--)
	{
		int pos = cfg.readNumEntry(QString::number(i), i);
		int size = cfg.readNumEntry(QString::number(i) + "w", -1);	
		
		if (i != pos)
			header->moveSection(i, pos);
		
		if (size < 0)	// first time
			contents->playlist->setColumnWidthMode(i, QListView::Maximum);
			
//		if (size == 0)	// turned off by user
//			contents->playlist->setColumnWidthMode(i, QListView::Manual);
		
		if (size >= 0)
		{
			contents->playlist->setColumnWidthMode(i, QListView::Manual);
			header->resizeSection(i, size);
		}
		
		m_columnsMenu->setItemChecked(m_columnsMenu->idAt(i - 2), size != 0);
	}
	
	contents->playlist->triggerUpdate();
    
    cfg.setGroup("Controls");
    kinoPrefs.f_remote = cfg.readBoolEntry("remote", true);
    kinoPrefs.f_extrakey = cfg.readBoolEntry("extrakey", false);
    
    kinoPrefs.keyboardActions[ACTION_PLAY_STOP] = cfg.readNumEntry("PlayStop_K", Key_Space);
    kinoPrefs.keyboardActions[ACTION_PAUSE_RESUME] = cfg.readNumEntry("PauseResume_K", Key_Return);
    kinoPrefs.keyboardActions[ACTION_VOLUME_UP] = cfg.readNumEntry("VolumeUp_K", Key_Up);
    kinoPrefs.keyboardActions[ACTION_VOLUME_DOWN] = cfg.readNumEntry("VolumeDown_K", Key_Down);
    kinoPrefs.keyboardActions[ACTION_MUTE] = cfg.readNumEntry("Mute_K", Key_M);
    kinoPrefs.keyboardActions[ACTION_SEEK_F10] = cfg.readNumEntry("Forward10_K", Key_Right);
    kinoPrefs.keyboardActions[ACTION_SEEK_B10] = cfg.readNumEntry("Backward10_K", Key_Left);
    kinoPrefs.keyboardActions[ACTION_SEEK_F60] = cfg.readNumEntry("Forward60_K", Key_C);
    kinoPrefs.keyboardActions[ACTION_SEEK_B60] = cfg.readNumEntry("Backward60_K", Key_X);
    kinoPrefs.keyboardActions[ACTION_SEEK_F600] = cfg.readNumEntry("Forward600_K", Key_V);
    kinoPrefs.keyboardActions[ACTION_SEEK_B600] = cfg.readNumEntry("Backward600_K", Key_Z);
    kinoPrefs.keyboardActions[ACTION_NEXT] = cfg.readNumEntry("Next_K", Key_N);
    kinoPrefs.keyboardActions[ACTION_PREV] = cfg.readNumEntry("Prev_K", Key_B);
    kinoPrefs.keyboardActions[ACTION_OSD] = cfg.readNumEntry("OSD_K", Key_O);
    kinoPrefs.keyboardActions[ACTION_SUBTITLES] = cfg.readNumEntry("Subtitles_K", Key_S);
    kinoPrefs.keyboardActions[ACTION_ADD_TO_PLAYLIST] = cfg.readNumEntry("AddToPlaylist_K", Key_A);
    kinoPrefs.keyboardActions[ACTION_REMOVE_FROM_PLAYLIST] = cfg.readNumEntry("RemoveFromPlaylist_K", Key_R);
    kinoPrefs.keyboardActions[ACTION_PLAYLIST_UP] = cfg.readNumEntry("PlaylistUp_K", Key_U);
    kinoPrefs.keyboardActions[ACTION_PLAYLIST_DOWN] = cfg.readNumEntry("PlaylistDown_K", Key_D);
    kinoPrefs.keyboardActions[ACTION_FILE_INFO] = cfg.readNumEntry("FileInfo_K", Key_I);
    
    kinoPrefs.remoteActions[ACTION_PLAY_STOP] = cfg.readNumEntry("PlayStop_R", RemoteControlButton::KEY_STOP);
    kinoPrefs.remoteActions[ACTION_PAUSE_RESUME] = cfg.readNumEntry("PauseResume_R", RemoteControlButton::KEY_PLAY_PAUSE);
    kinoPrefs.remoteActions[ACTION_VOLUME_UP] = cfg.readNumEntry("VolumeUp_R", RemoteControlButton::KEY_VOLUME_UP);
    kinoPrefs.remoteActions[ACTION_VOLUME_DOWN] = cfg.readNumEntry("VolumeDown_R", RemoteControlButton::KEY_VOLUME_DOWN);
    kinoPrefs.remoteActions[ACTION_MUTE] = cfg.readNumEntry("Mute_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_SEEK_F10] = cfg.readNumEntry("Forward10_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_SEEK_B10] = cfg.readNumEntry("Backward10_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_SEEK_F60] = cfg.readNumEntry("Forward60_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_SEEK_B60] = cfg.readNumEntry("Backward60_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_SEEK_F600] = cfg.readNumEntry("Forward600_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_SEEK_B600] = cfg.readNumEntry("Backward600_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_NEXT] = cfg.readNumEntry("Next_R", RemoteControlButton::KEY_FORWARD);
    kinoPrefs.remoteActions[ACTION_PREV] = cfg.readNumEntry("Prev_R", RemoteControlButton::KEY_BACKWARD);
    kinoPrefs.remoteActions[ACTION_OSD] = cfg.readNumEntry("OSD_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_SUBTITLES] = cfg.readNumEntry("Subtitles_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_ADD_TO_PLAYLIST] = cfg.readNumEntry("AddToPlaylist_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_REMOVE_FROM_PLAYLIST] = cfg.readNumEntry("RemoveFromPlaylist_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_PLAYLIST_UP] = cfg.readNumEntry("PlaylistUp_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_PLAYLIST_DOWN] = cfg.readNumEntry("PlaylistDown_R", RemoteControlButton::KEY_NONE);
    kinoPrefs.remoteActions[ACTION_FILE_INFO] = cfg.readNumEntry("FileInfo_R", RemoteControlButton::KEY_NONE);

    kinoPrefs.extrakeyActions[ACTION_PLAY_STOP] = cfg.readNumEntry("PlayStop_E", 0); 
    kinoPrefs.extrakeyActions[ACTION_PAUSE_RESUME] = cfg.readNumEntry("PauseResume_E", 0x2009);//cover switch
    kinoPrefs.extrakeyActions[ACTION_VOLUME_UP] = cfg.readNumEntry("VolumeUp_E", 0);
    kinoPrefs.extrakeyActions[ACTION_VOLUME_DOWN] = cfg.readNumEntry("VolumeDown_E", 0);
    kinoPrefs.extrakeyActions[ACTION_MUTE] = cfg.readNumEntry("Mute_E", 0);
    kinoPrefs.extrakeyActions[ACTION_SEEK_F10] = cfg.readNumEntry("Forward10_E", 0);
    kinoPrefs.extrakeyActions[ACTION_SEEK_B10] = cfg.readNumEntry("Backward10_E", 0);
    kinoPrefs.extrakeyActions[ACTION_SEEK_F60] = cfg.readNumEntry("Forward60_E", 0);
    kinoPrefs.extrakeyActions[ACTION_SEEK_B60] = cfg.readNumEntry("Backward60_E", 0);
    kinoPrefs.extrakeyActions[ACTION_SEEK_F600] = cfg.readNumEntry("Forward600_E", 0);
    kinoPrefs.extrakeyActions[ACTION_SEEK_B600] = cfg.readNumEntry("Backward600_E", 0);
    kinoPrefs.extrakeyActions[ACTION_NEXT] = cfg.readNumEntry("Next_E", 0);
    kinoPrefs.extrakeyActions[ACTION_PREV] = cfg.readNumEntry("Prev_E", 0);
    kinoPrefs.extrakeyActions[ACTION_OSD] = cfg.readNumEntry("OSD_E", 0);
    kinoPrefs.extrakeyActions[ACTION_SUBTITLES] = cfg.readNumEntry("Subtitles_E", 0);
    kinoPrefs.extrakeyActions[ACTION_ADD_TO_PLAYLIST] = cfg.readNumEntry("AddToPlaylist_E", 0);
    kinoPrefs.extrakeyActions[ACTION_REMOVE_FROM_PLAYLIST] = cfg.readNumEntry("RemoveFromPlaylist_E", 0);
    kinoPrefs.extrakeyActions[ACTION_PLAYLIST_UP] = cfg.readNumEntry("PlaylistUp_E", 0);
    kinoPrefs.extrakeyActions[ACTION_PLAYLIST_DOWN] = cfg.readNumEntry("PlaylistDown_E", 0);
    kinoPrefs.extrakeyActions[ACTION_FILE_INFO] = cfg.readNumEntry("FileInfo_E", 0);
    
    // Encodings
    kinoPrefs.s_enc_mp3 = cfg.readEntry("enc_mp3", QTextCodec::codecForLocale()->name());
    kinoPrefs.s_enc_playlist = cfg.readEntry("enc_playlist", QTextCodec::codecForLocale()->name());
    
	// read user display settings related	
    Config qpeconfig("qpe");
    if (qpeconfig.isValid())
    {
    	//qpeconfig->setGroup("BatteryPower");
		qpeconfig.setGroup("Screensaver");
		if (qpeconfig.hasKey("Interval"))
		{
			intervalSuspend = qpeconfig.readNumEntry("Interval", 60);
			intervalLightOff = qpeconfig.readNumEntry("Interval_LightOff", 30);
			intervalDim = qpeconfig.readNumEntry( "Interval_Dim", 20 );
		}
	}

    
}

void Player::saveSettings()
{
    Config cfg("kino2");
    cfg.setGroup("View");
    cfg.writeEntry("Scale", useScale);
    cfg.writeEntry("playlist", m_viewMenu->isItemChecked(3));
    cfg.writeEntry("slider", m_viewMenu->isItemChecked(4));
    
    cfg.setGroup("Player");
    cfg.writeEntry("random", kinoPrefs.f_random);
    cfg.writeEntry("repeat", kinoPrefs.f_repeat);
    cfg.writeEntry("normal", kinoPrefs.f_normal);
    
    cfg.writeEntry("cpu", kinoPrefs.f_cpu);        
    cfg.writeEntry("v_cpu", kinoPrefs.s_v_cpu);
    cfg.writeEntry("a_cpu", kinoPrefs.s_a_cpu);
    cfg.writeEntry("priority", kinoPrefs.s_priority);
    cfg.writeEntry("debug", kinoPrefs.f_debug);
    
    cfg.writeEntry("mplayeroptions", kinoPrefs.s_mplayeroptions);    
    cfg.writeEntry("types", kinoPrefs.s_types);  
      
    cfg.writeEntry("history", kinoPrefs.s_history);    
    cfg.writeEntry("url_history", kinoPrefs.s_url_history);    

    cfg.setGroup("Media Stream");
    cfg.writeEntry("cache", kinoPrefs.f_cache);
    cfg.writeEntry("cache_size", kinoPrefs.s_cache);
    cfg.writeEntry("bandwidth", kinoPrefs.s_bandwidth);

    cfg.setGroup("Video");
    cfg.writeEntry("doublebuffer", kinoPrefs.f_doublebuffer);
    cfg.writeEntry("framedrop", kinoPrefs.f_dropframes);
    cfg.writeEntry("directrendering", kinoPrefs.f_directrendering);
    cfg.writeEntry("crop", kinoPrefs.f_smart_crop);
    cfg.writeEntry("rotate", kinoPrefs.f_rotate);
    cfg.writeEntry("index", kinoPrefs.f_index);
    cfg.writeEntry("external_mem", kinoPrefs.f_external_mem);
    cfg.writeEntry("noaspect", kinoPrefs.f_noaspect);
    cfg.writeEntry("w100overlay", kinoPrefs.f_w100overlay);
    cfg.writeEntry("bvddoverlay", kinoPrefs.f_bvddoverlay);

    cfg.setGroup("Audio");
    cfg.writeEntry("resample", kinoPrefs.f_resample);
    cfg.writeEntry("lcd_off", kinoPrefs.f_lcd_off);
    cfg.writeEntry("fade", kinoPrefs.f_fade);

    cfg.setGroup("Playlist");
    cfg.writeEntry("playonclick", kinoPrefs.f_playonclick);
    cfg.writeEntry("saveplaylist", kinoPrefs.f_saveplaylist);

	// save playlist columns
	QHeader* header = contents->playlist->header();
	for (int i = PlaylistView::COLUMN_NAME; i <= PlaylistView::COLUMN_TRACK; i++)
	{
		cfg.writeEntry(QString::number(i), header->mapToIndex(i));
		cfg.writeEntry(QString::number(i) + "w", header->sectionSize(i));
	}

    cfg.setGroup("Controls");
    cfg.writeEntry("remote", kinoPrefs.f_remote);
    {
	    Config cfg("qpe");
	    cfg.setGroup("Remocon");
	    cfg.writeEntry("master", kinoPrefs.f_remote ? "kino2" : "musicplayer");
    }
    cfg.writeEntry("extrakey", kinoPrefs.f_extrakey);
        
    cfg.writeEntry("PlayStop_K", kinoPrefs.keyboardActions[ACTION_PLAY_STOP]);
    cfg.writeEntry("PauseResume_K", kinoPrefs.keyboardActions[ACTION_PAUSE_RESUME]);
    cfg.writeEntry("VolumeUp_K", kinoPrefs.keyboardActions[ACTION_VOLUME_UP]);
    cfg.writeEntry("VolumeDown_K", kinoPrefs.keyboardActions[ACTION_VOLUME_DOWN]);
    cfg.writeEntry("Mute_K", kinoPrefs.keyboardActions[ACTION_MUTE]);
    cfg.writeEntry("Forward10_K", kinoPrefs.keyboardActions[ACTION_SEEK_F10]);
    cfg.writeEntry("Backward10_K", kinoPrefs.keyboardActions[ACTION_SEEK_B10]);
    cfg.writeEntry("Forward60_K", kinoPrefs.keyboardActions[ACTION_SEEK_F60]);
    cfg.writeEntry("Backward60_K", kinoPrefs.keyboardActions[ACTION_SEEK_B60]);
    cfg.writeEntry("Forward600_K", kinoPrefs.keyboardActions[ACTION_SEEK_F600]);
    cfg.writeEntry("Backward600_K", kinoPrefs.keyboardActions[ACTION_SEEK_B600]);
    cfg.writeEntry("Next_K", kinoPrefs.keyboardActions[ACTION_NEXT]);
    cfg.writeEntry("Prev_K", kinoPrefs.keyboardActions[ACTION_PREV]);
    cfg.writeEntry("OSD_K", kinoPrefs.keyboardActions[ACTION_OSD]);
    cfg.writeEntry("Subtitles_K", kinoPrefs.keyboardActions[ACTION_SUBTITLES]);
    cfg.writeEntry("AddToPlaylist_K", kinoPrefs.keyboardActions[ACTION_ADD_TO_PLAYLIST]);
    cfg.writeEntry("RemoveFromPlaylist_K", kinoPrefs.keyboardActions[ACTION_REMOVE_FROM_PLAYLIST]);
    cfg.writeEntry("PlaylistUp_K", kinoPrefs.keyboardActions[ACTION_PLAYLIST_UP]);
    cfg.writeEntry("PlaylistDown_K", kinoPrefs.keyboardActions[ACTION_PLAYLIST_DOWN]);
    cfg.writeEntry("FileInfo_K", kinoPrefs.keyboardActions[ACTION_FILE_INFO]);
    
    cfg.writeEntry("PlayStop_R", kinoPrefs.remoteActions[ACTION_PLAY_STOP]);
    cfg.writeEntry("PauseResume_R", kinoPrefs.remoteActions[ACTION_PAUSE_RESUME]);
    cfg.writeEntry("VolumeUp_R", kinoPrefs.remoteActions[ACTION_VOLUME_UP]);
    cfg.writeEntry("VolumeDown_R", kinoPrefs.remoteActions[ACTION_VOLUME_DOWN]);
    cfg.writeEntry("Mute_R", kinoPrefs.remoteActions[ACTION_MUTE]);
    cfg.writeEntry("Forward10_R", kinoPrefs.remoteActions[ACTION_SEEK_F10]);
    cfg.writeEntry("Backward10_R", kinoPrefs.remoteActions[ACTION_SEEK_B10]);
    cfg.writeEntry("Forward60_R", kinoPrefs.remoteActions[ACTION_SEEK_F60]);
    cfg.writeEntry("Backward60_R", kinoPrefs.remoteActions[ACTION_SEEK_B60]);
    cfg.writeEntry("Forward600_R", kinoPrefs.remoteActions[ACTION_SEEK_F600]);
    cfg.writeEntry("Backward600_R", kinoPrefs.remoteActions[ACTION_SEEK_B600]);
    cfg.writeEntry("Next_R", kinoPrefs.remoteActions[ACTION_NEXT]);
    cfg.writeEntry("Prev_R", kinoPrefs.remoteActions[ACTION_PREV]);
    cfg.writeEntry("OSD_R", kinoPrefs.remoteActions[ACTION_OSD]);
    cfg.writeEntry("Subtitles_R", kinoPrefs.remoteActions[ACTION_SUBTITLES]);
    cfg.writeEntry("AddToPlaylist_R", kinoPrefs.remoteActions[ACTION_ADD_TO_PLAYLIST]);
    cfg.writeEntry("RemoveFromPlaylist_R", kinoPrefs.remoteActions[ACTION_REMOVE_FROM_PLAYLIST]);
    cfg.writeEntry("PlaylistUp_R", kinoPrefs.remoteActions[ACTION_PLAYLIST_UP]);
    cfg.writeEntry("PlaylistDown_R", kinoPrefs.remoteActions[ACTION_PLAYLIST_DOWN]);
    cfg.writeEntry("FileInfo_R", kinoPrefs.remoteActions[ACTION_FILE_INFO]);

    cfg.writeEntry("PlayStop_E", kinoPrefs.extrakeyActions[ACTION_PLAY_STOP]);
    cfg.writeEntry("PauseResume_E", kinoPrefs.extrakeyActions[ACTION_PAUSE_RESUME]);
    cfg.writeEntry("VolumeUp_E", kinoPrefs.extrakeyActions[ACTION_VOLUME_UP]);
    cfg.writeEntry("VolumeDown_E", kinoPrefs.extrakeyActions[ACTION_VOLUME_DOWN]);
    cfg.writeEntry("Mute_E", kinoPrefs.extrakeyActions[ACTION_MUTE]);
    cfg.writeEntry("Forward10_E", kinoPrefs.extrakeyActions[ACTION_SEEK_F10]);
    cfg.writeEntry("Backward10_E", kinoPrefs.extrakeyActions[ACTION_SEEK_B10]);
    cfg.writeEntry("Forward60_E", kinoPrefs.extrakeyActions[ACTION_SEEK_F60]);
    cfg.writeEntry("Backward60_E", kinoPrefs.extrakeyActions[ACTION_SEEK_B60]);
    cfg.writeEntry("Forward600_E", kinoPrefs.extrakeyActions[ACTION_SEEK_F600]);
    cfg.writeEntry("Backward600_E", kinoPrefs.extrakeyActions[ACTION_SEEK_B600]);
    cfg.writeEntry("Next_E", kinoPrefs.extrakeyActions[ACTION_NEXT]);
    cfg.writeEntry("Prev_E", kinoPrefs.extrakeyActions[ACTION_PREV]);
    cfg.writeEntry("OSD_E", kinoPrefs.extrakeyActions[ACTION_OSD]);
    cfg.writeEntry("Subtitles_E", kinoPrefs.extrakeyActions[ACTION_SUBTITLES]);
    cfg.writeEntry("AddToPlaylist_E", kinoPrefs.extrakeyActions[ACTION_ADD_TO_PLAYLIST]);
    cfg.writeEntry("RemoveFromPlaylist_E", kinoPrefs.extrakeyActions[ACTION_REMOVE_FROM_PLAYLIST]);
    cfg.writeEntry("PlaylistUp_E", kinoPrefs.extrakeyActions[ACTION_PLAYLIST_UP]);
    cfg.writeEntry("PlaylistDown_E", kinoPrefs.extrakeyActions[ACTION_PLAYLIST_DOWN]);
    cfg.writeEntry("FileInfo_E", kinoPrefs.extrakeyActions[ACTION_FILE_INFO]);
    
    // Encodings
    cfg.writeEntry("enc_mp3", kinoPrefs.s_enc_mp3);    
    cfg.writeEntry("enc_playlist", kinoPrefs.s_enc_playlist);    
}

void Player::slFileSelected(const QFileInfo &fileInfo)
{
  if (kinoPrefs.f_debug)
    qDebug(QString("slFileSelected \n"));
  
	if (fileInfo.extension() == "m3u" || fileInfo.extension() == "pls")
	{
		if (addPlaylist(fileInfo))
		{
		    stack->raiseWidget(contents);
		    setupButtons();
			return;
		}
	}
	
	if (addFile(fileInfo))
	{
	  	    stack->raiseWidget(contents);
	  	    setupButtons();
	}
}

void Player::slKeyPressed(QKeyEvent* event, bool& accepted)
{
	slKeyPressEvent(event);
}

void Player::slKeyPressEvent(QKeyEvent *event)
{
    if (kinoPrefs.f_debug)
    qDebug(QString("slKeyPressEvent(): 0x") + QString::number(event->key(), 16) + " "+ QString::number(event->ascii()) + (" \"") + event->text() + "\"");

}

void Player::processExited(OProcess* /* proc */)
{
	if (kinoPrefs.f_debug)
	    qDebug("processExited()...");

	isSlf = false;
	wait->hide();
	releaseKeyboard();    
	toggleSuspend(true);
	isIgnoreOutput = false;

	// CPU restore
	if (kinoPrefs.f_cpu && !isIdentify && !isAddToPlaylist)
	{
		if (freq != kinoPrefs.s_cpu)
			set_freq(freq);
	}
    
	if (kinoPrefs.f_lcd_off)
		lcdOn();
    
    if (isIdentify) 
    {
		QStringList listUtf8 = QStringList::split("\n", bufferUtf8);
		QStringList::Iterator it = listUtf8.begin();
		
		QStringList listLocal = QStringList::split("\n", bufferLocal);
		QStringList::Iterator itLocal = listLocal.begin();
	
		for (; it != listUtf8.end(); ++it, ++itLocal) 
	    {
			QString str = (*it).stripWhiteSpace();
			QString strLocal = (*itLocal).stripWhiteSpace();
			
			if (!str.startsWith("A:"))	// this somehow crashes the app
				if (kinoPrefs.f_debug)			
					qDebug(str.utf8());
				
			if (str.startsWith("Playing"))		// next file
			{
				if (kinoPrefs.f_debug)
					qDebug(str + " selected1.");	
				QString file = str.mid(7).stripWhiteSpace();
				if (file[file.length() - 1] == '.')
					file.truncate(file.length() - 1);
					
				if (kinoPrefs.f_debug)
					qDebug(file + " selected.");	
					
				setSelectedFile(file);	// not yet added to playlist
				continue;
			}
			
			// here we should have all media info populated
			if (str.startsWith("Starting playback..."))
			{
				QListViewItem* item = contents->playlist->firstChild();
				bool found = false;
				while (item)
				{
					if (selectedFile == item->text(0))
					{
						// select new file in playliat
						contents->playlist->setCurrentItem(item);
						found = true;
						break;
					}
					
					item = item->itemBelow();
				}
				
				if (!found)
				{
					contents->playlist->addToPlaylist(selectedFile, minfo[selectedFile]);
					if (kinoPrefs.f_debug)
						qDebug(selectedFile + " added.");	
					
					setupButtons();
				}
				
				continue;
			}

			// try to parse media info by default
			parseMediaInfo(selectedFile, str, strLocal);
		}
		
		isIdentify = false;
	}
	        
	if (isAddToPlaylist)	
		isAddToPlaylist = false;
		
	setupButtons();	
    
	stop();
	
//	contents->screen->setBackgroundColor(Qt::black);
	
//	if (splash != 0)
//		contents->screen->setPixmap(*splash);
	
	isPlaying = false;
	isPausing = false;	
	
	// need to play file immidiately when invoked with setDocument()
	if (isAutoplay)
	{
		isAutoplay = false;
		playClicked();
	}
}

void Player::displayFileInfo()
{
	if (selectedFile == "")
		return;
	
	MediaInfoBase mdf(this, tr("File info"), TRUE, 0);
	QFileInfo fs(selectedFile);
	mdf.setCaption(tr("File info") + " - " + fs.fileName());
	mdf.title_label->setText(minfo[selectedFile].Title);
	mdf.album_label->setText(minfo[selectedFile].Album);
	mdf.artist_label->setText(minfo[selectedFile].Artist);
	mdf.year_label->setText(minfo[selectedFile].Year);
	mdf.comment_label->setText(minfo[selectedFile].Comment);
	
	QString s_length = length(minfo[selectedFile].LENGTH);
	mdf.length_label->setText(s_length);
	
	QString size = QString::number(minfo[selectedFile].VIDEO_WIDTH) + "x" + QString::number(minfo[selectedFile].VIDEO_HEIGHT);
	mdf.size_label->setText(size);
	mdf.vbitrate_label->setText(QString::number(minfo[selectedFile].VIDEO_BITRATE));
	mdf.vformat_label->setText(minfo[selectedFile].VIDEO_FORMAT);
	mdf.fps_label->setText(QString::number(minfo[selectedFile].VIDEO_FPS));

	mdf.achans_label->setText(QString::number(minfo[selectedFile].AUDIO_NCH));
	mdf.acodec_label->setText(minfo[selectedFile].AUDIO_CODEC);
	mdf.arate_label->setText(QString::number(minfo[selectedFile].AUDIO_RATE));
	mdf.abitrate_label->setText(QString::number(minfo[selectedFile].AUDIO_BITRATE));
	
	mdf.exec();
}

void Player::parseMediaInfo(const QString& file, const QString& strUtf8, const QString& strLocal)
{
	if (strLocal.startsWith("Title:")) {
	    minfo[file].Title = strLocal.mid(6);
	} else if (strUtf8.startsWith("OggVorbisComment: title=")) {
	    minfo[file].Title = strUtf8.mid(24);
	} else if (strLocal.startsWith("name:")) {
	    minfo[file].Title = strLocal.mid(5);
	} else if (strLocal.startsWith("Artist:")) {
	    minfo[file].Artist = strLocal.mid(7);
	} else if (strUtf8.startsWith("OggVorbisComment: artist=")) {
	    minfo[file].Artist = strUtf8.mid(25);
	} else if (strLocal.startsWith("author:")) {
	    minfo[file].Artist = strLocal.mid(7);
	} else if (strLocal.startsWith("Album:")) {
	    minfo[file].Album = strLocal.mid(6);
	} else if (strUtf8.startsWith("OggVorbisComment: album=")) {
	    minfo[file].Album = strUtf8.mid(24);
    } else if (strLocal.startsWith("Year:")) {
	    minfo[file].Year = strLocal.mid(5);
    } else if (strUtf8.startsWith("OggVorbisComment: date=")) {
	    minfo[file].Year = strUtf8.mid(23);
	} else if (strLocal.startsWith("Comment:")) {
	    minfo[file].Comment = strLocal.mid(8);
	} else if (strLocal.startsWith("comments:")) {
	    minfo[file].Comment = strLocal.mid(8);
	} else if (strUtf8.startsWith("OggVorbisComment: DESCRIPTION=")) {
	    minfo[file].Comment = strUtf8.mid(30);
	} else if (strLocal.startsWith("Track:")) {
	    minfo[file].Track = strLocal.mid(6);
	} else if (strUtf8.startsWith("OggVorbisComment: tracknumber=")) {
	    minfo[file].Track = strUtf8.mid(31);
	} else if (strLocal.startsWith("Genre:")) {
	    minfo[file].Genre = strLocal.mid(6);
	} else if (strUtf8.startsWith("ID_FILENAME=")) {
	    minfo[file].FILENAME = strUtf8.mid(12);
	} else if (strUtf8.startsWith("ID_AUDIO_CODEC=")) {
	    minfo[file].AUDIO_CODEC = strUtf8.mid(15);
	} else if (strUtf8.startsWith( "ID_AUDIO_FORMAT=")) {
	    minfo[file].AUDIO_FORMAT = strUtf8.mid(16).toInt();
	} else if (strUtf8.startsWith( "ID_AUDIO_BITRATE=")) {
	    minfo[file].AUDIO_BITRATE = strUtf8.mid(17).toInt();
	} else if (strUtf8.startsWith( "ID_AUDIO_RATE=")) {
	    minfo[file].AUDIO_RATE = strUtf8.mid(14).toInt();
	} else if (strUtf8.startsWith( "ID_AUDIO_NCH=")) {
	    minfo[file].AUDIO_NCH = strUtf8.mid(13).toInt();
	} else if (strUtf8.startsWith( "ID_LENGTH=")) {
	    minfo[file].LENGTH = strUtf8.mid(10).toInt();
	    //	    if (minfo[file].FILENAME.contains(".mp3"))
	    //	    	minfo[file].LENGTH /= 6;					// seems to be a bug in mplayer...
	} else if (strUtf8.startsWith( "ID_VIDEO_FORMAT=")) {
	    minfo[file].VIDEO_FORMAT = strUtf8.mid(16);
	} else if (strUtf8.startsWith( "ID_VIDEO_BITRATE=")) {
	    minfo[file].VIDEO_BITRATE = strUtf8.mid(17).toInt();
	} else if (strUtf8.startsWith( "ID_VIDEO_WIDTH=")) {
	    minfo[file].VIDEO_WIDTH = strUtf8.mid(15).toInt();
	} else if (strUtf8.startsWith( "ID_VIDEO_HEIGHT=")) {
	    minfo[file].VIDEO_HEIGHT = strUtf8.mid(16).toInt();
	} else if (strUtf8.startsWith( "ID_VIDEO_FPS=")) {
	    minfo[file].VIDEO_FPS = strUtf8.mid(13).toFloat();
	} else if (strUtf8.startsWith( "ID_VIDEO_ASPECT=")) {
	    minfo[file].VIDEO_ASPECT = strUtf8.mid(16).toInt();
	}
	
	//qDebug("parseMediaInfo(): " + strUtf8.utf8());
}
    
    
void Player::sliderMoved(int value)
{
	// disable it, it doesn'y work peoperly anyway...
	// seek(value, 2);
}

void Player::receivedStdout(OProcess* /* proc */, char* buffer, int buflen)
{
	// have to use C functions here because buffer crashes QString sometimes... 
	char b[buflen + 1];
	strncpy(b, buffer, buflen);
	if (isIgnoreOutput && strstr(b, "Playing") == 0)	// next file
		return;
	
	isIgnoreOutput = false;
	
	// split buffer in case we recieve several lines
	QString sUtf8 = QString::fromUtf8(buffer, buflen);
	QString sLocal = QString::fromLocal8Bit(buffer, buflen);
	QTextCodec* codec = QTextCodec::codecForName(kinoPrefs.s_enc_mp3);
	if (codec != 0)
		sLocal = codec->toUnicode(buffer, buflen);
	
	// handled when process finishes
	if (isIdentify)
	{
	  qDebug(sUtf8);
		bufferUtf8 += sUtf8;
		bufferLocal += sLocal;
		return;
	}

	QStringList listUtf8 = QStringList::split("\n", sUtf8);
	QStringList::Iterator it = listUtf8.begin();
	
	QStringList listLocal = QStringList::split("\n", sLocal);
	QStringList::Iterator itLocal = listLocal.begin();
	
	for (; it != listUtf8.end(); ++it, ++itLocal) 
    {
		QString str = (*it).stripWhiteSpace();
		QString strLocal = (*itLocal).stripWhiteSpace();
		
		if (!str.startsWith("A:"))	// this somehow crashes the app
			if (kinoPrefs.f_debug)
				qDebug(str.utf8());
			
		if (str.startsWith("Playing"))		// next file
		{
		  
		  
			QString file = str.mid(7).stripWhiteSpace();
			if (file[file.length() - 1] == '.')
				file.truncate(file.length() - 1);
				
			setSelectedFile(file);	// not yet added to playlist
			continue;
		}
		
		int track = 0;
		
		// here we should have all media info populated
		if (str.startsWith("Starting playback..."))
		{
			wait->hide();
			
			QListViewItem* item = contents->playlist->firstChild();
//			bool found = false;
			while (item)
			{
				track++;
				if (selectedFile == item->text(0))
				{
					// select new file in playliat
					contents->playlist->setCurrentItem(item);
//					found = true;
					break;
				}
				
				item = item->itemBelow();
			}
			
			DocLnk doc(selectedFile);
			isVideoFile = doc.type().startsWith("video/") || minfo[selectedFile].VIDEO_FORMAT != "";
			
			// ignore all mlayer output for video files...
			isIgnoreOutput = isVideoFile && !isIdentify;
				
			// CPU change
			if (kinoPrefs.f_cpu)
			{
				QString new_freq = isVideoFile ? kinoPrefs.s_v_cpu : kinoPrefs.s_a_cpu;
				set_freq(new_freq);
			}
				
			if (kinoPrefs.f_lcd_off && !isVideoFile)
				lcdOff();
			else
				lcdOn();
					
			// setup progres sindicator
			int length = minfo[selectedFile].LENGTH;
			
			if (kinoPrefs.f_debug)
				qDebug("Length: " + QString::number(length));
				
			contents->progress->setRange(0, length);
			contents->progress->setLineStep(1); 
			contents->progress->setPageStep(1); 
			contents->progress->setTickInterval(1); 
				
			QString mode = tr("Normal");
			if (kinoPrefs.f_repeat)
			    mode = tr("Repeat");
			else if (kinoPrefs.f_random)
			    mode = tr("Random");
				
			// set text
			QString text =
				tr("Artist: ") + minfo[selectedFile].Artist + "\n" +
				tr("Album: ") + minfo[selectedFile].Album + "\n" +
				tr("Title: ") + minfo[selectedFile].Title + "\n" +
				tr("Track: ") + QString::number(track) + "/" + QString::number(contents->playlist->childCount()) + "\n" +
				tr("Mode: ") + mode + "\n";
				
			contents->screen->setFrameStyle(QFrame::Box | QFrame::Sunken);
			contents->screen->setFont(QFont("helvetica", 24, QFont::Bold));
			contents->screen->setBackgroundColor(Qt::white);
			contents->screen->setText(text);
			
			continue;
		}
			
		if (str.startsWith("A:") && isPlaying && !isVideoFile)
		{
//			qDebug("Updating position...");
			
//			012345678901234567890
//			A:      1:2:30.4  9.1%		
//          0       1       2	

			QStringList list = QStringList::split(" ", str.simplifyWhiteSpace());
			QString s_time = list[1].stripWhiteSpace();
//			QString s_percent = list[2].stripWhiteSpace();
			
			list = QStringList::split(":", s_time);
			int hours = 0, minutes = 0, seconds = 0;
			
			if (list.count() == 3)
			{
				hours = list[0].toInt();
				minutes = list[1].toInt();
				seconds = (int)list[2].toFloat();
//				seconds = list[2].toInt();
			}
			else if (list.count() == 2)
			{
				minutes = list[0].toInt();
				seconds = (int)list[1].toFloat();
//				seconds = list[1].toInt();
			}
			else if (list.count() == 1)
				seconds = (int)list[0].toFloat();
//				seconds = list[0].toInt();
			
			//qDebug(s_hours + ":" + s_minutes + ":" + s_seconds);
			
			currentPosition = hours * 60 * 60 + minutes * 60 + seconds;
			contents->time->setText(length(currentPosition) + "/" + length(minfo[selectedFile].LENGTH));
			contents->progress->setValue(currentPosition);
		}
		
    }
}

void Player::receivedStderr(OProcess* /* proc */, char *buffer, int buflen)
{
	QString str = QString::fromUtf8(buffer, buflen);
	if (kinoPrefs.f_debug)
	    qDebug(str.utf8());
}

void Player::wroteStdin(OProcess* /* proc */)
{
	if (kinoPrefs.f_debug)    
    	qDebug("wroteStdin()...");
}

void Player::identifyFile(const QString& file)
{
	identifyFile(QStringList(file));
}

void Player::identifyFile(const QStringList& files)
{
	if (files.count() == 0)
		return;
	
	QStringList args;
	args << MPLAYER;
	args << "-identify";
	args << "-v";		// verbose, to get OGG properties

	if (kinoPrefs.f_w100overlay)
	  args << "-vo" << "w100";
	else if (kinoPrefs.f_bvddoverlay)
	  args << "-vo" << "bvdd";
	else
	  args << "-vo" << "fbdev";

	// this option is to workaround a stupid problem with mplayer 1.x versions,
	// which would play the file after identifying...
	args << "-frames";
	args << "0";

    isIdentify = true;
	isIgnoreOutput = false;

	process->clearArguments();
	*process << args;
	
	QStringList::ConstIterator it = files.begin();
	for (; it != files.end(); ++it) 
		*process << (*it).utf8();
	
	bufferUtf8 = "";
	bufferLocal = "";
	
	wait->show();
	
	process->start(OProcess::NotifyOnExit, OProcess::All);
}

void Player::showPlaylist(bool visible)
{
	if (visible)
	{
		contents->playlist->show();
		contents->screen->hide();
	}
	else
	{
		contents->playlist->hide();
		contents->screen->show();
	}
	
	m_viewMenu->setItemChecked(VIEW_PLAYLIST, visible);
	setupButtons();	
}


void Player::showSlider(bool visible)
{
	if (visible)
	{
		contents->progress->show();
		contents->time->show();
//		contents->sliderLayout->show();
	}
	else
	{
		contents->progress->hide();
		contents->time->hide();
//		contents->sliderLayout->hide();
	}
	
	m_viewMenu->setItemChecked(VIEW_SLIDER, visible);
}

void Player::playClicked()
{
	isIdentify = false;
	
	if (isPlaying)
	{
		if (isPausing)
		{
	    	resume();
	//		isPausing = false;
	//		sendCommand("pause\n");
	//		contents->play_button->setPixmap(Resource::loadPixmap("kino2/player_pause"));
			return;
		}
		else
		{
	    	pause();
	//		isPausing = true;
	//		sendCommand("pause\n");
	//		contents->play_button->setPixmap(Resource::loadPixmap("kino2/player_play"));
			return;
		}
	}
    else if (selectedFile != "") 
    {
		QStringList args;
		QString buf_geom;
		QString vop_args;
		QString s_cache;
		QString s_band;

		isIgnoreOutput = false;
	
	//	SlMisc::enableAutoPowerOff(false, false, false);
	
		args << MPLAYER;
		args << "-slave";
		args << "-nortc";
		//args << "-v";		// verbose
		//args << "-really-quiet";
		
		if (kinoPrefs.f_noaspect)
			args << "-noaspect";
		
		if (kinoPrefs.f_repeat)
		    args << "-loop" << "0";
		else if (kinoPrefs.f_random)
		    args << "-shuffle";
		
		if (kinoPrefs.s_priority > 0) 
		{
		    args << "-rtprio";
		    QString s_priority = QString::number(kinoPrefs.s_priority);
		    args << s_priority;
		}
		
		if (kinoPrefs.f_index)
		    args << "-idx";
	
		if (kinoPrefs.f_w100overlay)
		  args << "-vo" << "w100";
		else if (kinoPrefs.f_bvddoverlay)
		  args << "-vo" << "bvdd";
		else
		  args << "-vo" << "fbdev";
		  

		if (kinoPrefs.f_doublebuffer)
		    args << "-double";
	
		if (useScale)
		    args << "-fs";
	
		if (kinoPrefs.f_directrendering)
		    args << "-dr";
		    
		if (kinoPrefs.f_dropframes)
		    args << "-framedrop";

		if (kinoPrefs.f_cache)
		{
			if (kinoPrefs.s_cache > 0) 
			{
			    args << "-cache";
			    s_cache = QString::number(kinoPrefs.s_cache);
			    args << s_cache;
			}
		}
		else
			args << "-nocache";
	
		if (kinoPrefs.s_bandwidth > 0) 
		{
		    args << "-bandwidth";
		    s_band = QString::number(kinoPrefs.s_bandwidth);
		    args << s_band;
		}

		if (kinoPrefs.f_resample)
			args << "-af" << "resample=44100:0:0";
				
//		isIdentify = true;
//		args << "-identify";
	
		// add items from current item
		QListViewItem* item = contents->playlist->currentItem();
		while(item)
		{
			QString file = item->text(0);
			addPlayitem(args, file);
			item = item->itemBelow();
		}
		
		// add items before current item
		item = contents->playlist->firstChild();
		while(item != contents->playlist->currentItem())
		{
			QString file = item->text(0);
			addPlayitem(args, file);
			item = item->itemBelow();
		}
		
		QString s;	
		process->clearArguments();
		for (QStringList::Iterator it = args.begin(); it != args.end(); it++)
		{
			s.append(*it).append(" ");
			*process << (*it).utf8();
		
		}
		
		if (kinoPrefs.f_debug)
			qDebug(QString("Starting mplayer with options: ") + s);
		
		if (kinoPrefs.f_external_mem)
			process->setEnvironment("MPLAYER_W100_USEEXTVRAM", "1");
		
		toggleSuspend(false);
		grabKeyboard();
		
		process->start(OProcess::NotifyOnExit, OProcess::All);
		
		// skip to the currently selected item
//		if (pos > 0)
//		{
////			sendCommand("pause\n");
//			sendCommand(QString("pt_step +") + QString::number(pos) + "\n");
////			sendCommand("pause\n");
//		}
		
		isManualStop = false;
		isPlaying = true;
		isPausing = false;
		
		contents->play_button->setPixmap(Resource::loadPixmap("kino2/player_pause"));
		contents->stop_button->setEnabled(true);
    }
}

void Player::addPlayitem(QStringList& args, QString file)
{
	args << file;
	
	DocLnk doc(selectedFile);
	isVideoFile = doc.type().startsWith("video/") || minfo[selectedFile].VIDEO_FORMAT != "";
	
	if (isVideoFile)
	{
		if (kinoPrefs.f_rotate && !kinoPrefs.f_smart_crop)
		    args << "-vop" << "rotate=1";
			
		if (kinoPrefs.f_smart_crop)
		{
			int widths[] = {160, 320, 640};
			int heights[] = {120, 240, 480};
			
			int width = minfo[selectedFile].VIDEO_WIDTH;
			int height = minfo[selectedFile].VIDEO_HEIGHT;
			
			QString s_width = "", s_height = "";
			
			if (width > 0 && height > 0)
			{
				for (int i = 2; i >= 0; i--)
				{
					if (width > widths[i])
					{
						s_width = QString::number(widths[i]);
						break;
					}
				}
				
				for (int i = 2; i >= 0; i--)
				{
					if (height > heights[i])
					{
						s_height = QString::number(heights[i]);
						break;
					}
				}
				
				if (s_width != "" && s_height != "")
				{
					args << "-vop";
					
					if (kinoPrefs.f_rotate)
						args << "crop=" + s_height + ":" + s_width + ",rotate=1";
					else
						args << "crop=" + s_width + ":" + s_height;
				}
//					args << "-vop" << QString(kinoPrefs.f_rotate ? "rotate=1," : "") + "crop=" + s_width + ":" + s_height;
			}
		}
		
		 
	}
	
	// add user-defined options to each file
	if (kinoPrefs.s_mplayeroptions != "")
	{
		QStringList list = QStringList::split(' ', kinoPrefs.s_mplayeroptions);
		QStringList::Iterator it;
		for(it = list.begin(); it != list.end(); args << *it, it++);
	}
}

void Player::toggleSuspend(bool enable)
{
    QCopEnvelope e("QPE/System", "setScreenSaverIntervals(int,int,int)" );
    if (enable)
    {
    	if (kinoPrefs.f_debug)
		    qDebug("Enabling suspend with %d %d %d\n", intervalDim, intervalLightOff, intervalSuspend);
		    
	    e << intervalDim << intervalLightOff << intervalSuspend;
    } 
	else 
	{
		if (kinoPrefs.f_debug)
	    	qDebug("Disabling suspend\n");
	    	
	    e << 0 << 0 << 0;
    }
}
									
void Player::stopClicked()
{
	stop();
}

void Player::startClicked()
{
    if (isPlaying) 
    {
		if (isPausing) 
		{
			resume();
//		    isPausing = false;
//		    sendCommand("pause\n");
//		    contents->play_button->setPixmap(Resource::loadPixmap("kino2/player_pause"));
		}
		sendCommand("pt_step -1\n");
    }
}

void Player::endClicked()
{
    if (isPlaying) 
    {
		if (isPausing) 
		{
			resume();
//		    isPausing = false;
//		    sendCommand("pause\n");
//		    contents->play_button->setPixmap(Resource::loadPixmap("kino2/player_pause"));
		}
		sendCommand("pt_step +1\n");
    }
}

void Player::pause()
{
	sendCommand("pause\n");
	isPausing = true;
	contents->play_button->setPixmap(Resource::loadPixmap("kino2/player_play"));
}

void Player::resume()
{
    sendCommand("pause\n");
    isPausing = false;
    contents->play_button->setPixmap(Resource::loadPixmap("kino2/player_pause"));
}

void Player::stop()
{
    if (isPausing)
    { 
    	sendCommand("pause\n");
    	isPausing = false;
    	
		QTimer* t = new QTimer(this);
		connect(t, SIGNAL(timeout()), this, SLOT(stopClicked()));
		t->start(100, true);
		return;
    }
    
    if (isPlaying) 
    {
	   	sendCommand("quit\n");
		isPlaying = false;
		contents->play_button->setPixmap(Resource::loadPixmap("kino2/player_play"));
		contents->stop_button->setEnabled(false);
    }
}

void Player::seek(int value, int type /* = 0 */)
{
	QString command;
	
    if (isPlaying) 
    {
		if (isPausing) 
		{
			resume();
//		    isPausing = false;
//		    sendCommand("pause\n");
//		    contents->play_button->setPixmap(Resource::loadPixmap("kino2/player_pause"));
		}
		
		if (kinoPrefs.f_debug)
			qDebug("seek(): value=" + QString::number(value) + ", type=" + QString::number(type));
		
		int length = minfo[selectedFile].LENGTH;
		if (type == 2)	// absolute
		{
			if (length > 0 && value > length)
				value = length;
				
			// calculate relative position
			if (currentPosition > 0)	
				value = value - currentPosition;
		}

		sendCommand(command.sprintf("seek %d\n", value));
//		sendCommand(command.sprintf("seek %d type=%d\n", value, type));
    }
}

void Player::volumeUp()
{
	readSystemVolume();
	setVolume(volumePercent + 5);
}

void Player::volumeDown()
{
	readSystemVolume();
	setVolume(volumePercent - 5);
}

void Player::setVolume(int percent)
{
    // clamp volume percent to be between 0 and 100
    volumePercent = (percent < 0) ? 0 : ((percent > 100) ? 100 : percent);
    writeSystemVolume();
}

void Player::volumeChanged(bool nowMuted)
{
	if (kinoPrefs.f_debug)
		qDebug("volumeChanged()");
	
    if (!nowMuted)
        readSystemVolume();

    // Handle case where muting it toggled
    if (muted != nowMuted) 
    {
		muted = nowMuted;
		return;
    }
}

void Player::mute(bool toggled)
{
    muted = toggled;
    writeSystemVolume();
}

void Player::batteryReceived(const QCString& msg, const QByteArray& data)
{
  QDataStream stream(data, IO_ReadOnly);

  if(msg == "freqMenu(QString)"){
    QString name;
    stream >> name;

    if( name == QString("MenuList") ){
      kinoPrefs.l_freq.clear();
    }else{
      kinoPrefs.l_freq << name;
    }
    
    if (kinoPrefs.f_debug)
      qDebug("freqListAdd: value=" + name);

  }else  if(msg == "currentConf(QString)"){
    QString name;
    stream >> name;
    
    kinoPrefs.s_cpu = name;
    if(freq == "")
      freq = kinoPrefs.s_cpu;
    
    if (kinoPrefs.f_debug)
      qDebug("currentFreq: value=" + name);

  }


}

void Player::set_freq(QString freq)
{
  if (kinoPrefs.s_cpu != freq){
    
    if ( QCopChannel::isRegistered("QPE/BatteryPlus") ){
      QCopEnvelope e("QPE/BatteryPlus", "change(QString)" );
      e << freq;
    }
    kinoPrefs.s_cpu = freq;
  }
  return;
}

int set_volume(int value)
{
	int new_vol;

	if (value > 100) value = 100;
	if (value < 0)   value = 0;
  
	new_vol = value | (value << 8);
	
	int mixerfd = ::open("/dev/mixer", O_RDWR);
	if (mixerfd < 0)
	{
		qDebug("Unable to open mixer device.");
		return -1;
	}
	
	int devmask;
	if(::ioctl(mixerfd, SOUND_MIXER_READ_DEVMASK, &devmask) == -1)
	{
		qDebug("Unable to open mixer device.");
		::close(mixerfd);
		return -1;
	}
	
	if (::ioctl(mixerfd, SOUND_MIXER_WRITE_VOLUME, &new_vol) == -1)
    	qDebug("Unable to set volume.");

	::close(mixerfd);
	return value;
}

int get_volume(void)
{
  	int orig_vol;

	int mixerfd = ::open("/dev/mixer", O_RDWR);
	if (mixerfd < 0)
	{
		qDebug("Unable to open mixer device.");
		return -1;
	}
	
	int devmask;
	if(::ioctl(mixerfd, SOUND_MIXER_READ_DEVMASK, &devmask) == -1)
	{
		qDebug("Unable to open mixer device.");
		::close(mixerfd);
		return -1;
	}
	
	if (::ioctl(mixerfd, SOUND_MIXER_READ_VOLUME, &orig_vol) == -1)
	{    
		qDebug("Unable to read volume.");
		::close(mixerfd);
		return -1;
	}    
    
    ::close(mixerfd);
   	return ( (orig_vol & 0xff) + ((orig_vol >> 8) & 0xff) ) / 2;
}

void Player::readSystemVolume()
{
    Config cfg("qpe");
    cfg.setGroup("Volume");
    
    muted = cfg.readBoolEntry("VolumeMute");
    if (muted)
	    volumePercent = cfg.readNumEntry("VolumeRightPercent");
	else    
    	volumePercent = get_volume();
}

void Player::writeSystemVolume()
{
	Config cfg("qpe");
	cfg.setGroup("Volume");
	cfg.writeEntry("VolumePercent", volumePercent);
	cfg.writeEntry("VolumeRightPercent", volumePercent);
    
    if (kinoPrefs.f_debug)
	    qDebug(QString("Setting volume: ") + QString::number(volumePercent) + ", muted: " + QString::number((int)muted));
    
    set_volume(muted ? 0 : volumePercent);
	    
	QCopEnvelope( "QPE/System", "volumeChange(bool)" ) << muted;
}


void Player::revClicked()
{
	seek(-10);
}

void Player::fwdClicked()
{
	seek(10);
}

void Player::ejectClicked()
{
    if (isPlaying) 
    {
		if (isPausing) 
		{
			resume();
//		    isPausing = false;
//		    sendCommand("pause\n");
//		    contents->play_button->setPixmap(Resource::loadPixmap("kino2/player_pause"));
		}
		sendCommand("quit\n");
    }
    
    stack->raiseWidget(slf);
    isSlf = true;
    setupButtons();
}

int Player::lookupActionForKey(int key)
{
#define	K(action) (kinoPrefs.keyboardActions[action])
#define R(action) (kinoPrefs.remoteActions[action])
#define E(action) (kinoPrefs.extrakeyActions[action])

	// cancel key always stops
	if (key == Key_Escape)
	{
		if (isLCDBlank)
			return ACTION_NONE;
		else
			return ACTION_PLAY_STOP;
	}
		
	// to avoid changing volume change
	if ((key == Key_Up || key == Key_Down) && (contents->playlist->isVisible() || stack->visibleWidget() == slf) && !isPlaying)
		return ACTION_NONE;
		
	for (int action = ACTION_NONE; action <= ACTION_FILE_INFO; action++)
	{
		if (R(action) == key || K(action) == key || (E(action) == key && kinoPrefs.f_extrakey))
			return action;
	}
	
	return ACTION_NONE;
}

void Player::keyPressed(QKeyEvent* event, bool& accepted)
{
  	keyPressEvent(event);
}

void Player::keyPressEvent(QKeyEvent *event)
{
        if( isSlf == true)
	        return;

	if (kinoPrefs.f_debug)
		qDebug(QString("keyPressEvent(): 0x") + QString::number(event->key(), 16) + " "+ QString::number(event->ascii()) + (" \"") + event->text() + "\"");
	
	if (isPlaying && !isVideoFile)	// we don't keep current position for video file
	{
		if (event->key() >= Key_0 && event->key() <= Key_9)
		{
			int value = (event->key() - Key_0) * 10;
			
			// calclate percent manualy because mplayer seems to be broken?
			int length = minfo[selectedFile].LENGTH;
			if (length > 0)
			{
				value = (value * length) / 100;
				seek(value, 2);		// seek absolute
			}
			return;
		}
	}

	if (event->key() > 0)
	{
	    switch (lookupActionForKey(event->key())) 
	    {
	//    	case Key_Enter:
	//    	case Key_Return:
	//    		if (contents->playlist->isVisible())
	//    			clicked(contents->playlist->currentItem());
	//    		return;
	    	
	//		case Key_Space:
	//		case Key_P:
	//		case 0x201c:			// Play/Pause
			case ACTION_PAUSE_RESUME:
				playClicked();
			    return;
			    
	//		case Key_Right:
			case ACTION_SEEK_F10:
				fwdClicked();
			    return;
			    
	//		case Key_Left:
			case ACTION_SEEK_B10:
				revClicked();
			    return;
	
	//		case Key_0:
	//			seek(0, 1);		// begining or end ?
	//		    return;
			    
	//		case Key_X:
			case ACTION_SEEK_F60:
				seek(60);
			    return;
	//		case Key_C:
			case ACTION_SEEK_B60:
				seek(-60);
			    return;
			    
	//		case Key_Z:
			case ACTION_SEEK_F600:
				seek(600);
			    return;
	//		case Key_V:
			case ACTION_SEEK_B600:
				seek(-600);
			    return;
			    
	//		case Key_Up:
	//		case 0x201f:			// Backward
			case ACTION_NEXT:
				endClicked();
			    return;
	//		case Key_Down:
	//		case 0x201e:			// Forward
			case ACTION_PREV:
				startClicked();
			    return;
	
			// volume up/down, mute
			case ACTION_VOLUME_UP:
				volumeUp();
				return;
	
			case ACTION_VOLUME_DOWN:
				volumeDown();
				return;

			case ACTION_MUTE:
				mute(!muted);
				return;
			    
	//		case Key_Escape:
	//		case 0x201d:				// Stop
	//		case Key_Return:
	//		case Key_Enter:
	//		case Key_Q:
			case ACTION_PLAY_STOP:
//				if (isPlaying)
			    stop();
			    return;	
			    
	//		case Key_O:
			case ACTION_OSD:
			    sendCommand("osd\n");
			    return;
			    
	//		case Key_S:
			case ACTION_SUBTITLES:
			    sendCommand("sub_visibility\n");
			    return;

			case ACTION_ADD_TO_PLAYLIST:
			    addToPlaylist();
			    return;

			case ACTION_REMOVE_FROM_PLAYLIST:
			    removeFromPlaylist();
			    return;

			case ACTION_PLAYLIST_UP:
			    contents->playlist->up();
			    return;

			case ACTION_PLAYLIST_DOWN:
			    contents->playlist->down();
			    return;

			case ACTION_FILE_INFO:
			    displayFileInfo();
			    return;
	    }
	}
	    
    // default processing 
    event->ignore();
}

void Player::goodBye()
{
	releaseKeyboard();
    close();
}

void Player::fileMenu(int item)
{
	switch (item)
	{
		case FILE_OPEN:
		{
			if (isPlaying)
			    sendCommand("quit\n");
			    
			stack->raiseWidget(slf);
			isSlf = true;
			setupButtons();
			return;
		}
	    case FILE_OPEN_URL:
	    {
			if (isPlaying)
			    sendCommand("quit\n");
			    
			InputDialog* urlDlg = new InputDialog(this, tr("Open URL..."),TRUE, 0);
			
			urlDlg->setHistory(kinoPrefs.s_url_history);
			urlDlg->exec();
			if( urlDlg->result() == 1 ) 
			{
			    setSelectedFile(urlDlg->getInputText());
			    
			    QString url_history = urlDlg->getHistory();
			    if (!url_history.contains(selectedFile))
			    	url_history = selectedFile + "," + url_history;
			    
				kinoPrefs.s_url_history = url_history;
			    saveSettings();

			    qDebug(selectedFile+"URLsel\n");
			    //contents->playlist->addToPlaylist(selectedFile);
			    addUrl(selectedFile);
			}
			
			delete urlDlg;
			return;
	    } 
	    case FILE_SAVE_PLAYLIST:
	    {
			if (isPlaying)
			    sendCommand("quit\n");
			
			FileDialog saveAs(FileDialog::MODE_SAVE, "*.m3u", this); 
			saveAs.setDefaultName("playlist");
			saveAs.setComplementExt("m3u");
			saveAs.setFixedSize(this->size());
			
//			saveAs.show();
			if (saveAs.exec())
			{
				QString file = saveAs.getFilePath();
				savePlaylist(file);
			}
			return;
	    }    
	    case FILE_INFO:
	    {
			displayFileInfo();
			return;
	    } 
	    case FILE_PREFS: 
	    {
			if (isPlaying)
			    sendCommand("quit\n");
			    
			KinoSettings *kinoset = new KinoSettings(this, tr("Preferences..."),TRUE,0);
			kinoset->setSettings(kinoPrefs);
			if (kinoset->exec() == 1) 
			{
				// save URL history
				QString url_history = kinoPrefs.s_url_history;
				
			    kinoPrefs = kinoset->getSettings(kinoPrefs);
			    kinoPrefs.s_url_history = url_history;
			    
			    saveSettings();
			    loadSettings();
	
				delete filter;		    
			    filter = new FileSelectionFilter(kinoPrefs.s_types, this);
			    slf->setFilter(filter);
			}
			return;
		}
    }
}

void Player::viewMenu(int item)
{
	switch(item)
	{
	    case VIEW_SCALE:
	    {
			m_viewMenu->setItemChecked(0, (useScale = useScale?false:true));
			return;
	    } 
	    case VIEW_LCD_OFF:
	    {
    		lcdOff();
			//m_viewMenu->setItemChecked(1, (useFullscreen = useFullscreen?false:true));
			return;
	    } 
	    case VIEW_PLAYLIST:
	    {
			showPlaylist(!m_viewMenu->isItemChecked(VIEW_PLAYLIST)); 
			return;
	    } 
	    case VIEW_SLIDER:
	    {
			showSlider(!m_viewMenu->isItemChecked(VIEW_SLIDER)); 
			return;
	    }
	}
}

void Player::helpMenu(int item)
{
    if (item == 0) 
    {
		QString str = tr("Kino 2 v" KINO_VERSION " (SL-C7x0)\n"
			  "Mplayer Qtopia GUI\n"
			  "(c) Cacko Team, 2003-2004\n"
			  "http://www.cacko.biz/kino2/\n");
			  
		QMessageBox::information(this, tr("Kino 2"), str);
    }
}

void Player::columnsMenu(int item)
{
	bool show = !m_columnsMenu->isItemChecked(item);
	m_columnsMenu->setItemChecked(item, show);
	
	int column = m_columnsMenu->indexOf(item) + 2;
	if (show)
	{
		contents->playlist->setColumnWidthMode(column, QListView::Maximum);
		contents->playlist->setColumnWidth(column, 100);
	}
	else
	{
		contents->playlist->setColumnWidthMode(column, QListView::Manual);
		contents->playlist->setColumnWidth(column, 0);
	}
	
	contents->playlist->triggerUpdate();
}

void Player::lcdOn()
{
#ifndef QT_NO_COP
    QCopEnvelope e("QPE/System", "setBlankLCD(int)");
    e << 0;
#endif // QT_NO_COP
	isLCDBlank = false;
}

void Player::lcdOff()
{
#ifndef QT_NO_COP
    QCopEnvelope e("QPE/System", "setBlankLCD(int)");
    e << 1;
#endif // QT_NO_COP
	isLCDBlank = true;
}

void Player::setBlankLCD(const QCString& msg, const QByteArray& data)
{
  QDataStream stream(data, IO_ReadOnly);

  if(msg == "setBlankLCD(int)"){
    int off;
    stream >> off;

    if (kinoPrefs.f_debug)
      qDebug("Recieved setBlankLCD(int): " + QString::number(off));
    
    isLCDBlank = off;
  }

}
