/****************************************************************************************
 * (c) Cacko Team,2002,2003								*
 * Kino2 video player									*
 * http://www.cacko.biz									*
 ****************************************************************************************/

#ifndef _PLAYER_H_
#define _PLAYER_H_

#include <qmenubar.h>
#include <qtoolbar.h>
#include <qmainwindow.h>
#include <qlist.h>
#include <qmap.h>
#include <qvbox.h>
#include <qwidgetstack.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <qlabel.h>
#include <qtimer.h>

#include <sl/slfileselector.h>
#include <sl/sldlgwait.h>

#include <qpe/qcopenvelope_qws.h>

#include "playerbase.h"
#include "oprocess.h"
//#include "control.h"
#include "kinosettings.h"
#include "MediaInfo.h"
#include "playlist.h"
#include "FileSelectionFilter.h"

class Player : public QMainWindow
{ 
    Q_OBJECT

public:
    Player( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~Player();
    
    // all player actions
    enum ACTIONS
    {
    	ACTION_NONE,
    	ACTION_PLAY_STOP,
    	ACTION_PAUSE_RESUME,
    	ACTION_VOLUME_UP,
    	ACTION_VOLUME_DOWN,
    	ACTION_MUTE,
    	ACTION_SEEK_F10,
    	ACTION_SEEK_B10,
    	ACTION_SEEK_F60,
    	ACTION_SEEK_B60,
    	ACTION_SEEK_F600,
    	ACTION_SEEK_B600,
    	ACTION_NEXT,
    	ACTION_PREV,
	ACTION_OSD,
	ACTION_SUBTITLES,
	ACTION_ADD_TO_PLAYLIST,
	ACTION_REMOVE_FROM_PLAYLIST,
	ACTION_PLAYLIST_UP,
	ACTION_PLAYLIST_DOWN,
	ACTION_FILE_INFO
    };

    enum FILE_MENU_ITEMS
    {
        FILE_OPEN,
        FILE_OPEN_URL,
        FILE_SAVE_PLAYLIST,
        FILE_SEPARATOR1,
        FILE_INFO,
        FILE_SEPARATOR2,
        FILE_PREFS
    };

    enum VIEW_MENU_ITEMS
    {
        VIEW_SCALE,
        VIEW_LCD_OFF,
        VIEW_SEPARATOR1,
        VIEW_PLAYLIST,
        VIEW_SLIDER
    };
    
private:
//    Control	*fscr_control;
    SlFileSelector	*slf;
    FileSelectionFilter* filter;
    
    QToolBar	*bar;
    QMenuBar	*menu;
    QPopupMenu	*m_fileMenu;
    QPopupMenu	*m_viewMenu;
    QPopupMenu	*m_helpMenu;
    QPopupMenu  *m_columnsMenu;
    
    QToolButton	*addToPls;
    QToolButton	*delFromPls;
    QToolButton	*info;
    
    QToolButton	*up;
    QToolButton	*down;
    
    QToolButton	*columns;
    
    QWidgetStack *stack;
    PlayerBase	*contents;
    SlDlgWait* wait;
    //PlaylistView *playlist;
    
    bool	useScale;
    bool	isPlaying;
    bool	isPausing;
    bool	isIdentify;
    bool	isAddToPlaylist;
    bool	isManualStop;
    bool	isRestartPlaying;
    bool	isLCDBlank;
    bool	isAutoplay;
    bool	isVideoFile;
    bool 	isIgnoreOutput;
    
    QString bufferUtf8;
    QString bufferLocal;
    
    QString		selectedFile;
    int			total_time;
    OProcess*	process;
    QColor		old_bg_color;
    QPixmap* 	splash;

    KinoPrefs	kinoPrefs;
    
    QString freq;

    bool isSlf;
    
    typedef QMap<QString, MediaInfo> MediaInfoMap;
    MediaInfoMap	minfo;
	
    QCopChannel *channel, *sysChannel, *freqChannel;	
    int intervalDim, intervalLightOff, intervalSuspend;

    void setSelectedFile(const QString& selectedFile)
    {
        if (selectedFile == "")
        {
            this->selectedFile = "";
            setCaption(tr("Kino2"));
            return;
        }

        
	if (selectedFile.find("://") == -1){
	  QFileInfo fi(selectedFile);
	  setCaption(fi.baseName() + " - " + tr("Kino2"));
	  this->selectedFile = fi.absFilePath();
	}else{
	  this->selectedFile = selectedFile;
	}
    }

    void loadSettings();
    void saveSettings();
    
    bool addUrl(const QString& url);
    bool addFile(const QFileInfo& fileInfo);
    bool addFolder(const QFileInfo& fileInfo);
    bool addPlaylist(const QFileInfo& fileInfo);
    
    void savePlaylist(const QString& file);
    
    void identifyFile(const QString& file);
    void identifyFile(const QStringList& files);
    
    void parseMediaInfo(const QString& file, const QString& strUtf8, const QString& strLocal);
    void toggleSuspend(bool enable);
    void showPlaylist(bool visible);
    void showSlider(bool visible);
    void sendCommand(const QString& str);
    void lcdOn();
    void lcdOff();
    void setupButtons();
    void addPlayitem(QStringList& args, QString file);
    
    void seek(int value, int type = 0);
    void pause();
    void resume();
    void stop();
    
    void volumeUp();
    void volumeDown();
    void readSystemVolume();
    void writeSystemVolume();
    
    void setVolume(int percent);
    void mute(bool toggled);	
    
    bool muted;
    int volumePercent;
    int currentPosition;
	
    int lookupActionForKey(int key);
    QString length(int seconds) const { return  QString().sprintf("%02d:%02d", seconds / 60, seconds % 60); };

    void set_freq(QString freq);

	
public slots:
    void displayFileInfo();
    void closeEvent(QCloseEvent *e);
    void keyPressed(QKeyEvent *, bool&);
    void slKeyPressed(QKeyEvent *, bool&);
    void loadPlaylist();

protected:
    void keyPressEvent(QKeyEvent *event);
    void slKeyPressEvent(QKeyEvent *event);

private slots:
    void fileMenu(int item);
    void viewMenu(int item);
    void helpMenu(int item);
    void columnsMenu(int item);
    void startClicked(void);
    void endClicked(void);
    void playClicked(void);
    void ejectClicked(void);
    void stopClicked(void);
    void revClicked(void);
    void fwdClicked(void);
    
//    void done(int status);
//    void block_in(const char* s, int len);

    void processExited(OProcess *proc);
    void receivedStdout(OProcess *proc, char *buffer, int buflen);
    void receivedStderr(OProcess *proc, char *buffer, int buflen);
    void wroteStdin(OProcess *proc);

    void addToPlaylist(void);
    void removeFromPlaylist(void);
    void currentChanged(QListViewItem* item);
    void clicked(QListViewItem* item);
    
    void sliderMoved(int value);
        
protected slots:
    void goodBye();
    void slFileSelected(const QFileInfo &fs);
    void batteryReceived(const QCString& msg, const QByteArray& data);


public slots:    
    void setDocument(const QCString& msg, const QByteArray& data);
    void setBlankLCD(const QCString& msg, const QByteArray& data);
    void volumeChanged(bool nowMuted);
};

#endif // _PLAYER_H_
