#include "playlist.h"

#include <qmime.h>
#include <qstrlist.h>
#include <qstringlist.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qfileinfo.h>
#include <qapplication.h>
#include <qheader.h>

#include <qpe/applnk.h> 

PlaylistView::PlaylistView(QWidget *parent, const char *name, bool /* sdo */)
    : QListView( parent, name), lastItem( NULL )
{
    // init column labels: Icon, Name, Type, Size, Album, Artist, Title, Playtime, Track
   	columnLabels << tr("FullName");
   	columnLabels << tr("");			// icon
   	columnLabels << tr("Name");
   	columnLabels << tr("Type");
   	columnLabels << tr("Size");
   	columnLabels << tr("Artist");
   	columnLabels << tr("Album");
   	columnLabels << tr("Title");
   	columnLabels << tr("Playtime");
   	columnLabels << tr("Track");

	for (QStringList::Iterator it = columnLabels.begin(); it != columnLabels.end(); ++it)
		int id = addColumn(*it);
		
    setColumnWidthMode(COLUMN_FULLNAME, Manual);
    setColumnWidth(COLUMN_FULLNAME, 0);
    
    header()->setClickEnabled(false, COLUMN_FULLNAME);
    header()->setResizeEnabled(false, COLUMN_FULLNAME);

    header()->setClickEnabled(false, COLUMN_ICON);
    header()->setResizeEnabled(false, COLUMN_ICON);
     
    setTreeStepSize(20);
    setSorting(-1);
    setAllColumnsShowFocus(true);
}

void PlaylistView::keyPressEvent(QKeyEvent *event)
{
	qDebug(QString("PlaylistView::keyPressEvent(): 0x") + QString::number(event->key(), 16) + " "+ QString::number(event->ascii()) + (" \"") + event->text() + "\"");

	bool accepted = event->isAccepted();
	emit keyPressed(event, accepted);
	
	QListView::keyPressEvent(event);
}

void PlaylistView::savePlaylist( const QString &name )
{
}

void PlaylistView::loadPlaylist( const QString &name )
{
    qDebug(name);
}

void PlaylistView::addToPlaylist( const QString &name, MediaInfo mi)
{
	qDebug("PlaylistView::addToPlaylist(): " + name);
	
    QFileInfo fileInfo(name);
    QListViewItem *currItem = new QListViewItem(this);
    
    // populate columns
	QString description = name.startsWith("http://") ? name : fileInfo.baseName();
	currItem->setText(COLUMN_FULLNAME, name);

    DocLnk lnk(name);
    currItem->setPixmap(COLUMN_ICON, lnk.pixmap());

	for (int i = COLUMN_NAME; i <= COLUMN_TRACK; i++)
		setColumnWidthMode(i, Manual);
    
    currItem->setText(COLUMN_NAME, description);
    currItem->setText(COLUMN_TYPE, fileInfo.extension());
    currItem->setText(COLUMN_SIZE, QString::number(fileInfo.size() / 1024) + " Kb");
    currItem->setText(COLUMN_ARTIST, mi.Artist);
    currItem->setText(COLUMN_ALBUM, mi.Album);
    currItem->setText(COLUMN_TITLE, mi.Title);
    currItem->setText(COLUMN_PLAYTIME, QString().sprintf("%02d:%02d", mi.LENGTH / 60, mi.LENGTH % 60));
    currItem->setText(COLUMN_TRACK, mi.Track);

    if (lastItem) currItem->moveItem(lastItem);
    lastItem = currItem;
    setCurrentItem(currItem);
}

void PlaylistView::removeFromPlaylist( void )
{
    QListViewItem *item = currentItem();
    if (item) 
    {
    	if (item->itemBelow())
    		setCurrentItem(item->itemBelow());
    	else if (item->itemAbove())
    		setCurrentItem(item->itemAbove());
    		
    	takeItem(item);
    	//delete item;
    }
}

void PlaylistView::up(void)
{
    QListViewItem *item = currentItem();
    if (item && item->itemAbove())
    {
    	item->itemAbove()->moveItem(item);
    	ensureItemVisible(item);
    }
}

void PlaylistView::down(void)
{
    QListViewItem *item = currentItem();
    if (item && item->itemBelow())
    {
    	item->moveItem(item->itemBelow());
    	ensureItemVisible(item);
    }
}

void PlaylistView::scrollBy(int dx, int dy)
{
	QListView::scrollBy(dx, dy);
	triggerUpdate();
}
