#ifndef _PLAYLIST_H_
#define _PLAYLIST_H_

#include <qlistview.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qfile.h>
#include <qarray.h>
#include <qlist.h>

#include "MediaInfo.h"

class QWidget;

class PlaylistView : public QListView
{
    Q_OBJECT
    
public:
	enum COLUMNS
	{
		COLUMN_FULLNAME,	// hidden
		COLUMN_ICON, 
		COLUMN_NAME, 
		COLUMN_TYPE, 
		COLUMN_SIZE, 
		COLUMN_ARTIST, 
		COLUMN_ALBUM, 
		COLUMN_TITLE, 
		COLUMN_PLAYTIME, 
		COLUMN_TRACK
	};
	
    PlaylistView( QWidget *parent = 0, const char *name = 0, bool sdo = FALSE );

    void savePlaylist( const QString &name );
    void loadPlaylist( const QString &name );

    void addToPlaylist( const QString &name, MediaInfo mi);
    void removeFromPlaylist( void );
    
    const QStringList& columns() const { return columnLabels; };
    
signals:
	void keyPressed(QKeyEvent *, bool&);
    
protected:
    void keyPressEvent(QKeyEvent *event);
    
private:
    QListViewItem *lastItem;
    QFile f;

    QStringList columnLabels;
    
public slots:
    void up(void);
    void down(void);
    void scrollBy(int dx, int dy);
};

#endif
