/*
 * Copyright (C) 2002 SHARP CORPORATION All rights reserved.
 */


#ifndef FEPINTERFACE_H
#define FEPINTERFACE_H

#include <qnamespace.h>
#include <qstring.h>
#include <qpe/qcom.h>

#ifndef QT_NO_COMPONENT
# ifndef IID_Fep
#  define IID_Fep QUuid( 0xf30b390c, 0xcee6, 0x4b81, 0xa8, 0x16, 0x16, 0x2d, 0xb6, 0x58, 0x1e, 0x3f)
# endif
#endif

enum IMStatusMode {
	NON_ACTIVE,						        
	WAIT_INPUT,						        
	INPUT_STATUS,					        
	COMPOSITION_STATUS,				        
	CANDIDATE_STATUS,				        
	ONKUN_STATUS,					        
	TANSYUKU_STATUS,                        
	SYNSYUKU_STATUS,				        
	PARTINPUT_STATUS,				        
	IM_OTHER_STATUS = 100			        
};

#ifdef QT_QWS_SHARP
#define COMPOSITION_WIN     0x01 	         
#define CANDIDATE_WIN       0x02	         
#define KEY_EVENT_FILTER    0x04	         
#define STATUS_WIN          0x08	         
#define FEP_NOT_WORK        0x10	         
#define NOT_CONVERTION_MODE 0x20	         

#define	CIM_None			0x01	          
#define CIM_Hiragana		0x02	          
#define	CIM_Katakana		0x04	          
#define	CIM_Alpanum			0x08	          
#define	CZM_Hankaku			0x40	          
#define	CZM_Zenkaku			0x80	          

#define FepConfigFileName   "fepmode.ja"      

#define FMode_GroupName      "FMode"          
#define FMode_KeyOnOff       "FModeOnOff"     
#define FMode_KeyInp         "FModeInp"       
#define FMode_KeyHen         "FModeHen"       
#define FMode_PadInp         "FModePad"       
#define FMode_CRimOnOff      "FModeCrimOnOff" 
#define FMode_FepDisableCt   "FModeDisableCt" 

#define FModeNo_KeyOnOff      0               
#define FModeNo_KeyInp        1               
#define FModeNo_KeyHen        2               
#define FModeNo_PadInp        3               
#define FModeNo_CRimOnOff     4               
#define FModeNo_FepOffDisable 5               
#define FModeNo_Dmy0          6
#define FModeNo_Dmy1          7
#define FModeNo_Dmy2          8
#define FModeNo_Dmy3          9
#define FModeNo_Dmy4          10
#define FModeNo_Dmy5          11
#define FModeNo_Dmy6          12
#define FModeNo_Dmy7          13
#define FModeNo_Dmy8          14
#define FModeNo_Dmy9          15
#define FModeNo_MAX           16              
#endif

class QWidget;
class QPixmap;
class QObject;

struct FepInterface : public QUnknownInterface
{
	
	virtual void		resetState()=0;
	virtual QPixmap		*icon()=0;
	virtual QString		name()=0;

	
	virtual QObject		*CreateIM(void)=0;
	virtual QObject		*CreateIM(QWidget *parent)=0;
	virtual QObject		*CreateIM(QRect rect,QPoint curpos,int IMMode)=0;
	virtual QObject		*CreateIM(QWidget *parent,QRect rect, QPoint curpos,
								  int IMMode)=0;
	virtual void		DeleteIM()=0;
	virtual void		startIM(void)=0;
	virtual void		endIM(void)=0;
	virtual QObject		*SetParentWidgetIM(QWidget *parent,QPoint pos,
										   QRect rect)=0;
	virtual QWidget		*GetParentWidgetIM(void)=0;
	virtual void		StartKeyEventFilter(void)=0;
	virtual void		EndKeyEventFilter(void)=0;
	virtual void		update(void)=0;
	virtual void		SetFocus(void)=0;
	virtual void		unSetFocus(void)=0;
	virtual bool        isReasonFocusOutFepWin(QFocusEvent *fe)=0;
	virtual bool		doKeyEvent(QObject* o,QEvent * e,int *result_dec,
								   int *result_douon,int *result_douon_disp,
								   int *result_inpmodechg,int *result_henmodechdg)=0;

	
	virtual int			GetIMStatus(void) = 0;
	virtual bool		GetIMStatusChg(int *result_dec, int *result_douon,
									   int *result_douon_disp,
									   int *result_inpmodechg,
									   int *result_henmodechdg)=0;
	virtual void		SetIMMode(int IMMode, bool isUseFep)=0;
	virtual bool		GetIMMode(int *IMMode)=0;
	virtual void		SetConversionMode(int set)=0;
	virtual int			GetConversionMode(void)=0;

	
	virtual void		SetCompositionCursorPos(QPoint pos)=0;
	virtual QPoint		GetCompositionCursorPos(void)=0;
	virtual void		SetCompositionWindowRect(QRect rect)=0;
	virtual QRect		GetCompositionWindowRect(void)=0;
	virtual void		SetCompositionWindowFont(QFont &font)=0;
	virtual QFont		GetCompositionWindowFont(void)=0;
	virtual void		SetCompositionWindowColorFg(QColor &fg)=0;
	virtual QColor		GetCompositionWindowColorFg(void)=0;
	virtual void		SetCompositionWindowColorBg(QColor &bg)=0;
	virtual QColor		GetCompositionWindowColorBg(void)=0;

	
	virtual void		SetCandidateWindowPos(QPoint &gl_pos,
											  bool setBtmLeft)=0;
	virtual QPoint		GetCandidateWindowPos(bool *getBtmLeft)=0;
	virtual void		SetCandidateWindowRect(QRect &gl_rect,
											   bool setBtmLeft)=0;
	virtual QRect		GetCandidateWindowRect(bool *getBtmLeft)=0;
	virtual void		SetCandidateWindowFont(QFont &font)=0;
	virtual QFont		GetCandidateWindowFont(void)=0;
	virtual void		SetCandidateWindowColorFg(QColor &fg)=0;
	virtual QColor		GetCandidateWindowColorFg(void)=0;
	virtual void		SetCandidateWindowColorBg(QColor &bg)=0;
	virtual QColor		GetCandidateWindowColorBg(void)=0;
	virtual bool        isOpenCandidateWindow(void)=0;

	
	virtual QStringList	GetCompositionString(void)=0;
	virtual QStringList	GetCandidateStringList(void)=0;
	virtual QString		GetDecideString(void)=0;
	virtual QString		GetReadingString(void)=0;
	virtual void		SetInputString(QString &inputstr)=0;

	
	virtual void		SetEditCursorNo(int no)=0;
	virtual int			GetEditCursorNo(void)=0;
	virtual void		SetAttentionPharseNo(int no)=0;
	virtual int			GetAttentionPharseNo(void)=0;
	virtual void		SetDouonSelectNo(int no)=0;
	virtual int			GetDouonSelectNo(void)=0;

	
	virtual void		SetPadMode(int set)=0;
	virtual int			GetPadMode(void)=0;

	
	virtual bool        setFepUse(void)=0;
	virtual bool        resetFepUse(void)=0;
	virtual bool        isFepUse(void)=0;

	
	virtual void		SetDouonJumpNo(int no)=0;
	virtual bool		directKUI(int InEventType,
								  int InEventCode,
								  int InEventParam,
								  uchar *InEventString,
								  int *result_dec,
								  int *result_douon,
								  int *result_douon_disp,
								  int *result_inpmodechg,
								  int *result_henmodechdg)=0;
};


#endif		

