/*
 * Copyright (C) 2002 SHARP CORPORATION All rights reserved.
 */
#ifndef _SLCATEGORIES_H_INCLUDED
#define _SLCATEGORIES_H_INCLUDED

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <sl/slzdtm.h>

namespace SlCategory {

using namespace SlZDtm;

class SlCategoriesPrivate;
class SlCategories
{
public:
	SlCategories(const char *filerBoxName=NULL);
	~SlCategories();
	bool open();
	bool close();
	int addCategory(const QString &name);
	int addSystemCategory(const QString &name);
	bool removeCategory(const QString &name);
	int id(const QString &name) const;
    QArray<int> ids(const QStringList &labels) const;
	QString label(int id) const;
	QStringList labels(bool includesUnfiled=true) const;
	bool exists(const QString &name) const;
	bool renameCategory(const QString &oldName,const QString &newName);
	bool isSystemCategory(const QString &name) const;
	bool isSystemCategory(int id) const;

	static bool createFile(const char* path=0);
	static QString boxFileName();
	static QString indexFileName();

private:
	SlCategoriesPrivate *p;
};

} 

#endif 
